/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.subsystem;

import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessage;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.net.j2ssh.util.OpenClosedState;
import com.enterprisedt.util.debug.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubsystemMessageStore {
    private static Logger a = Logger.getLogger("SubsystemMessageStore");
    protected List messages = new ArrayList();
    protected Map registeredMessages = new HashMap();
    private OpenClosedState b = new OpenClosedState(1);

    public synchronized void addMessage(SubsystemMessage msg) {
        if (a.isDebugEnabled()) {
            a.debug("Received " + msg.getMessageName() + " subsystem message");
        }
        this.messages.add(msg);
        this.notifyAll();
    }

    public synchronized void addMessage(byte[] msgdata) throws InvalidMessageException {
        try {
            Class clazz = (Class)this.registeredMessages.get(new Integer(msgdata[0]));
            if (clazz == null) {
                throw new InvalidMessageException("The message with id " + String.valueOf(msgdata[0]) + " is not implemented");
            }
            SubsystemMessage subsystemMessage = (SubsystemMessage)clazz.newInstance();
            this.constructMessage(subsystemMessage, msgdata);
            this.addMessage(subsystemMessage);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        throw new InvalidMessageException("Could not instantiate message class");
    }

    protected void constructMessage(SubsystemMessage msg, byte[] msgdata) throws InvalidMessageException {
        msg.fromByteArray(msgdata);
    }

    public synchronized SubsystemMessage nextMessage() throws MessageStoreEOFException {
        try {
            return this.nextMessage(0);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            return null;
        }
    }

    public synchronized SubsystemMessage nextMessage(int timeout) throws MessageStoreEOFException, MessageNotAvailableException {
        int n2 = timeout = timeout > 0 ? timeout : 0;
        while (this.messages.size() <= 0) {
            try {
                this.wait(timeout);
                if (timeout <= 0) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (this.b.getValue() != 1) {
            throw new MessageStoreEOFException();
        }
        if (this.messages.size() > 0) {
            return (SubsystemMessage)this.messages.remove(0);
        }
        throw new MessageNotAvailableException();
    }

    public void registerMessage(int messageId, Class implementor) {
        this.registeredMessages.put(new Integer(messageId), implementor);
    }

    public OpenClosedState getState() {
        return this.b;
    }

    public synchronized void close() {
        this.b.setValue(2);
        this.notifyAll();
    }
}

