/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.cipher;

import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CBC_128;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CBC_192;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CBC_256;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CTR_128;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CTR_192;
import com.enterprisedt.net.j2ssh.transport.cipher.AES_CTR_256;
import com.enterprisedt.net.j2ssh.transport.cipher.ArcFour;
import com.enterprisedt.net.j2ssh.transport.cipher.BlowfishCbc;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipher;
import com.enterprisedt.net.j2ssh.transport.cipher.TripleDesCbc;
import com.enterprisedt.util.debug.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SshCipherFactory {
    private static String a = "3des-cbc";
    private static String b = "blowfish-cbc";
    private static Map c;
    private static String d;
    private static Logger e;
    private ArrayList f = new ArrayList(c.keySet());

    public static void initialize() {
    }

    public static String getDefaultCipher() {
        return d;
    }

    public static List getSupportedCiphers() {
        return new ArrayList(c.keySet());
    }

    public List getEnabledCiphers() {
        return this.f;
    }

    public void disableAllCiphers() {
        this.f.clear();
    }

    public void setCipherEnabled(String algorithmName, boolean enable) throws AlgorithmNotSupportedException {
        if (!c.containsKey(algorithmName)) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!");
        }
        if (enable) {
            if (!this.f.contains(algorithmName)) {
                this.f.add(algorithmName);
            }
        } else {
            this.f.remove(algorithmName);
        }
    }

    public boolean isCipherEnabled(String algorithmName) {
        return this.f.contains(algorithmName);
    }

    public static SshCipher newInstance(String algorithmName) throws AlgorithmNotSupportedException {
        e.debug("Creating new " + algorithmName + " cipher instance");
        try {
            return (SshCipher)((Class)c.get(algorithmName)).newInstance();
        }
        catch (Throwable throwable) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!", throwable);
        }
    }

    static {
        e = Logger.getLogger("SshCipherFactory");
        c = new LinkedHashMap();
        e.debug("Loading supported cipher algorithms");
        c.put("aes128-cbc", AES_CBC_128.class);
        c.put(a, TripleDesCbc.class);
        c.put("aes192-cbc", AES_CBC_192.class);
        c.put("aes256-cbc", AES_CBC_256.class);
        c.put("aes128-ctr", AES_CTR_128.class);
        c.put("aes192-ctr", AES_CTR_192.class);
        c.put("aes256-ctr", AES_CTR_256.class);
        c.put(b, BlowfishCbc.class);
        c.put("arcfour", ArcFour.class);
        d = b;
    }
}

