/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.kex;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgKexDhGexRequest
extends SshMessage {
    protected static final int SSH_MSG_KEX_DH_GEX_REQUEST_OLD = 30;
    protected static final int SSH_MSG_KEX_DH_GEX_REQUEST = 34;
    public static int DH_GROUP_EXCHANGE_MIN_SIZE = 1024;
    public static int DH_PREFERRED_GROUP_EXCHANGE_SIZE = 2048;
    public static int DH_GROUP_EXCHANGE_MAX_SIZE = 8192;

    public SshMsgKexDhGexRequest() {
        super(34);
    }

    public int getDhPreferredGroupSize() {
        return DH_PREFERRED_GROUP_EXCHANGE_SIZE;
    }

    @Override
    public String getMessageName() {
        return "SSH_MSG_KEX_DH_GEX_REQUEST";
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(",DH_GROUP_EXCHANGE_MIN_SIZE=").append(DH_GROUP_EXCHANGE_MIN_SIZE);
        stringBuffer.append(",DH_PREFERRED_GROUP_SIZE=").append(DH_PREFERRED_GROUP_EXCHANGE_SIZE);
        stringBuffer.append(",DH_GROUP_EXCHANGE_MAX_SIZE=").append(DH_GROUP_EXCHANGE_MAX_SIZE);
        return stringBuffer.toString();
    }

    @Override
    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeInt(DH_GROUP_EXCHANGE_MIN_SIZE);
            baw.writeInt(DH_PREFERRED_GROUP_EXCHANGE_SIZE);
            baw.writeInt(DH_GROUP_EXCHANGE_MAX_SIZE);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error writing message data", iOException);
        }
    }

    @Override
    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        throw new InvalidMessageException("Not implemented");
    }
}

