/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaKeyPair;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SshKeyPairFactory {
    private static String a = "ssh-dss";
    private static String b = "ssh-rsa";
    private static Map c;
    private static String d;
    private static Logger e;
    private ArrayList f = new ArrayList(c.keySet());

    public static void initialize() {
    }

    public static String getDefaultPublicKey() {
        return d;
    }

    public List getEnabledKeyPairs() {
        return this.f;
    }

    public void disableAllKeys() {
        this.f.clear();
    }

    public void setPreferredKeyPair(String keyPair) {
        e.debug("Setting preferred keypair = " + keyPair);
        if (!c.containsKey(keyPair)) {
            e.warn(keyPair + " not set to preferred as not supported");
        } else {
            if (this.f.contains(keyPair)) {
                this.f.remove(keyPair);
            }
            this.f.add(0, keyPair);
        }
    }

    public void setKeyEnabled(String algorithmName, boolean enable) throws AlgorithmNotSupportedException {
        if (!c.containsKey(algorithmName)) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!");
        }
        if (enable) {
            if (!this.f.contains(algorithmName)) {
                this.f.add(algorithmName);
            }
        } else {
            this.f.remove(algorithmName);
        }
    }

    public boolean isKeyEnabled(String algorithmName) {
        return this.f.contains(algorithmName);
    }

    public static SshKeyPair newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyPair)((Class)c.get(methodName)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(methodName + " is not supported!", exception);
        }
    }

    public static boolean supportsKey(String algorithm) {
        return c.containsKey(algorithm);
    }

    public static SshPrivateKey decodePrivateKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePrivateKey(encoded);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException);
        }
    }

    public static SshPublicKey decodePublicKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePublicKey(encoded);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException);
        }
    }

    static {
        e = Logger.getLogger("SshKeyPairFactory");
        c = new LinkedHashMap();
        e.debug("Loading public key algorithms");
        c.put(a, SshDssKeyPair.class);
        c.put(b, SshRsaKeyPair.class);
        d = a;
    }
}

