/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.openssh.OpenSSHPrivateKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.PuTTYPrivateKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshDotComPrivateKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshtoolsPrivateKeyFormat;
import com.enterprisedt.util.debug.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class SshPrivateKeyFormatFactory {
    private static String a;
    private static HashMap b;
    private static Logger c;
    private static Vector d;

    public static List getSupportedFormats() {
        return d;
    }

    public static void initialize() {
    }

    public static SshPrivateKeyFormat newInstance(String type) throws InvalidSshKeyException {
        try {
            if (b.containsKey(type)) {
                return (SshPrivateKeyFormat)((Class)b.get(type)).newInstance();
            }
            throw new InvalidSshKeyException("The format type " + type + " is not supported");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidSshKeyException("Illegal access to class implementation of " + type, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidSshKeyException("Failed to create instance of format type " + type, instantiationException);
        }
    }

    public static String getDefaultFormatType() {
        return a;
    }

    static {
        c = Logger.getLogger("SshPrivateKeyFormatFactory");
        c.debug("Loading private key formats");
        d = new Vector();
        b = new HashMap();
        OpenSSHPrivateKeyFormat openSSHPrivateKeyFormat = new OpenSSHPrivateKeyFormat();
        c.debug("Installing " + openSSHPrivateKeyFormat.getFormatType() + " private key format");
        b.put(openSSHPrivateKeyFormat.getFormatType(), OpenSSHPrivateKeyFormat.class);
        d.add(openSSHPrivateKeyFormat.getFormatType());
        SshDotComPrivateKeyFormat sshDotComPrivateKeyFormat = new SshDotComPrivateKeyFormat();
        c.debug("Installing " + sshDotComPrivateKeyFormat.getFormatType() + " private key format");
        b.put(sshDotComPrivateKeyFormat.getFormatType(), SshDotComPrivateKeyFormat.class);
        d.add(sshDotComPrivateKeyFormat.getFormatType());
        PuTTYPrivateKeyFormat puTTYPrivateKeyFormat = new PuTTYPrivateKeyFormat();
        c.debug("Installing " + puTTYPrivateKeyFormat.getFormatType() + " private key format");
        b.put(puTTYPrivateKeyFormat.getFormatType(), PuTTYPrivateKeyFormat.class);
        d.add(puTTYPrivateKeyFormat.getFormatType());
        SshtoolsPrivateKeyFormat sshtoolsPrivateKeyFormat = new SshtoolsPrivateKeyFormat();
        c.debug("Installing " + sshtoolsPrivateKeyFormat.getFormatType() + " private key format");
        b.put(sshtoolsPrivateKeyFormat.getFormatType(), SshtoolsPrivateKeyFormat.class);
        d.add(sshtoolsPrivateKeyFormat.getFormatType());
        a = openSSHPrivateKeyFormat.getFormatType();
    }
}

