/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.dsa;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssPublicKey;
import com.enterprisedt.net.j2ssh.util.SimpleASNReader;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;

class a
extends SshPrivateKey {
    private static Logger b = Logger.getLogger("com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssPrivateKey");
    DSAPrivateKey a;

    public a(DSAPrivateKey dSAPrivateKey) {
        this.a = dSAPrivateKey;
    }

    public a(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                String string2 = "Header '" + string + "' does not match algorithm name '" + this.getAlgorithmName() + "'";
                b.error(string2);
                throw new InvalidSshKeyException(string2);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.a = (DSAPrivateKey)keyFactory.generatePrivate(dSAPrivateKeySpec);
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            throw invalidSshKeyException;
        }
        catch (Exception exception) {
            String string = "Failed to create private key";
            b.error(string, exception);
            throw new InvalidSshKeyException(exception);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof a) {
            return this.a.equals(((a)obj).a);
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    @Override
    public String getAlgorithmName() {
        return "ssh-dss";
    }

    @Override
    public int getBitLength() {
        return this.a.getX().bitLength();
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString("ssh-dss");
            byteArrayWriter.writeBigInteger(this.a.getParams().getP());
            byteArrayWriter.writeBigInteger(this.a.getParams().getQ());
            byteArrayWriter.writeBigInteger(this.a.getParams().getG());
            byteArrayWriter.writeBigInteger(this.a.getX());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            b.error("getPublicKey()", iOException);
            return null;
        }
    }

    @Override
    public SshPublicKey getPublicKey() {
        try {
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.a(), this.a.getParams().getP(), this.a.getParams().getQ(), this.a.getParams().getG());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return new SshDssPublicKey((DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec));
        }
        catch (Exception exception) {
            b.error("getPublicKey()", exception);
            return null;
        }
    }

    @Override
    public byte[] generateSignature(byte[] data) throws InvalidSshKeySignatureException {
        try {
            Object object;
            Signature signature = Signature.getInstance("SHA1withDSA", "CryptixEDT");
            signature.initSign(this.a);
            signature.update(data);
            byte[] byArray = signature.sign();
            byte[] byArray2 = new byte[40];
            SimpleASNReader simpleASNReader = new SimpleASNReader(byArray);
            simpleASNReader.getByte();
            simpleASNReader.getLength();
            simpleASNReader.getByte();
            byte[] byArray3 = simpleASNReader.getData();
            simpleASNReader.getByte();
            byte[] byArray4 = simpleASNReader.getData();
            if (byArray3.length >= 20) {
                System.arraycopy(byArray3, byArray3.length - 20, byArray2, 0, 20);
            } else {
                System.arraycopy(byArray3, 0, byArray2, 20 - byArray3.length, byArray3.length);
            }
            if (byArray4.length >= 20) {
                System.arraycopy(byArray4, byArray4.length - 20, byArray2, 20, 20);
            } else {
                System.arraycopy(byArray4, 0, byArray2, 20 + (20 - byArray4.length), byArray4.length);
            }
            if (b.isDebugEnabled()) {
                int n2;
                b.debug("s length is " + String.valueOf(byArray4.length));
                b.debug("r length is " + String.valueOf(byArray3.length));
                object = "";
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    object = (String)object + Integer.toHexString(byArray[n2] & 0xFF) + " ";
                }
                b.debug("Java signature is " + (String)object);
                object = "";
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    object = (String)object + Integer.toHexString(byArray2[n2] & 0xFF) + " ";
                }
                b.debug("SSH signature is " + (String)object);
            }
            object = new ByteArrayWriter();
            ((ByteArrayWriter)object).writeString(this.getAlgorithmName());
            ((ByteArrayWriter)object).writeBinaryString(byArray2);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            throw new InvalidSshKeySignatureException(exception);
        }
    }

    private BigInteger a() {
        return this.a.getParams().getG().modPow(this.a.getX(), this.a.getParams().getP());
    }
}

