/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.crypto;

import com.enterprisedt.net.puretls.crypto.DHPublicKey;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.SecureRandom;

public abstract class DHPrivateKey
implements PrivateKey {
    protected BigInteger X;
    protected BigInteger Y;
    protected BigInteger g;
    protected BigInteger p;

    public abstract void initPrivateKey(BigInteger var1, BigInteger var2, SecureRandom var3);

    public abstract void initPrivateKey(SecureRandom var1, int var2, boolean var3);

    public abstract byte[] keyAgree(DHPublicKey var1, boolean var2);

    public static DHPrivateKey getInstance() {
        String string = "com.enterprisedt.net.puretls.SSLDHPrivateKey";
        try {
            Class<?> clazz = Class.forName(string);
            return (DHPrivateKey)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError("Couldn't find DH class" + string);
        }
    }

    protected byte[] toBytes(BigInteger num) {
        byte[] byArray = num.toByteArray();
        int n2 = 0;
        for (n2 = 0; n2 < byArray.length && byArray[n2] == 0; ++n2) {
        }
        int n3 = n2;
        if (n3 > 0) {
            byte[] byArray2 = new byte[byArray.length - n3];
            if (n3 == byArray.length) {
                throw new InternalError("Can't trim whole array");
            }
            System.arraycopy(byArray, n3, byArray2, 0, byArray.length - n3);
            return byArray2;
        }
        return byArray;
    }

    public BigInteger getX() {
        return this.X;
    }

    public BigInteger getY() {
        return this.Y;
    }

    public byte[] getYBytes() {
        return this.toBytes(this.Y);
    }

    public BigInteger getg() {
        return this.g;
    }

    public byte[] getgBytes() {
        return this.toBytes(this.g);
    }

    public BigInteger getp() {
        return this.p;
    }

    public byte[] getpBytes() {
        return this.toBytes(this.p);
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }
}

