/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.compression.jzlib;

import com.enterprisedt.util.compression.jzlib.ZStream;
import com.enterprisedt.util.compression.jzlib.ZStreamException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZInputStream
extends FilterInputStream {
    protected ZStream z = new ZStream();
    protected int bufsize = 512;
    protected int flush = 0;
    protected byte[] buf = new byte[this.bufsize];
    protected byte[] buf1 = new byte[1];
    protected boolean compress;
    protected InputStream in = null;
    private boolean a = false;

    public ZInputStream(InputStream in) {
        this(in, false);
    }

    public ZInputStream(InputStream in, boolean nowrap) {
        super(in);
        this.in = in;
        this.z.inflateInit(nowrap);
        this.compress = false;
        this.z.next_in = this.buf;
        this.z.next_in_index = 0;
        this.z.avail_in = 0;
    }

    public ZInputStream(InputStream in, int level) {
        super(in);
        this.in = in;
        this.z.deflateInit(level);
        this.compress = true;
        this.z.next_in = this.buf;
        this.z.next_in_index = 0;
        this.z.avail_in = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.buf1, 0, 1) == -1) {
            return -1;
        }
        return this.buf1[0] & 0xFF;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int n2;
        if (len == 0) {
            return 0;
        }
        this.z.next_out = b2;
        this.z.next_out_index = off;
        this.z.avail_out = len;
        do {
            if (this.z.avail_in == 0 && !this.a) {
                this.z.next_in_index = 0;
                this.z.avail_in = this.in.read(this.buf, 0, this.bufsize);
                if (this.z.avail_in == -1) {
                    this.z.avail_in = 0;
                    this.a = true;
                }
            }
            n2 = this.compress ? this.z.deflate(this.flush) : this.z.inflate(this.flush);
            if (this.a && n2 == -5) {
                return -1;
            }
            if (n2 != 0 && n2 != 1) {
                throw new ZStreamException((this.compress ? "de" : "in") + "flating: " + this.z.msg);
            }
            if (!this.a && n2 != 1 || this.z.avail_out != len) continue;
            return -1;
        } while (this.z.avail_out == len && n2 == 0);
        return len - this.z.avail_out;
    }

    @Override
    public long skip(long n2) throws IOException {
        int n3 = 512;
        if (n2 < (long)n3) {
            n3 = (int)n2;
        }
        byte[] byArray = new byte[n3];
        return this.read(byArray);
    }

    public int getFlushMode() {
        return this.flush;
    }

    public void setFlushMode(int flush) {
        this.flush = flush;
    }

    public long getTotalIn() {
        return this.z.total_in;
    }

    public long getTotalOut() {
        return this.z.total_out;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

