/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.license;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.rsa.RSAAlgorithm;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.cryptix.util.core.BI;
import com.enterprisedt.util.license.LicenseCipher;
import com.enterprisedt.util.license.LicensePKCS7;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import xjava.security.AsymmetricCipher;
import xjava.security.interfaces.RSAKey;

public class LicenseRawRSACipher
extends LicenseCipher
implements Cloneable,
AsymmetricCipher {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private int f;
    private byte[] g;

    public LicenseRawRSACipher() {
        super(false, false, "");
        this.engineSetPaddingScheme(new LicensePKCS7());
    }

    @Override
    protected void engineInitEncrypt(Key key) throws InvalidKeyException {
        if (!(key instanceof RSAKey)) {
            throw new InvalidKeyException("Not an RSA key");
        }
        RSAKey rSAKey = (RSAKey)((Object)key);
        this.a = rSAKey.getModulus();
        this.b = rSAKey.getExponent();
        this.a();
    }

    @Override
    protected void engineInitDecrypt(Key key) throws InvalidKeyException {
        if (!(key instanceof RSAKey)) {
            throw new InvalidKeyException("Not an RSA key");
        }
        RSAKey rSAKey = (RSAKey)((Object)key);
        this.a = rSAKey.getModulus();
        this.b = rSAKey.getExponent();
        this.a();
    }

    private void a() {
        this.f = BI.getMagnitude(this.a).length;
        this.g = new byte[this.f];
    }

    @Override
    protected int enginePlaintextBlockSize() {
        if (this.f == 0) {
            throw new CryptixException(this.getAlgorithm() + ": Block size is not valid until key is set");
        }
        return this.f - 1;
    }

    @Override
    protected int engineCiphertextBlockSize() {
        if (this.f == 0) {
            throw new CryptixException(this.getAlgorithm() + ": Block size is not valid until key is set");
        }
        return this.f;
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        if (inLen < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n2 = this.getState() == 1 ? this.enginePlaintextBlockSize() : this.engineCiphertextBlockSize();
        int n3 = this.getState() == 1 ? this.engineCiphertextBlockSize() : this.enginePlaintextBlockSize();
        int n4 = inLen / n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            ArrayUtil.clear(this.g);
            System.arraycopy(in, inOffset, this.g, this.g.length - n2, n2);
            BigInteger bigInteger = new BigInteger(1, this.g);
            if (bigInteger.compareTo(this.a) >= 0) {
                throw new CryptixException(this.getAlgorithm() + ": Input block value is out of range (>= modulus)");
            }
            BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.a, this.b, this.c, this.d, this.e);
            byte[] byArray = BI.getMagnitude(bigInteger2);
            if (byArray.length > n3) {
                throw new ArrayIndexOutOfBoundsException("Decryption failed, wrong key?");
            }
            ArrayUtil.clear(this.g);
            System.arraycopy(byArray, 0, this.g, n3 - byArray.length, byArray.length);
            System.arraycopy(this.g, 0, out, outOffset, n3);
            inOffset += n2;
            outOffset += n3;
        }
        return n4 * n3;
    }
}

