/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.HighlightJButton;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class ButtonFactory {
    private static boolean useHighlightButtons = false;
    private static boolean useButtonIcons = false;
    private static HashMap<String, String> panelButtonMnemonics = new HashMap();
    private static HashMap<String, String> reservedButtonMnemonics = new HashMap();

    public static void useButtonIcons() {
        ButtonFactory.useButtonIcons(true);
    }

    public static void useButtonIcons(boolean useit) {
        if (System.getProperty("mrj.version") == null) {
            useButtonIcons = useit;
        }
    }

    public static void useHighlightButtons() {
        ButtonFactory.useHighlightButtons(true);
    }

    public static void useHighlightButtons(boolean useit) {
        if (System.getProperty("mrj.version") == null) {
            useHighlightButtons = useit;
        }
        ButtonFactory.useButtonIcons(useit);
    }

    public static JButton createButton(Icon icon, Color color) {
        JButton result = useHighlightButtons ? (useButtonIcons ? new HighlightJButton(icon, color) : new HighlightJButton("", color)) : (useButtonIcons ? new JButton(icon) : new JButton());
        return ButtonFactory.addEnterKeyAction(result);
    }

    public static JButton createButton(String text, Color color) {
        JButton result = useHighlightButtons ? new HighlightJButton(text, color) : new JButton(text);
        ButtonFactory.setButtonMnemonic(result, panelButtonMnemonics);
        return result;
    }

    public static JButton createButton(String text, Icon icon, Color color) {
        JButton result = useHighlightButtons ? (useButtonIcons ? new HighlightJButton(text, icon, color) : new HighlightJButton(text, color)) : (useButtonIcons ? new JButton(text, icon) : new JButton(text));
        ButtonFactory.setButtonMnemonic(result, panelButtonMnemonics);
        return ButtonFactory.addEnterKeyAction(result);
    }

    public static JButton createButton(Action a2, Color color) {
        JButton result = useHighlightButtons ? new HighlightJButton(a2, color) : new JButton(a2);
        return ButtonFactory.addEnterKeyAction(result);
    }

    private static JButton addEnterKeyAction(JButton button) {
        ActionListener spacePress = button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false));
        ActionListener spaceRelease = button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true));
        ActionListener enterPress = button.getActionForKeyStroke(KeyStroke.getKeyStroke(10, 0, false));
        ActionListener enterRelease = button.getActionForKeyStroke(KeyStroke.getKeyStroke(10, 0, true));
        if (spacePress != null && spaceRelease != null && enterPress == null && enterRelease == null) {
            button.registerKeyboardAction(spacePress, null, KeyStroke.getKeyStroke(10, 0, false), 0);
            button.registerKeyboardAction(spaceRelease, null, KeyStroke.getKeyStroke(10, 0, true), 0);
        }
        return button;
    }

    private static void setButtonMnemonic(JButton button, HashMap<String, String> map) {
        String key;
        String text = button.getText();
        if (text != null && (key = ButtonFactory.findMnemonic(text)) != null) {
            button.setMnemonic(key.charAt(0));
            map.put(key, text);
        }
    }

    private static String findMnemonic(String text) {
        String key = null;
        for (String caption = text.toLowerCase(); caption != null && caption.length() > 0; caption = caption.substring(1)) {
            key = String.valueOf(caption.charAt(0));
            if (panelButtonMnemonics.containsKey(key) || reservedButtonMnemonics.containsKey(key)) {
                continue;
            }
            return key;
        }
        return null;
    }

    public static void reserveButtonMnemonics(JButton[] buttons) {
        for (JButton button : buttons) {
            ButtonFactory.setButtonMnemonic(button, reservedButtonMnemonics);
        }
    }

    public static void clearPanelButtonMnemonics() {
        panelButtonMnemonics.clear();
    }

    public static void clearReservedButtonMnemonics() {
        reservedButtonMnemonics.clear();
    }

    public static void clearAllMnemonics() {
        ButtonFactory.clearPanelButtonMnemonics();
        ButtonFactory.clearReservedButtonMnemonics();
    }
}

