/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.panels.userinput.field.AbstractFieldView;
import com.izforge.izpack.panels.userinput.field.custom.CustomFieldType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class UserInputPanelAutomationHelper
implements PanelAutomation {
    private static final Logger logger = Logger.getLogger(UserInputPanelAutomationHelper.class.getName());
    private static final String AUTO_KEY_ENTRY = "entry";
    private static final String AUTO_ATTRIBUTE_KEY = "key";
    private static final String AUTO_ATTRIBUTE_VALUE = "value";
    private List<? extends AbstractFieldView> views;

    public UserInputPanelAutomationHelper() {
    }

    public UserInputPanelAutomationHelper(List<? extends AbstractFieldView> views) {
        this.views = views;
    }

    @Override
    public void createInstallationRecord(InstallData installData, IXMLElement rootElement) {
        HashSet<String> omitFromAutoSet = new HashSet<String>();
        Map<String, String> entries = this.generateEntries(installData, this.views, omitFromAutoSet);
        for (String key : entries.keySet()) {
            XMLElementImpl dataElement = new XMLElementImpl(AUTO_KEY_ENTRY, rootElement);
            dataElement.setAttribute(AUTO_ATTRIBUTE_KEY, key);
            String value = omitFromAutoSet.contains(key) ? "" : entries.get(key);
            dataElement.setAttribute(AUTO_ATTRIBUTE_VALUE, value);
            rootElement.addChild(dataElement);
        }
    }

    private Map<String, String> generateEntries(InstallData installData, List<? extends AbstractFieldView> views, HashSet<String> omitFromAutoSet) {
        HashMap<String, String> entries = new HashMap<String, String>();
        for (AbstractFieldView abstractFieldView : views) {
            if (!abstractFieldView.isDisplayed()) continue;
            String variable = abstractFieldView.getField().getVariable();
            if (variable != null) {
                String entry = installData.getVariable(variable);
                if (abstractFieldView.getField().getOmitFromAuto()) {
                    omitFromAutoSet.add(variable);
                }
                entries.put(variable, entry);
            }
            List<Object> namedVariables = new ArrayList();
            if (abstractFieldView instanceof CustomFieldType) {
                CustomFieldType customField = (CustomFieldType)((Object)abstractFieldView);
                namedVariables = customField.getVariables();
            }
            for (String numberedVariable : namedVariables) {
                entries.put(numberedVariable, installData.getVariable(numberedVariable));
            }
        }
        return entries;
    }

    @Override
    public void runAutomated(InstallData idata, IXMLElement panelRoot) throws InstallerException {
        List<IXMLElement> userEntries = panelRoot.getChildrenNamed(AUTO_KEY_ENTRY);
        HashSet<String> blockedVariablesList = new HashSet<String>();
        Variables variables = idata.getVariables();
        for (IXMLElement dataElement : userEntries) {
            String variable = dataElement.getAttribute(AUTO_ATTRIBUTE_KEY);
            String value = dataElement.getAttribute(AUTO_ATTRIBUTE_VALUE);
            value = variables.replace(value);
            logger.fine("Setting variable " + variable + " to " + value);
            idata.setVariable(variable, value);
            blockedVariablesList.add(variable);
        }
        idata.getVariables().registerBlockedVariableNames(blockedVariablesList, panelRoot.getName());
    }

    @Override
    public void processOptions(InstallData installData, Overrides overrides) {
    }
}

