/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console.custom;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.FieldCommand;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.UserInputPanelSpec;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.custom.Column;
import com.izforge.izpack.panels.userinput.field.custom.CustomField;
import com.izforge.izpack.panels.userinput.field.custom.CustomFieldType;
import com.izforge.izpack.util.Console;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConsoleCustomField
extends ConsoleField
implements CustomFieldType {
    private final UserInputPanelSpec userInputPanelSpec;
    private final IXMLElement spec;
    private final FieldCommand createField;
    private int numberOfRows = 0;
    private int numberOfColumns = 0;
    private final CustomField customInfoField;
    private final int maxRow;
    private final int minRow;
    private static final int CONTINUE = 1;
    private static final int REDISPLAY = 2;
    Map<Integer, List<ConsoleField>> consoleFields;

    public ConsoleCustomField(CustomField customField, Console console, Prompt prompt, FieldCommand createField, UserInputPanelSpec userInputPanelSpec, IXMLElement spec) {
        super(customField, console, prompt);
        this.spec = spec;
        this.userInputPanelSpec = userInputPanelSpec;
        this.createField = createField;
        this.customInfoField = customField;
        this.maxRow = customField.getMaxRow();
        this.minRow = customField.getMinRow();
        this.numberOfColumns = customField.getFields().size();
    }

    @Override
    public CustomField getField() {
        return (CustomField)super.getField();
    }

    private void addInitialRows() {
        for (int count = this.minRow; count >= 1; --count) {
            this.addRow();
        }
    }

    private void showInitialRows() {
        for (int i2 = 1; i2 <= this.numberOfRows; ++i2) {
            this.editRow(i2, true);
        }
    }

    private boolean editRow(int rowNumber, boolean initial) {
        List<ConsoleField> fields = this.consoleFields.get(rowNumber);
        this.print("--> Row " + rowNumber + ": ");
        for (ConsoleField field : fields) {
            field.setDisplayed(true);
            boolean ro = field.isReadonly();
            if (initial) {
                field.setReadonly(true);
                field.getField().setValue(field.getField().getInitialValue());
            }
            while (!field.display()) {
            }
            if (!initial) continue;
            field.setReadonly(ro);
        }
        return true;
    }

    private boolean canAddRow() {
        return this.numberOfRows < this.maxRow;
    }

    private boolean addRow() {
        if (!this.canAddRow()) {
            return false;
        }
        ++this.numberOfRows;
        ArrayList<ConsoleField> fields = new ArrayList<ConsoleField>();
        for (Field field : this.createCustomField(this.userInputPanelSpec, this.spec).getFields()) {
            field.setVariable(field.getVariable() + "." + this.numberOfRows);
            ConsoleField consoleField = this.createField.createConsoleField(field);
            consoleField.setReadonly(this.isReadonly());
            fields.add(consoleField);
        }
        this.consoleFields.put(this.numberOfRows, fields);
        return true;
    }

    private boolean canRemoveRow() {
        return this.numberOfRows > this.minRow;
    }

    private boolean removeRow() {
        if (!this.canRemoveRow()) {
            return false;
        }
        this.consoleFields.remove(this.numberOfRows);
        --this.numberOfRows;
        return true;
    }

    @Override
    public boolean display() {
        this.numberOfRows = 0;
        this.consoleFields = new HashMap<Integer, List<ConsoleField>>();
        this.addInitialRows();
        int value = 2;
        do {
            int userValue;
            this.showInitialRows();
            if (this.isReadonly()) {
                userValue = this.getConsole().prompt("Enter 1 to continue, 2 to redisplay", 1, 2, 2, -1);
                switch (userValue) {
                    case 1: {
                        value = 1;
                        break;
                    }
                    default: {
                        value = 2;
                        break;
                    }
                }
                continue;
            }
            userValue = this.getConsole().prompt("Enter the row number (1.." + this.numberOfRows + ") to edit, " + Integer.toString(this.numberOfRows + 1) + " to accept all, " + Integer.toString(this.numberOfRows + 2) + " to redisplay" + (this.canAddRow() ? ", " + Integer.toString(this.numberOfRows + 3) + " to add a row" : "") + (this.canRemoveRow() ? ", " + Integer.toString(this.numberOfRows + 4) + " to remove the last row" : ""), 1, this.numberOfRows + 4, this.numberOfRows + 4, -1);
            if (userValue <= this.numberOfRows) {
                this.editRow(userValue, false);
                value = 2;
                continue;
            }
            if (userValue == this.numberOfRows + 1) {
                value = 1;
                continue;
            }
            if (userValue == this.numberOfRows + 3) {
                if (this.addRow()) {
                    this.editRow(this.numberOfRows, false);
                }
                value = 2;
                continue;
            }
            if (userValue == this.numberOfRows + 4) {
                this.removeRow();
                value = 2;
                continue;
            }
            value = 2;
        } while (value != 1);
        this.customInfoField.setValue(Integer.toString(this.numberOfRows));
        if (!this.columnsAreValid()) {
            this.display();
        }
        return true;
    }

    private boolean columnsAreValid() {
        List<Column> columns = this.customInfoField.getColumns();
        String[] columnVariables = this.getVariablesByColumn();
        for (int i2 = 0; i2 < columnVariables.length; ++i2) {
            ValidationStatus status = columns.get(i2).validate(columnVariables[i2]);
            if (status.isValid()) continue;
            System.out.println(status.getMessage());
            return false;
        }
        return true;
    }

    private String[] getVariablesByColumn() {
        String[] columnVariables = new String[this.numberOfColumns];
        for (int col = 0; col < this.numberOfColumns; ++col) {
            columnVariables[col] = "";
            for (int row = 1; row <= this.numberOfRows; ++row) {
                ConsoleField consoleField = this.consoleFields.get(row).get(col);
                if (!consoleField.isDisplayed()) continue;
                int n2 = col;
                columnVariables[n2] = columnVariables[n2] + this.getField().getInstallData().getVariable(consoleField.getVariable()) + ",";
            }
        }
        for (int i2 = 0; i2 < columnVariables.length; ++i2) {
            String v2 = columnVariables[i2];
            columnVariables[i2] = v2.substring(0, v2.length() - 1);
        }
        return columnVariables;
    }

    @Override
    public List<String> getVariables() {
        ArrayList<String> countedVariables = new ArrayList<String>();
        for (int i2 = 1; i2 <= this.numberOfRows; ++i2) {
            for (ConsoleField consoleField : this.consoleFields.get(i2)) {
                if (!consoleField.isDisplayed()) continue;
                countedVariables.add(consoleField.getVariable());
            }
        }
        return countedVariables;
    }

    private CustomField createCustomField(UserInputPanelSpec userInputPanelSpec, IXMLElement spec) {
        List<Field> fields = userInputPanelSpec.createFields(spec);
        for (Field field : fields) {
            if (!(field instanceof CustomField)) continue;
            return (CustomField)field;
        }
        return null;
    }
}

