/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.ProcessHelper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class LibraryRemover {
    private static final String[] SANDBOX_CONTENT = new String[]{"com/izforge/izpack/util/LibraryRemover.class"};
    private static final String BASE_KEY = "lib.rem.base";
    private static final String PHASE_KEY = "self.mod.phase";
    private static final String PREFIX = "InstallRemover";
    private int phase = 0;
    private File logFile = null;
    private File sandbox = null;
    private File specFile = null;
    private SimpleDateFormat isoPoint = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private Date date = new Date();
    PrintStream log = null;

    private LibraryRemover(int phase) throws IOException {
        this.phase = phase;
        if (phase == 1) {
            ProcessHelper.tryExecJava();
        } else {
            this.logFile = new File(System.getProperty(BASE_KEY) + ".log");
            this.specFile = new File(System.getProperty(BASE_KEY) + ".spec");
            this.sandbox = new File(System.getProperty(BASE_KEY) + ".d");
        }
    }

    public static void invoke(List<String> temporaryFileNames) throws IOException {
        LibraryRemover self = new LibraryRemover(1);
        self.invoke1(temporaryFileNames);
    }

    private void invoke1(List<String> temporaryFileNames) throws IOException {
        while (true) {
            this.logFile = File.createTempFile(PREFIX, ".log");
            String canonicalPath = this.logFile.getCanonicalPath();
            this.specFile = new File(canonicalPath.substring(0, canonicalPath.length() - 4) + ".spec");
            this.sandbox = new File(canonicalPath.substring(0, canonicalPath.length() - 4) + ".d");
            if (!this.sandbox.exists()) break;
            this.logFile.delete();
        }
        if (!this.sandbox.mkdir()) {
            throw new RuntimeException("Failed to create temp dir: " + this.sandbox);
        }
        this.sandbox = this.sandbox.getCanonicalFile();
        this.logFile = this.logFile.getCanonicalFile();
        BufferedOutputStream out = null;
        InputStream in = null;
        byte[] buf = new byte[5120];
        int extracted = 0;
        for (String aSANDBOX_CONTENT : SANDBOX_CONTENT) {
            int n2;
            in = this.getClass().getResourceAsStream("/" + aSANDBOX_CONTENT);
            File outFile = new File(this.sandbox, aSANDBOX_CONTENT);
            File parent = outFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            while ((n2 = in.read(buf, 0, buf.length)) > 0) {
                ((OutputStream)out).write(buf, 0, n2);
            }
            ((OutputStream)out).close();
            ++extracted;
        }
        out = new BufferedOutputStream(new FileOutputStream(this.specFile));
        BufferedWriter specWriter = new BufferedWriter(new OutputStreamWriter(out));
        Iterator<String> iter = temporaryFileNames.iterator();
        while (iter.hasNext()) {
            specWriter.write(iter.next());
            if (!iter.hasNext()) continue;
            specWriter.newLine();
        }
        specWriter.flush();
        ((OutputStream)out).close();
        this.spawn(2);
        this.log("library cleanup done");
    }

    private ArrayList<File> getFilesList() throws Exception {
        TreeSet files = new TreeSet(Collections.reverseOrder());
        FileInputStream in = new FileInputStream(this.specFile);
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        String read = reader.readLine();
        while (read != null) {
            files.add(new File(read));
            read = reader.readLine();
        }
        ((InputStream)in).close();
        return new ArrayList<File>(files);
    }

    private void invoke2() {
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception x2) {
                // empty catch block
            }
            ArrayList<File> files = this.getFilesList();
            this.log("deleteing temporary dlls/shls");
            for (File file : files) {
                file.delete();
                if (file.exists()) {
                    this.log("    deleting of " + file.getCanonicalPath() + " failed!!!");
                    continue;
                }
                this.log("    " + file.getCanonicalPath());
            }
            this.log("deleteing sandbox");
            LibraryRemover.deleteTree(this.sandbox);
            this.specFile.delete();
        }
        catch (Exception e2) {
            this.log(e2);
        }
    }

    private Process spawn(int nextPhase) throws IOException {
        String base = this.logFile.getAbsolutePath();
        base = base.substring(0, base.length() - 4);
        String[] javaCmd = new String[]{ProcessHelper.getJavaCommand(), "-classpath", this.sandbox.getAbsolutePath(), "-Dlib.rem.base=" + base, "-Dself.mod.phase=" + nextPhase, this.getClass().getName()};
        StringBuilder sb = new StringBuilder("Spawning phase ");
        sb.append(nextPhase).append(": ");
        for (String aJavaCmd : javaCmd) {
            sb.append("\n\t").append(aJavaCmd);
        }
        this.log(sb.toString());
        return ProcessHelper.exec(javaCmd);
    }

    public static boolean deleteTree(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File file1 : files) {
                LibraryRemover.deleteTree(file1);
            }
        }
        return file.delete();
    }

    public static void main(String[] args) {
        try {
            LibraryRemover librianRemover = new LibraryRemover(2);
            librianRemover.invoke2();
        }
        catch (IOException ioe) {
            System.err.println("Error invoking a secondary phase");
            System.err.println("Note that this program is only intended as a secondary process");
            ioe.printStackTrace();
        }
    }

    private PrintStream checkLog() {
        try {
            if (this.log == null) {
                this.log = new PrintStream(new FileOutputStream(this.logFile.toString(), true));
            }
        }
        catch (IOException x2) {
            System.err.println("Phase " + this.phase + " log err: " + x2.getMessage());
            x2.printStackTrace();
        }
        this.date.setTime(System.currentTimeMillis());
        return this.log;
    }

    private void log(Throwable t2) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + t2.getMessage());
            t2.printStackTrace(this.log);
        }
    }

    private void log(String msg) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + msg);
        }
    }
}

