/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types;

public class Resource
implements Cloneable,
Comparable<Object> {
    public static final long UNKNOWN_SIZE = -1L;
    private String name = null;
    private boolean exists = true;
    private long lastmodified = 0L;
    private boolean directory = false;
    private long size = -1L;

    public Resource() {
    }

    public Resource(String name) {
        this(name, false, 0L, false);
    }

    public Resource(String name, boolean exists, long lastmodified) {
        this(name, exists, lastmodified, false);
    }

    public Resource(String name, boolean exists, long lastmodified, boolean directory) {
        this(name, exists, lastmodified, directory, -1L);
    }

    public Resource(String name, boolean exists, long lastmodified, boolean directory, long size) {
        this.name = name;
        this.setName(name);
        this.setExists(exists);
        this.setLastModified(lastmodified);
        this.setDirectory(directory);
        this.setSize(size);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public long getLastModified() {
        return !this.exists || this.lastmodified < 0L ? 0L : this.lastmodified;
    }

    public void setLastModified(long lastmodified) {
        this.lastmodified = lastmodified;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public void setSize(long size) {
        this.size = size > -1L ? size : -1L;
    }

    public long getSize() {
        return this.exists ? this.size : 0L;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new Error("CloneNotSupportedException for a Clonable Resource caught?");
        }
    }

    @Override
    public int compareTo(Object other) {
        if (!(other instanceof Resource)) {
            throw new IllegalArgumentException("Can only be compared with Resources");
        }
        Resource r2 = (Resource)other;
        return this.getName().compareTo(r2.getName());
    }
}

