/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.unix.ShellScript;
import com.izforge.izpack.util.unix.UnixHelper;
import com.izforge.izpack.util.unix.UnixUser;
import com.izforge.izpack.util.unix.UnixUsers;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Unix_Shortcut
extends Shortcut {
    private static final Logger logger = Logger.getLogger(Unix_Shortcut.class.getName());
    private static final String version = "$Id$";
    private static final String rev = "$Revision$";
    private static final String DESKTOP_EXT = ".desktop";
    private static final String N = "\n";
    private static final String H = "#";
    private static final String S = " ";
    private static final String C = "# ";
    private static ShellScript rootScript = null;
    private static ShellScript uninstallScript = null;
    private List<UnixUser> users;
    private String arguments;
    private String categories;
    private String description;
    private String encoding;
    private String iconLocation;
    private String kdeSubstituteUID;
    private String kdeUserName;
    private String linkName;
    private int linkType;
    private String mimeType;
    private String programGroup;
    private String targetPath;
    private String terminal;
    private String terminalOptions;
    private String type;
    private String url;
    private int userType;
    private String workingDirectory;
    private String itsFileName;
    private ShellScript myInstallScript;
    private final String FS = File.separator;
    private final String myHome = System.getProperty("user.home");
    private String su;
    private String xdgDesktopIconCmd;
    private String myXdgDesktopIconCmd = null;
    private final Resources resources;
    private final InstallData installData;
    private String writtenFileName;

    public Unix_Shortcut(Resources resources, InstallData installData) {
        this.resources = resources;
        this.installData = installData;
        if (rootScript == null) {
            rootScript = new ShellScript();
        }
        if (uninstallScript == null) {
            uninstallScript = new ShellScript();
        }
        if (this.myInstallScript == null) {
            this.myInstallScript = new ShellScript();
        }
    }

    public String build() {
        StringBuilder result = new StringBuilder();
        String userLanguage = System.getProperty("user.language", "en");
        result.append("[Desktop Entry]\n");
        result.append("Categories=").append(this.categories).append(N);
        result.append("Comment=").append(this.description).append(N);
        result.append("Comment[").append(userLanguage).append("]=").append(this.description).append(N);
        if (!this.encoding.isEmpty()) {
            logger.warning(String.format("using deprecated Desktop Entry key Encoding with value %s", this.encoding));
            result.append("Encoding=").append(this.encoding).append(N);
        }
        if (!this.targetPath.isEmpty() || !this.arguments.isEmpty()) {
            result.append("Exec=");
            result.append(this.targetPath);
            if (!this.arguments.isEmpty()) {
                result.append(S).append(this.arguments);
            }
            result.append(N);
        }
        result.append("GenericName=").append(N);
        result.append("GenericName[").append(userLanguage).append("]=").append(N);
        result.append("Icon=").append(this.iconLocation).append(N);
        result.append("MimeType=").append(this.mimeType).append(N);
        result.append("Name=").append(this.linkName).append(N);
        result.append("Name[").append(userLanguage).append("]=").append(this.linkName).append(N);
        result.append("Path=").append(this.workingDirectory).append(N);
        result.append("ServiceTypes=").append(N);
        result.append("SwallowExec=").append(N);
        result.append("SwallowTitle=").append(N);
        result.append("Terminal=").append(this.terminal).append(N);
        if (!(this.terminal.isEmpty() || this.terminal.equals("true") || this.terminal.equals("false"))) {
            logger.warning(String.format("Shortcut '%s' has terminal '%s' but should be 'true' or 'false'", this.linkName, this.terminal));
        }
        result.append("TerminalOptions=").append(this.terminalOptions).append(N);
        result.append("Type=").append(this.type).append(N);
        if (this.type.equalsIgnoreCase("Link") && this.url.isEmpty()) {
            logger.warning(String.format("Shortcut '%s' has type '%s' but URL is empty", this.linkName, this.type));
        }
        if (!this.url.isEmpty()) {
            result.append("URL=").append(this.url).append(N);
            if (!this.type.equalsIgnoreCase("Link")) {
                logger.warning(String.format("Shortcut '%s' has URL but type ('%s') is not 'Link'", this.linkName, this.type));
            }
        }
        result.append("X-KDE-SubstituteUID=").append(this.kdeSubstituteUID).append(N);
        result.append("X-KDE-Username=").append(this.kdeUserName).append(N);
        result.append(N);
        result.append("# created by ").append(this.getClass().getName()).append(S).append(rev).append(N);
        result.append(C).append(version);
        return result.toString();
    }

    @Override
    public void initialize(int aType, String aName) throws Exception {
        this.linkName = aName;
    }

    @Override
    public boolean supported() {
        return true;
    }

    @Override
    public String getFileName() {
        return this.itsFileName;
    }

    @Override
    public List<String> getProgramGroups(int userType) {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("(Default)");
        File kdeShareApplnk = this.getKdeShareApplnkFolder(userType);
        try {
            File[] listing = kdeShareApplnk.listFiles();
            if (listing != null) {
                for (File aListing : listing) {
                    if (!aListing.isDirectory()) continue;
                    groups.add(aListing.getName());
                }
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return groups;
    }

    @Override
    public String getProgramsFolder(int current_user) {
        String result = this.getKdeShareApplnkFolder(current_user).toString();
        return result;
    }

    private File getKdeShareApplnkFolder(int userType) {
        if (userType == 2) {
            return new File(File.separator + "usr" + File.separator + "share" + File.separator + "applications");
        }
        return new File(System.getProperty("user.home") + File.separator + ".local" + File.separator + "share" + File.separator + "applications");
    }

    private String makeFilenameScriptable(String filename) {
        return filename.replace(S, "\\ ");
    }

    private String[] quoteCommand(String ... cmd) {
        String[] quoted = Arrays.copyOf(cmd, cmd.length);
        quoted[0] = "\"" + cmd[0];
        quoted[cmd.length - 1] = "\"" + cmd[cmd.length - 1];
        return quoted;
    }

    private UnixUser getSudoUser() {
        String printEnvCmd = UnixHelper.getCustomCommand("printenv");
        String sudoUserName = FileExecutor.getExecOutput(new String[]{printEnvCmd, "SUDO_USER"}, true).trim();
        for (UnixUser user : this.getUsers()) {
            if (!user.getName().equals(sudoUserName)) continue;
            return user;
        }
        return null;
    }

    @Override
    public boolean multipleUsers() {
        return true;
    }

    @Override
    public void save() throws Exception {
        String shortCutDef = this.build();
        boolean rootUser4All = this.getUserType() == 2;
        boolean create4All = this.getCreateForAll();
        if ("".equals(this.programGroup) && this.getLinkType() == 3) {
            this.itsFileName = null;
            File shortCutLocation = null;
            String ApplicationShortcutPathName = this.installData.getVariable("ApplicationShortcutPath");
            if (null != ApplicationShortcutPathName && !ApplicationShortcutPathName.equals("")) {
                File ApplicationShortcutPath = new File(ApplicationShortcutPathName);
                if (ApplicationShortcutPath.isAbsolute()) {
                    if (!ApplicationShortcutPath.exists() && ApplicationShortcutPath.mkdirs() && ApplicationShortcutPath.canWrite()) {
                        shortCutLocation = ApplicationShortcutPath;
                    }
                    if (ApplicationShortcutPath.exists() && ApplicationShortcutPath.isDirectory() && ApplicationShortcutPath.canWrite()) {
                        shortCutLocation = ApplicationShortcutPath;
                    }
                } else {
                    File relativePath = new File(this.installData.getInstallPath() + this.FS + ApplicationShortcutPath);
                    relativePath.mkdirs();
                    shortCutLocation = new File(relativePath.toString());
                }
            }
            if (shortCutLocation == null) {
                shortCutLocation = new File(this.installData.getInstallPath());
            }
            File writtenDesktopFile = this.writeAppShortcutWithOutSpace(shortCutLocation.toString(), this.linkName, shortCutDef);
            this.uninstaller.addFile(writtenDesktopFile.toString(), true);
            UnixUser sudoUser = this.getSudoUser();
            String cmd = this.getXdgDesktopIconCmd();
            if (cmd != null) {
                this.createExtXdgDesktopIconCmd(shortCutLocation);
                String[] installCmd = new String[]{this.makeFilenameScriptable(this.myXdgDesktopIconCmd), "install", "--novendor", StringTool.escapeSpaces(writtenDesktopFile.toString())};
                String[] uninstallCmd = new String[]{this.makeFilenameScriptable(this.myXdgDesktopIconCmd), "uninstall", "--novendor", StringTool.escapeSpaces(writtenDesktopFile.toString())};
                ShellScript myUninstallScript = new ShellScript();
                if (sudoUser != null) {
                    this.myInstallScript.append(new String[]{this.getSuCommand(), sudoUser.getName(), "-c"});
                    myUninstallScript.append(new String[]{this.getSuCommand(), sudoUser.getName(), "-c"});
                    installCmd = this.quoteCommand(installCmd);
                    uninstallCmd = this.quoteCommand(uninstallCmd);
                }
                this.myInstallScript.appendln(installCmd);
                myUninstallScript.appendln(uninstallCmd);
                this.uninstaller.addUninstallScript(myUninstallScript.getContentAsString());
            } else {
                File myDesktopFile;
                String userHome;
                String string = userHome = sudoUser != null ? sudoUser.getHome() : this.myHome;
                while ((myDesktopFile = new File(userHome + this.FS + "Desktop" + this.FS + FilenameUtils.getBaseName(writtenDesktopFile.getName()) + "-" + System.currentTimeMillis() + DESKTOP_EXT)).exists()) {
                }
                FileUtils.copyFile(writtenDesktopFile, myDesktopFile, false);
                String chmodCmd = UnixHelper.getCustomCommand("chmod");
                FileExecutor.getExecOutput(new String[]{chmodCmd, "u+x", StringTool.escapeSpaces(myDesktopFile.getPath())});
                if (sudoUser != null) {
                    String chownCmd = UnixHelper.getCustomCommand("chown");
                    FileExecutor.getExecOutput(new String[]{chownCmd, sudoUser.getName(), StringTool.escapeSpaces(myDesktopFile.getPath())});
                }
                this.uninstaller.addFile(myDesktopFile.toString(), true);
            }
            if (rootUser4All && create4All) {
                if (cmd != null) {
                    this.installDesktopFileToAllUsersDesktop(writtenDesktopFile);
                } else {
                    this.copyDesktopFileToAllUsersDesktop(writtenDesktopFile);
                }
            }
        } else if (rootUser4All && create4All) {
            File theIcon = new File(this.getIconLocation());
            File commonIcon = new File("/usr/share/pixmaps/" + theIcon.getName());
            try {
                FileUtils.copyFile(theIcon, commonIcon, false);
                this.uninstaller.addFile(commonIcon.toString(), true);
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Could not copy " + theIcon + " to " + commonIcon + " (" + e2.getMessage() + ")", e2);
            }
            this.itsFileName = null;
            File writtenFile = this.writeAppShortcut("/usr/share/applications/", this.linkName, shortCutDef);
            this.setWrittenFileName(writtenFile.getName());
            this.uninstaller.addFile(writtenFile.toString(), true);
        } else {
            String localApps = this.myHome + "/.local/share/applications/";
            String localPixmaps = this.myHome + "/.local/share/pixmaps/";
            try {
                File file = new File(localApps);
                file.mkdirs();
                file = new File(localPixmaps);
                file.mkdirs();
            }
            catch (Exception ignore) {
                logger.warning("Failed creating " + localApps + " or " + localPixmaps);
            }
            File theIcon = new File(this.getIconLocation());
            File commonIcon = new File(localPixmaps + theIcon.getName());
            try {
                FileUtils.copyFile(theIcon, commonIcon, false);
                this.uninstaller.addFile(commonIcon.toString(), true);
            }
            catch (Exception e3) {
                logger.log(Level.WARNING, "Could not copy " + theIcon + " to " + commonIcon + " (" + e3.getMessage() + ")", e3);
            }
            this.itsFileName = null;
            File writtenFile = this.writeAppShortcut(localApps, this.linkName, shortCutDef);
            this.setWrittenFileName(writtenFile.getName());
            this.uninstaller.addFile(writtenFile.toString(), true);
        }
    }

    private void createExtXdgDesktopIconCmd(File shortCutLocation) throws ResourceNotFoundException {
        ShellScript myXdgDesktopIconScript = new ShellScript(null);
        String lines = this.resources.getString("/com/izforge/izpack/util/unix/xdgdesktopiconscript.sh", null);
        myXdgDesktopIconScript.append(lines);
        this.myXdgDesktopIconCmd = shortCutLocation + this.FS + "IzPackLocaleEnabledXdgDesktopIconScript.sh";
        myXdgDesktopIconScript.write(this.myXdgDesktopIconCmd);
        FileExecutor.getExecOutput(new String[]{UnixHelper.getCustomCommand("chmod"), "+x", this.myXdgDesktopIconCmd}, true);
    }

    private void installDesktopFileToAllUsersDesktop(File writtenDesktopFile) {
        for (UnixUser user : this.getUsers()) {
            if (user.getHome().equals(this.myHome)) {
                logger.info("Skipping self-copy: " + user.getHome() + " == " + this.myHome);
                continue;
            }
            try {
                rootScript.append(new String[]{this.getSuCommand(), user.getName(), "-c"});
                rootScript.appendln(new String[]{"\"" + this.myXdgDesktopIconCmd, "install", "--novendor", StringTool.escapeSpaces(writtenDesktopFile.toString()) + "\""});
                uninstallScript.append(new String[]{this.getSuCommand(), user.getName(), "-c"});
                uninstallScript.appendln(new String[]{"\"" + this.myXdgDesktopIconCmd, "uninstall", "--novendor", StringTool.escapeSpaces(writtenDesktopFile.toString()) + "\""});
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, e2.getMessage(), e2);
            }
        }
        logger.fine("==============================");
        logger.fine(rootScript.getContentAsString());
    }

    private String getSuCommand() {
        if (this.su == null) {
            this.su = UnixHelper.getSuCommand();
        }
        return this.su;
    }

    private String getXdgDesktopIconCmd() {
        if (this.xdgDesktopIconCmd == null) {
            this.xdgDesktopIconCmd = UnixHelper.getCustomCommand("xdg-desktop-icon");
        }
        return this.xdgDesktopIconCmd;
    }

    private List<UnixUser> getUsers() {
        if (this.users == null) {
            this.users = UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops();
        }
        return this.users;
    }

    private void copyDesktopFileToAllUsersDesktop(File writtenDesktopFile) throws IOException {
        String chmod = UnixHelper.getCustomCommand("chmod");
        String chown = UnixHelper.getCustomCommand("chown");
        String rm = UnixHelper.getRmCommand();
        String copy = UnixHelper.getCpCommand();
        File tempFile = File.createTempFile(this.getClass().getName(), Long.toString(System.currentTimeMillis()) + ".tmp");
        FileUtils.copyFile(writtenDesktopFile, tempFile, false);
        FileExecutor.getExecOutput(new String[]{chmod, "uga+rwx", tempFile.toString()});
        for (UnixUser user : this.getUsers()) {
            if (user.getHome().equals(this.myHome)) {
                logger.info("Skipping self-copy: " + user.getHome() + " == " + this.myHome);
                continue;
            }
            try {
                File dest = new File(user.getHome() + this.FS + "Desktop" + this.FS + writtenDesktopFile.getName());
                rootScript.append(this.getSuCommand());
                rootScript.append(S);
                rootScript.append(user.getName());
                rootScript.append(S);
                rootScript.append("-c");
                rootScript.append(S);
                rootScript.append('\"');
                rootScript.append(copy);
                rootScript.append(S);
                rootScript.append(tempFile.toString());
                rootScript.append(S);
                rootScript.append(StringTool.replace(dest.toString(), S, "\\ "));
                rootScript.appendln('\"');
                rootScript.append('\n');
                rootScript.append(chown);
                rootScript.append(S);
                rootScript.append(user.getName());
                rootScript.append(S);
                rootScript.appendln(StringTool.replace(dest.toString(), S, "\\ "));
                rootScript.append('\n');
                rootScript.append('\n');
                uninstallScript.append(this.getSuCommand());
                uninstallScript.append(S);
                uninstallScript.append(user.getName());
                uninstallScript.append(S);
                uninstallScript.append("-c");
                uninstallScript.append(S);
                uninstallScript.append('\"');
                uninstallScript.append(rm);
                uninstallScript.append(S);
                uninstallScript.append(StringTool.replace(dest.toString(), S, "\\ "));
                uninstallScript.appendln('\"');
                uninstallScript.appendln();
            }
            catch (Exception e2) {
                logger.log(Level.INFO, "Could not copy as root: " + e2.getMessage(), e2);
            }
        }
        rootScript.append(rm);
        rootScript.append(S);
        rootScript.appendln(tempFile.toString());
        rootScript.appendln();
    }

    @Override
    public void execPostAction() {
        String scriptFilename;
        logger.fine("Launching post execution action");
        String pseudoUnique = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        try {
            scriptFilename = File.createTempFile(pseudoUnique, ".sh").toString();
        }
        catch (IOException e2) {
            scriptFilename = System.getProperty("java.io.tmpdir", "/tmp") + "/" + pseudoUnique + ".sh";
            e2.printStackTrace();
        }
        rootScript.write(scriptFilename);
        rootScript.exec();
        rootScript.delete();
        logger.fine(rootScript.toString());
        pseudoUnique = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        try {
            scriptFilename = File.createTempFile(pseudoUnique, ".sh").toString();
        }
        catch (IOException e3) {
            scriptFilename = System.getProperty("java.io.tmpdir", "/tmp") + "/" + pseudoUnique + ".sh";
            e3.printStackTrace();
        }
        this.myInstallScript.write(scriptFilename);
        this.myInstallScript.exec();
        this.myInstallScript.delete();
        logger.fine(this.myInstallScript.toString());
        logger.fine(uninstallScript.toString());
        this.uninstaller.addUninstallScript(uninstallScript.getContentAsString());
    }

    public String getWrittenFileName() {
        return this.writtenFileName;
    }

    private void setWrittenFileName(String s2) {
        this.writtenFileName = s2;
    }

    private File writeAppShortcut(String targetPath, String shortcutName, String shortcutDef) {
        return this.writeAppShortcutWithSimpleSpacehandling(targetPath, shortcutName, shortcutDef, false);
    }

    private File writeAppShortcutWithOutSpace(String targetPath, String shortcutName, String shortcutDef) {
        return this.writeAppShortcutWithSimpleSpacehandling(targetPath, shortcutName, shortcutDef, true);
    }

    private File writeAppShortcutWithSimpleSpacehandling(String targetPath, String shortcutName, String shortcutDef, boolean replaceSpacesWithMinus) {
        File shortcutFile = new File(FilenameUtils.getFullPathNoEndSeparator(targetPath) + '/' + (replaceSpacesWithMinus ? StringTool.replaceSpacesWithMinus(shortcutName) : shortcutName) + DESKTOP_EXT);
        try {
            FileUtils.writeStringToFile(shortcutFile, shortcutDef);
        }
        catch (IOException e2) {
            logger.warning("Application shortcut could not be created (" + e2.getMessage() + ")");
        }
        return shortcutFile;
    }

    @Override
    public void setArguments(String args) {
        this.arguments = args;
    }

    @Override
    public void setCategories(String theCategories) {
        this.categories = theCategories;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setEncoding(String aEncoding) {
        this.encoding = aEncoding;
    }

    @Override
    public void setKdeSubstUID(String trueFalseOrNothing) {
        this.kdeSubstituteUID = trueFalseOrNothing;
    }

    @Override
    public void setKdeUserName(String aUserName) {
        this.kdeUserName = aUserName;
    }

    @Override
    public void setIconLocation(String path, int index) {
        this.iconLocation = path;
    }

    @Override
    public String getIconLocation() {
        return this.iconLocation;
    }

    @Override
    public void setLinkName(String aName) {
        this.linkName = aName;
    }

    @Override
    public void setLinkType(int aType) throws IllegalArgumentException, UnsupportedEncodingException {
        this.linkType = aType;
    }

    @Override
    public int getLinkType() {
        return this.linkType;
    }

    @Override
    public void setMimetype(String aMimeType) {
        this.mimeType = aMimeType;
    }

    @Override
    public void setProgramGroup(String aGroupName) {
        this.programGroup = aGroupName;
    }

    @Override
    public void setShowCommand(int show) {
    }

    @Override
    public void setTargetPath(String aPath) {
        this.targetPath = aPath;
    }

    @Override
    public void setUserType(int aUserType) {
        this.userType = aUserType;
    }

    @Override
    public int getUserType() {
        return this.userType;
    }

    @Override
    public void setWorkingDirectory(String aDirectory) {
        this.workingDirectory = aDirectory;
    }

    @Override
    public void setTerminal(String trueFalseOrNothing) {
        this.terminal = trueFalseOrNothing;
    }

    @Override
    public void setTerminalOptions(String someTerminalOptions) {
        this.terminalOptions = someTerminalOptions;
    }

    @Override
    public void setTryExec(String aTryExec) {
    }

    @Override
    public void setType(String aType) {
        this.type = aType;
    }

    @Override
    public void setURL(String anUrl) {
        this.url = anUrl;
    }

    public String toString() {
        return this.linkName + N + this.build();
    }
}

