/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.ShellLink;
import com.izforge.izpack.util.os.Shortcut;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Win_Shortcut
extends Shortcut {
    private static final Logger logger = Logger.getLogger(Win_Shortcut.class.getName());
    private ShellLink shortcut;
    private final Librarian librarian;

    public Win_Shortcut(Librarian librarian) {
        this.librarian = librarian;
    }

    @Override
    public void initialize(int type, String name) throws Exception {
        switch (type) {
            case 1: {
                this.shortcut = new ShellLink(2, name, this.librarian);
                break;
            }
            case 2: {
                this.shortcut = new ShellLink(3, name, this.librarian);
                break;
            }
            case 3: {
                this.shortcut = new ShellLink(1, name, this.librarian);
                break;
            }
            case 4: {
                this.shortcut = new ShellLink(4, name, this.librarian);
                break;
            }
            default: {
                this.shortcut = new ShellLink(2, name, this.librarian);
            }
        }
    }

    @Override
    public String getBasePath() throws Exception {
        String result = this.shortcut.getLinkPath(this.shortcut.getUserType());
        return result;
    }

    @Override
    public List<String> getProgramGroups(int userType) {
        int type = 0;
        type = userType == 2 ? 1 : 0;
        String linkPath = this.shortcut.getLinkPath(type);
        if (linkPath == null) {
            return new ArrayList<String>();
        }
        File path = new File(linkPath);
        File[] file = path.listFiles();
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("(Default)");
        if (file != null) {
            for (File aFile : file) {
                String aFilename = aFile.getName();
                if (!aFile.isDirectory()) continue;
                groups.add(aFilename);
            }
        }
        return groups;
    }

    @Override
    public String getFileName() {
        String aFilename = this.shortcut.getFileName();
        return aFilename;
    }

    @Override
    public boolean multipleUsers() {
        boolean result = false;
        String allUsers = this.shortcut.getallUsersLinkPath();
        String currentUsers = this.shortcut.getcurrentUserLinkPath();
        result = allUsers == null || currentUsers == null ? false : allUsers.length() > 0 && currentUsers.length() > 0;
        return result;
    }

    @Override
    public boolean supported() {
        return true;
    }

    @Override
    public void setArguments(String arguments) {
        this.shortcut.setArguments(arguments);
    }

    @Override
    public void setDescription(String description) {
        this.shortcut.setDescription(description);
    }

    @Override
    public void setIconLocation(String path, int index) {
        this.shortcut.setIconLocation(path, index);
    }

    @Override
    public String getIconLocation() {
        return this.shortcut.getIconLocation();
    }

    @Override
    public void setProgramGroup(String groupName) {
        this.shortcut.setProgramGroup(groupName);
    }

    @Override
    public void setShowCommand(int show) throws IllegalArgumentException {
        switch (show) {
            case 0: {
                this.shortcut.setShowCommand(7);
                break;
            }
            case 1: {
                this.shortcut.setShowCommand(1);
                break;
            }
            case 2: {
                this.shortcut.setShowCommand(7);
                break;
            }
            case 3: {
                this.shortcut.setShowCommand(3);
                break;
            }
            default: {
                throw new IllegalArgumentException(show + "is not recognized as a show command");
            }
        }
    }

    @Override
    public int getShowCommand() {
        int showCommand = this.shortcut.getShowCommand();
        switch (showCommand) {
            case 1: {
                showCommand = 1;
                break;
            }
            case 2: 
            case 7: {
                showCommand = 2;
                break;
            }
            case 3: {
                showCommand = 3;
                break;
            }
        }
        return showCommand;
    }

    @Override
    public void setTargetPath(String path) {
        this.shortcut.setTargetPath(path);
    }

    @Override
    public void setWorkingDirectory(String dir) {
        this.shortcut.setWorkingDirectory(dir);
    }

    @Override
    public String getWorkingDirectory() {
        String result = this.shortcut.getWorkingDirectory();
        return result;
    }

    @Override
    public void setLinkName(String name) {
        this.shortcut.setLinkName(name);
    }

    @Override
    public int getLinkType() {
        int typ = this.shortcut.getLinkType();
        switch (typ) {
            case 1: {
                typ = 3;
                break;
            }
            case 2: {
                typ = 1;
                break;
            }
            case 3: {
                typ = 2;
                break;
            }
            case 4: {
                typ = 4;
                break;
            }
        }
        return typ;
    }

    @Override
    public void setLinkType(int type) throws IllegalArgumentException, UnsupportedEncodingException {
        switch (type) {
            case 3: {
                this.shortcut.setLinkType(1);
                break;
            }
            case 1: {
                this.shortcut.setLinkType(2);
                break;
            }
            case 2: {
                this.shortcut.setLinkType(3);
                break;
            }
            case 4: {
                this.shortcut.setLinkType(4);
                break;
            }
            default: {
                throw new IllegalArgumentException(type + "is not recognized as a valid link type");
            }
        }
    }

    @Override
    public int getUserType() {
        int utype = this.shortcut.getUserType();
        switch (utype) {
            case 1: {
                utype = 2;
                break;
            }
            case 0: {
                utype = 1;
            }
        }
        return utype;
    }

    @Override
    public void setUserType(int type) {
        if (type == 1) {
            if (this.shortcut.getcurrentUserLinkPath().length() > 0) {
                this.shortcut.setUserType(0);
            }
        } else if (type == 2 && this.shortcut.getallUsersLinkPath().length() > 0) {
            this.shortcut.setUserType(1);
        }
    }

    @Override
    public void setRunAsAdministrator(boolean runAsAdministrator) {
        this.shortcut.setRunAsAdministrator(runAsAdministrator);
    }

    @Override
    public boolean getRunAsAdministrator() {
        return this.shortcut.getRunAsAdministrator();
    }

    @Override
    public void save() throws Exception {
        this.shortcut.save();
    }

    @Override
    public int getHotkey() {
        int result = this.shortcut.getHotkey();
        return result;
    }

    @Override
    public void setHotkey(int hotkey) {
        this.shortcut.setHotkey(hotkey);
    }

    @Override
    public String getProgramsFolder(int current_user) {
        int USER = 0;
        if (current_user == 1) {
            USER = 0;
        } else if (current_user == 2) {
            USER = 1;
        }
        String result = null;
        try {
            result = new String(this.shortcut.getLinkPath(USER).getBytes(StringTool.getPlatformEncoding()), StringTool.getPlatformEncoding());
        }
        catch (UnsupportedEncodingException e2) {
            logger.log(Level.WARNING, e2.getMessage(), e2);
        }
        return result;
    }
}

