/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.regex;

import com.izforge.izpack.util.regex.RegexUtil;
import com.izforge.izpack.util.regex.RegexpMatcher;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JavaRegexpMatcher
implements RegexpMatcher {
    private String pattern;

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    protected Pattern getCompiledPattern(int options) throws RuntimeException {
        int cOptions = this.getCompilerOptions(options);
        try {
            Pattern p2 = Pattern.compile(this.pattern, cOptions);
            return p2;
        }
        catch (PatternSyntaxException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public boolean matches(String argument) throws RuntimeException {
        return this.matches(argument, 0);
    }

    @Override
    public boolean matches(String input, int options) throws RuntimeException {
        try {
            Pattern p2 = this.getCompiledPattern(options);
            return p2.matcher(input).find();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Vector<String> getGroups(String argument) throws RuntimeException {
        return this.getGroups(argument, 0);
    }

    @Override
    public Vector<String> getGroups(String input, int options) throws RuntimeException {
        Pattern p2 = this.getCompiledPattern(options);
        Matcher matcher = p2.matcher(input);
        if (!matcher.find()) {
            return null;
        }
        Vector<String> v2 = new Vector<String>();
        int cnt = matcher.groupCount();
        for (int i2 = 0; i2 <= cnt; ++i2) {
            String match = matcher.group(i2);
            if (match == null) {
                match = "";
            }
            v2.addElement(match);
        }
        return v2;
    }

    protected int getCompilerOptions(int options) {
        int cOptions = 1;
        if (RegexUtil.hasFlag(options, 256)) {
            cOptions |= 2;
        }
        if (RegexUtil.hasFlag(options, 4096)) {
            cOptions |= 8;
        }
        if (RegexUtil.hasFlag(options, 65536)) {
            cOptions |= 0x20;
        }
        return cOptions;
    }
}

