/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.unix;

import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.unix.ShellScript;
import com.izforge.izpack.util.unix.UnixHelper;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class UnixUser {
    private String itsName;
    private String itsPasswdDigest;
    private String itsId;
    private String itsGid;
    private String itsDescription;
    private String itsHome;
    private String itsShell;
    private static String XDGDesktopFolderNameScriptFilename;
    private static File XDGDesktopFolderNameScript;

    public String getName() {
        return this.itsName;
    }

    public String getPasswdDigest() {
        return this.itsPasswdDigest;
    }

    public String getId() {
        return this.itsId;
    }

    public String getGid() {
        return this.itsGid;
    }

    public String getDescription() {
        return this.itsDescription;
    }

    public String getHome() {
        return this.itsHome.trim();
    }

    public String getShell() {
        return this.itsShell;
    }

    public UnixUser fromEtcPasswdLine(String anEtcPasswdLine) {
        if (anEtcPasswdLine == null) {
            return null;
        }
        StringTokenizer usersToken = new StringTokenizer(anEtcPasswdLine, ":");
        UnixUser user = new UnixUser();
        if (usersToken.hasMoreTokens()) {
            user.itsName = usersToken.nextToken();
        }
        if (usersToken.hasMoreTokens()) {
            user.itsPasswdDigest = usersToken.nextToken();
        }
        if (usersToken.hasMoreTokens()) {
            user.itsId = usersToken.nextToken();
        }
        if (usersToken.hasMoreTokens()) {
            user.itsGid = usersToken.nextToken();
        }
        if (usersToken.hasMoreTokens()) {
            user.itsDescription = usersToken.nextToken();
        }
        if (usersToken.hasMoreTokens()) {
            user.itsHome = usersToken.nextToken();
        }
        if (usersToken.hasMoreTokens()) {
            user.itsShell = usersToken.nextToken();
        }
        return user;
    }

    public String getCreatedXDGDesktopFolderNameScriptFilename() {
        ShellScript sh = new ShellScript();
        sh.appendln(". " + this.getHome() + File.separator + ".config" + File.separator + "user-dirs.dirs");
        sh.appendln();
        sh.appendln("echo $XDG_DESKTOP_DIR");
        String pseudoUnique = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        String scriptFilename = null;
        try {
            scriptFilename = File.createTempFile(pseudoUnique, ".sh").toString();
        }
        catch (IOException e2) {
            scriptFilename = System.getProperty("java.io.tmpdir", "/tmp") + "/" + pseudoUnique + ".sh";
            e2.printStackTrace();
        }
        sh.write(scriptFilename);
        return scriptFilename;
    }

    public String getXdgDesktopfolder() {
        File configFile = new File(this.getHome() + File.separator + ".config" + File.separator + "user-dirs.dirs");
        if (configFile.exists()) {
            if (XDGDesktopFolderNameScript == null) {
                XDGDesktopFolderNameScriptFilename = this.getCreatedXDGDesktopFolderNameScriptFilename();
            }
            FileExecutor.getExecOutput(new String[]{UnixHelper.getCustomCommand("chmod"), "+x", XDGDesktopFolderNameScriptFilename}, true);
            String xdgDesktopfolder = FileExecutor.getExecOutput(new String[]{XDGDesktopFolderNameScriptFilename}, true).trim();
            new File(XDGDesktopFolderNameScriptFilename).delete();
            return xdgDesktopfolder;
        }
        return this.getHome() + File.separator + "Desktop";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("User: ");
        result.append(this.itsName);
        result.append(" X: ");
        result.append(this.itsPasswdDigest);
        result.append(" Id: ");
        result.append(this.itsId);
        result.append(" Gid: ");
        result.append(this.itsGid);
        result.append(" Desc.: ");
        result.append(this.itsDescription);
        result.append(" Home: ");
        result.append(this.itsHome);
        result.append(" Shell: ");
        result.append(this.itsShell);
        return result.toString();
    }

    public static void main(String[] args) {
        System.out.println(new UnixUser().fromEtcPasswdLine(""));
        System.out.println(new UnixUser().fromEtcPasswdLine("eppelmann.local:x:500:100:Marc L Eppelmann:/mnt/local/home/eppelmann.local:/bin/bash"));
    }
}

