/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xmlmerge.factory;

import com.izforge.izpack.util.xmlmerge.AbstractXmlMergeException;
import com.izforge.izpack.util.xmlmerge.ConfigurationException;
import com.izforge.izpack.util.xmlmerge.MatchException;
import com.izforge.izpack.util.xmlmerge.Operation;
import com.izforge.izpack.util.xmlmerge.OperationFactory;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class XPathOperationFactory
implements OperationFactory {
    Map<String, Operation> m_map = new HashMap<String, Operation>();
    Operation m_defaultOperation;

    public void setOperationMap(Map<String, Operation> map) {
        this.m_map = map;
    }

    public void setDefaultOperation(Operation operation) {
        this.m_defaultOperation = operation;
    }

    @Override
    public Operation getOperation(Element originalElement, Element patchElement) throws AbstractXmlMergeException {
        for (String xPath : this.m_map.keySet()) {
            XPathExpression compiledExpression;
            try {
                compiledExpression = XPathFactory.instance().compile(xPath, Filters.element());
            }
            catch (IllegalArgumentException e2) {
                throw new ConfigurationException(e2.getMessage(), e2);
            }
            if (!this.matches(originalElement, (XPathExpression<Element>)compiledExpression) && !this.matches(patchElement, (XPathExpression<Element>)compiledExpression)) continue;
            return this.m_map.get(xPath);
        }
        return this.m_defaultOperation;
    }

    private boolean matches(Element element, XPathExpression<Element> compiledExpression) throws AbstractXmlMergeException {
        try {
            if (element == null) {
                return false;
            }
            return compiledExpression.evaluate((Object)element).contains(element);
        }
        catch (IllegalStateException e2) {
            throw new MatchException(element, (Throwable)e2);
        }
    }
}

