/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import jline.AnsiWindowsTerminal;
import jline.Terminal;
import jline.UnixTerminal;
import jline.UnsupportedTerminal;
import jline.internal.Configuration;
import jline.internal.Log;
import jline.internal.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalFactory {
    public static final String JLINE_TERMINAL = "jline.terminal";
    public static final String AUTO = "auto";
    public static final String UNIX = "unix";
    public static final String WIN = "win";
    public static final String WINDOWS = "windows";
    public static final String NONE = "none";
    public static final String OFF = "off";
    public static final String FALSE = "false";
    private static Terminal term = null;
    private static final Map<Flavor, Class<? extends Terminal>> FLAVORS = new HashMap<Flavor, Class<? extends Terminal>>();

    public static synchronized Terminal create() {
        Terminal t2;
        block13: {
            if (Log.TRACE) {
                Log.trace(new Throwable("CREATE MARKER"));
            }
            String type = Configuration.getString(JLINE_TERMINAL, AUTO);
            if ("dumb".equals(System.getenv("TERM"))) {
                type = NONE;
                Log.debug("$TERM=dumb; setting type=", type);
            }
            Log.debug("Creating terminal; type=", type);
            try {
                String tmp = type.toLowerCase();
                if (tmp.equals(UNIX)) {
                    t2 = TerminalFactory.getFlavor(Flavor.UNIX);
                    break block13;
                }
                if (tmp.equals(WIN) | tmp.equals(WINDOWS)) {
                    t2 = TerminalFactory.getFlavor(Flavor.WINDOWS);
                    break block13;
                }
                if (tmp.equals(NONE) || tmp.equals(OFF) || tmp.equals(FALSE)) {
                    t2 = new UnsupportedTerminal();
                    break block13;
                }
                if (tmp.equals(AUTO)) {
                    String os = Configuration.getOsName();
                    Flavor flavor = Flavor.UNIX;
                    if (os.contains(WINDOWS)) {
                        flavor = Flavor.WINDOWS;
                    }
                    t2 = TerminalFactory.getFlavor(flavor);
                    break block13;
                }
                try {
                    t2 = (Terminal)Thread.currentThread().getContextClassLoader().loadClass(type).newInstance();
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException(MessageFormat.format("Invalid terminal type: {0}", type), e2);
                }
            }
            catch (Exception e3) {
                Log.error("Failed to construct terminal; falling back to unsupported", e3);
                t2 = new UnsupportedTerminal();
            }
        }
        Log.debug("Created Terminal: ", t2);
        try {
            t2.init();
        }
        catch (Throwable e4) {
            Log.error("Terminal initialization failed; falling back to unsupported", e4);
            return new UnsupportedTerminal();
        }
        return t2;
    }

    public static synchronized void reset() {
        term = null;
    }

    public static synchronized void resetIf(Terminal t2) {
        if (t2 == term) {
            TerminalFactory.reset();
        }
    }

    public static synchronized void configure(String type) {
        Preconditions.checkNotNull(type);
        System.setProperty(JLINE_TERMINAL, type);
    }

    public static synchronized void configure(Type type) {
        Preconditions.checkNotNull(type);
        TerminalFactory.configure(type.name().toLowerCase());
    }

    public static synchronized Terminal get() {
        if (term == null) {
            term = TerminalFactory.create();
        }
        return term;
    }

    public static Terminal getFlavor(Flavor flavor) throws Exception {
        Class<? extends Terminal> type = FLAVORS.get((Object)flavor);
        if (type != null) {
            return type.newInstance();
        }
        throw new InternalError();
    }

    public static void registerFlavor(Flavor flavor, Class<? extends Terminal> type) {
        FLAVORS.put(flavor, type);
    }

    static {
        TerminalFactory.registerFlavor(Flavor.WINDOWS, AnsiWindowsTerminal.class);
        TerminalFactory.registerFlavor(Flavor.UNIX, UnixTerminal.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flavor {
        WINDOWS,
        UNIX;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        AUTO,
        WINDOWS,
        UNIX,
        NONE;

    }
}

