/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.visitors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.visitors.TraversalCheckingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyingVisitor
extends TraversalCheckingVisitor {
    private final List<RuntimeException> nestedVerificationExceptions = new ArrayList<RuntimeException>();
    private final Set<ComponentAdapter> verifiedComponentAdapters = new HashSet<ComponentAdapter>();
    private final Set<ComponentFactory> verifiedComponentFactories = new HashSet<ComponentFactory>();
    private final PicoVisitor componentAdapterCollector = new ComponentAdapterCollector();
    private PicoContainer currentPico;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object traverse(Object node) throws PicoVerificationException {
        this.nestedVerificationExceptions.clear();
        this.verifiedComponentAdapters.clear();
        try {
            super.traverse(node);
            if (!this.nestedVerificationExceptions.isEmpty()) {
                throw new PicoVerificationException(new ArrayList<RuntimeException>(this.nestedVerificationExceptions));
            }
        }
        finally {
            this.nestedVerificationExceptions.clear();
            this.verifiedComponentAdapters.clear();
        }
        return Void.TYPE;
    }

    @Override
    public boolean visitContainer(PicoContainer pico) {
        super.visitContainer(pico);
        this.currentPico = pico;
        return true;
    }

    @Override
    public void visitComponentAdapter(ComponentAdapter<?> componentAdapter) {
        super.visitComponentAdapter(componentAdapter);
        if (!this.verifiedComponentAdapters.contains(componentAdapter)) {
            try {
                componentAdapter.verify(this.currentPico);
            }
            catch (RuntimeException e2) {
                this.nestedVerificationExceptions.add(e2);
            }
            componentAdapter.accept(this.componentAdapterCollector);
        }
    }

    @Override
    public void visitComponentFactory(ComponentFactory componentFactory) {
        super.visitComponentFactory(componentFactory);
        if (!this.verifiedComponentFactories.contains(componentFactory)) {
            try {
                componentFactory.verify(this.currentPico);
            }
            catch (RuntimeException e2) {
                this.nestedVerificationExceptions.add(e2);
            }
            componentFactory.accept(this.componentAdapterCollector);
        }
    }

    private class ComponentAdapterCollector
    implements PicoVisitor {
        private ComponentAdapterCollector() {
        }

        public Object traverse(Object node) {
            return null;
        }

        public boolean visitContainer(PicoContainer pico) {
            return true;
        }

        public void visitComponentAdapter(ComponentAdapter componentAdapter) {
            VerifyingVisitor.this.verifiedComponentAdapters.add(componentAdapter);
        }

        public void visitComponentFactory(ComponentFactory componentFactory) {
            VerifyingVisitor.this.verifiedComponentFactories.add(componentFactory);
        }

        public void visitParameter(Parameter parameter) {
        }
    }
}

