/*
 * Decompiled with CFR 0.152.
 */
package xjava.security;

import com.enterprisedt.cryptix.CryptixProperties;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import xjava.security.IJCE;
import xjava.security.IllegalBlockSizeException;
import xjava.security.InvalidParameterTypeException;
import xjava.security.Mode;
import xjava.security.NoSuchParameterException;
import xjava.security.PaddingScheme;
import xjava.security.Parameterized;
import xjava.security.c;

public abstract class Cipher
extends c
implements Parameterized {
    private static Logger b = Logger.getLogger("Cipher");
    public static final int UNINITIALIZED = 0;
    public static final int ENCRYPT = 1;
    public static final int DECRYPT = 2;
    private boolean c;
    private byte[] d;
    private int e;
    private int f;
    private int g;
    private String h;
    private String i;
    private String j;
    private String k;
    private PaddingScheme l;
    private int m;

    private static String a(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return byArray.toString();
    }

    protected Cipher() {
        super("Cipher");
    }

    protected Cipher(boolean implBuffering, boolean implPadding, String provider) {
        super("Cipher");
        if (implPadding) {
            throw new IllegalArgumentException("IJCE does not support ciphers for which implPadding == true");
        }
        this.c = implBuffering;
        this.h = provider;
    }

    protected Cipher(boolean implBuffering, String provider, String algorithm) {
        super("Cipher");
        this.c = implBuffering;
        this.h = provider;
        this.d(algorithm);
    }

    private void d(String string) {
        int n2 = string.indexOf(47);
        if (n2 == -1) {
            this.i = string;
        } else {
            this.i = string.substring(0, n2);
            int n3 = string.indexOf(47, n2 + 1);
            if (n3 == -1) {
                this.j = string.substring(n2 + 1);
            } else {
                this.j = string.substring(n2 + 1, n3);
                this.k = string.substring(n3 + 1);
            }
        }
    }

    private void a(String string, String string2, String string3, String string4) {
        if (this.i == null) {
            this.i = string;
        }
        if (this.j == null) {
            this.j = string2;
        }
        if (this.k == null) {
            this.k = string3;
        }
        if (this.h == null) {
            this.h = string4;
        }
    }

    protected final PaddingScheme getPaddingScheme() {
        return this.l;
    }

    public static Cipher getInstance(String algorithm) throws NoSuchAlgorithmException {
        try {
            return Cipher.getInstance(algorithm, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(noSuchProviderException.getMessage());
        }
    }

    public static Cipher getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        String string = algorithm;
        String string2 = "ECB";
        String string3 = "NONE";
        int n2 = algorithm.indexOf(47);
        if (n2 != -1) {
            string = algorithm.substring(0, n2);
            int n3 = algorithm.indexOf(47, n2 + 1);
            if (n3 == -1) {
                string2 = algorithm.substring(n2 + 1);
            } else {
                string2 = algorithm.substring(n2 + 1, n3);
                string3 = algorithm.substring(n3 + 1);
            }
        }
        return Cipher.b(string, string2, string3, provider);
    }

    private static Cipher b(String string, String string2, String string3, String string4) throws NoSuchAlgorithmException, NoSuchProviderException {
        Cipher cipher;
        PaddingScheme paddingScheme;
        Cipher cipher2;
        block12: {
            String string5;
            if (b.isEnabledFor(Level.ALL)) {
                b.debug("Entered getInstance(\"" + string + "\", \"" + string2 + "\", \"" + string3 + "\", \"" + string4 + "\")");
            }
            if ((string5 = CryptixProperties.getProperty("Alg.Alias.Cipher." + string)) != null) {
                string = string5;
            }
            string2 = IJCE.getStandardName(string2, "Mode");
            string3 = IJCE.getStandardName(string3, "PaddingScheme");
            if (b.isEnabledFor(Level.ALL)) {
                b.debug("cipherName=" + string + ",modeName=" + string2 + ",paddingName=" + string3);
            }
            cipher2 = null;
            paddingScheme = null;
            try {
                cipher = (Cipher)IJCE.getImplementation(string + "/" + string2 + "/" + string3, string4, "Cipher");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (string2.equals("ECB")) {
                    cipher = (Cipher)IJCE.getImplementation(string, string4, "Cipher");
                } else {
                    try {
                        cipher = (Cipher)IJCE.getImplementation(string + "/" + string2, string4, "Cipher");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                        cipher2 = (Cipher)IJCE.getImplementation(string, string4, "Cipher");
                        cipher2.a(string, "ECB", "NONE", string4);
                        cipher = (Cipher)IJCE.getImplementation(string2, string4, "Mode");
                    }
                }
                if (string3.equals("NONE")) break block12;
                paddingScheme = (PaddingScheme)IJCE.getImplementation(string3, string4, "PaddingScheme");
            }
        }
        cipher.a(string, string2, string3, string4);
        if (cipher2 != null) {
            ((Mode)cipher).engineSetCipher(cipher2);
        }
        if (paddingScheme != null) {
            cipher.engineSetPaddingScheme(paddingScheme);
        }
        if (b.isEnabledFor(Level.ALL)) {
            b.debug("Created cipher [1]: " + cipher);
        }
        return cipher;
    }

    public static Cipher getInstance(Cipher cipher, Mode mode, PaddingScheme padding) {
        Cipher cipher2;
        if (cipher == null) {
            throw new NullPointerException("cipher == null");
        }
        String string = cipher.getAlgorithm();
        String string2 = mode == null ? "ECB" : mode.getAlgorithm();
        String string3 = padding == null ? "NONE" : padding.getAlgorithm();
        String string4 = cipher.getProvider();
        Cipher cipher3 = null;
        if (mode == null) {
            cipher2 = cipher;
        } else {
            cipher3 = cipher;
            cipher2 = mode;
        }
        cipher2.a(string, string2, string3, string4);
        if (cipher3 != null) {
            ((Mode)cipher2).engineSetCipher(cipher3);
        }
        if (padding != null) {
            cipher2.engineSetPaddingScheme(padding);
        }
        if (b.isEnabledFor(Level.ALL)) {
            b.debug("Created cipher [2]: " + cipher2);
        }
        return cipher2;
    }

    public final int getState() {
        return this.m;
    }

    public final String getAlgorithm() {
        return this.i;
    }

    public final String getMode() {
        return this.j == null ? "ECB" : this.j;
    }

    public final String getPadding() {
        return this.k == null ? "NONE" : this.k;
    }

    public final String getProvider() {
        return this.h;
    }

    public final boolean isPaddingBlockCipher() {
        return this.getPlaintextBlockSize() > 1 && this.getPaddingScheme() != null;
    }

    public final int outBufferSize(int inLen) {
        return this.a(inLen, false);
    }

    public final int outBufferSizeFinal(int inLen) {
        return this.a(inLen, true);
    }

    public final int inBufferSize(int outLen) {
        return this.b(outLen, false);
    }

    public final int inBufferSizeFinal(int outLen) {
        return this.b(outLen, true);
    }

    public final int blockSize() {
        int n2 = this.enginePlaintextBlockSize();
        if (n2 != this.engineCiphertextBlockSize()) {
            throw new IllegalBlockSizeException("blockSize() called when plaintext and ciphertext block sizes differ");
        }
        return n2;
    }

    public final int getInputBlockSize() {
        switch (this.getState()) {
            case 1: {
                return this.enginePlaintextBlockSize();
            }
            case 2: {
                return this.engineCiphertextBlockSize();
            }
            default: {
                IJCE.b("invalid Cipher state: " + this.getState());
            }
            case 0: 
        }
        throw new Error("cipher uninitialized");
    }

    public final int getOutputBlockSize() {
        switch (this.getState()) {
            case 1: {
                return this.engineCiphertextBlockSize();
            }
            case 2: {
                return this.enginePlaintextBlockSize();
            }
            default: {
                IJCE.b("invalid Cipher state: " + this.getState());
            }
            case 0: 
        }
        throw new Error("cipher uninitialized");
    }

    public final int getPlaintextBlockSize() {
        return this.enginePlaintextBlockSize();
    }

    public final int getCiphertextBlockSize() {
        return this.engineCiphertextBlockSize();
    }

    public final void initEncrypt(Key key) throws KeyException {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (this.a) {
            this.a("engineInitEncrypt(<" + key + ">)");
        }
        this.engineInitEncrypt(key);
        this.m = 1;
        this.f = this.enginePlaintextBlockSize();
        this.g = this.engineCiphertextBlockSize();
        if (this.f < 1 || this.g < 1) {
            this.m = 0;
            throw new Error("input or output block size < 1");
        }
        this.d = !this.c && this.f > 1 ? new byte[this.f] : null;
        this.e = 0;
        if (this.l != null) {
            this.l.engineSetBlockSize(this.f);
        }
    }

    public final void initDecrypt(Key key) throws KeyException {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (this.a) {
            this.a("engineInitDecrypt(<" + key + ">)");
        }
        this.engineInitDecrypt(key);
        this.m = 2;
        this.f = this.engineCiphertextBlockSize();
        this.g = this.enginePlaintextBlockSize();
        if (this.f < 1 || this.g < 1) {
            this.m = 0;
            throw new Error("input or output block size < 1");
        }
        this.d = !this.c && this.f > 1 ? new byte[this.f] : null;
        this.e = 0;
        if (this.l != null) {
            this.l.engineSetBlockSize(this.g);
        }
    }

    public final byte[] update(byte[] in) {
        return this.update(in, 0, in.length);
    }

    public final byte[] update(byte[] in, int offset, int length) {
        byte[] byArray = new byte[this.a(length, false)];
        int n2 = this.a(in, offset, length, byArray, 0, false);
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public final int update(byte[] in, int inOffset, int inLen, byte[] out) {
        return this.a(in, inOffset, inLen, out, 0, false);
    }

    public final int update(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        return this.a(in, inOffset, inLen, out, outOffset, false);
    }

    public final byte[] crypt(byte[] in) throws IllegalBlockSizeException {
        return this.crypt(in, 0, in.length);
    }

    public final byte[] crypt(byte[] in, int offset, int length) throws IllegalBlockSizeException {
        byte[] byArray = new byte[this.a(length, true)];
        int n2 = this.a(in, offset, length, byArray, 0, true);
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public final int crypt(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws IllegalBlockSizeException {
        return this.a(in, inOffset, inLen, out, outOffset, true);
    }

    public final byte[] doFinal(byte[] in) throws IllegalBlockSizeException {
        return this.crypt(in, 0, in.length);
    }

    public final byte[] doFinal(byte[] in, int offset, int length) throws IllegalBlockSizeException {
        return this.crypt(in, offset, length);
    }

    public final int doFinal(byte[] in, int inOffset, int inLen, byte[] out) throws IllegalBlockSizeException {
        return this.crypt(in, inOffset, inLen, out, 0);
    }

    public final int doFinal(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws IllegalBlockSizeException {
        return this.crypt(in, inOffset, inLen, out, outOffset);
    }

    private int a(int n2, boolean bl) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        if (!this.c) {
            n3 = (n2 += this.e) % this.f;
            n2 -= n3;
            if (bl && this.m == 1 && (this.l != null || n3 > 0)) {
                n2 += this.f;
            }
        }
        if (n2 < 0) {
            IJCE.b("inLen < 0");
        }
        if (this.a) {
            this.b("engineOutBufferSize(" + n2 + ", " + bl + ")");
        }
        n3 = this.engineOutBufferSize(n2, bl);
        if (this.a) {
            this.a(n3);
        }
        return n3;
    }

    private int b(int n2, boolean bl) {
        int n3;
        if (!this.c && (n3 = n2 % this.g) > 0) {
            n2 += this.g - n3;
        }
        if (this.a) {
            this.b("engineInBufferSize(" + n2 + ", " + bl + ")");
        }
        n3 = this.engineInBufferSize(n2, bl);
        if (this.a) {
            this.a(n3);
        }
        if (!this.c) {
            if (bl && this.m == 1 && this.l != null) {
                n3 -= this.f;
            }
            n3 -= this.e;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    private int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) {
        if (this.a) {
            this.b("updateInternal(<" + Cipher.a(byArray) + ">, " + n2 + ", " + n3 + ", <" + Cipher.a(byArray2) + ">, " + n4 + ", " + bl + ")");
        }
        boolean bl2 = false;
        int n5 = n4;
        try {
            byte[] byArray3;
            if (this.m == 0) {
                throw new IllegalStateException("cipher uninitialized");
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("inLen < 0");
            }
            if (n2 < 0 || n4 < 0 || (long)n2 + (long)n3 > (long)byArray.length) {
                if (b.isEnabledFor(Level.ALL)) {
                    b.debug("inOffset = " + n2 + ", inLen = " + n3 + ", outOffset = " + n4 + ", in.length = " + byArray.length);
                }
                throw new ArrayIndexOutOfBoundsException("inOffset < 0  || outOffset < 0 || (long)inOffset+inLen > in.length");
            }
            if (byArray2 == null) {
                throw new NullPointerException();
            }
            if (this.d == null) {
                int n6;
                if (this.a) {
                    this.b("engineUpdate(<" + Cipher.a(byArray) + ">, " + n2 + ", " + n3 + ", <" + Cipher.a(byArray2) + ">, " + n4 + ")");
                    n6 = this.engineUpdate(byArray, n2, n3, byArray2, n4);
                    this.a(n6);
                    n4 += n6;
                    if (bl && this.c) {
                        this.b("engineCrypt(<" + Cipher.a(byArray2) + ">, " + n4 + ")");
                        n6 = this.engineCrypt(byArray2, n4);
                        this.a(n6);
                        n4 += n6;
                    }
                } else {
                    n4 += this.engineUpdate(byArray, n2, n3, byArray2, n4);
                    if (bl && this.c) {
                        n4 += this.engineCrypt(byArray2, n4);
                    }
                }
                n6 = n4 - n5;
                return n6;
            }
            if (byArray == byArray2 && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)this.a(n3, bl))) {
                byArray3 = new byte[n3];
                System.arraycopy(byArray, n2, byArray3, 0, n3);
                byArray = byArray3;
                n2 = 0;
            }
            if (bl) {
                if (this.m == 1) {
                    n4 += this.a(byArray, n2, n3, byArray2, n4, false);
                    if (this.l == null) {
                        if (this.e > 0) {
                            this.e = 0;
                            throw new IllegalBlockSizeException(this.getAlgorithm() + ": Non-padding cipher in ENCRYPT state with an incomplete final block");
                        }
                        int n7 = n4 - n5;
                        return n7;
                    }
                    this.l.pad(this.d, 0, this.e);
                    this.e = 0;
                    if (this.a) {
                        this.b("engineUpdate(<" + Cipher.a(this.d) + ">, 0, " + this.f + ", <" + Cipher.a(byArray2) + ">, " + n4 + ")");
                    }
                    int n8 = this.engineUpdate(this.d, 0, this.f, byArray2, n4);
                    if (this.a) {
                        this.a(n8);
                    }
                    int n9 = (n4 += n8) - n5;
                    return n9;
                }
                if (this.l != null) {
                    if (n3 == 0) {
                        int n10 = 0;
                        return n10;
                    }
                    n4 += this.a(byArray, n2, n3 - 1, byArray2, n4, false);
                    if (this.e != this.f - 1) {
                        this.e = 0;
                        throw new IllegalBlockSizeException(this.getAlgorithm() + ": Cipher in DECRYPT state with an incomplete final block");
                    }
                    this.d[this.e] = byArray[n2 + n3 - 1];
                    this.e = 0;
                    byArray3 = new byte[this.a(this.f, false)];
                    if (this.a) {
                        this.b("engineUpdate(<" + Cipher.a(this.d) + ">, 0, " + this.f + ", <" + Cipher.a(byArray3) + ">, 0)");
                    }
                    int n11 = this.engineUpdate(this.d, 0, this.f, byArray3, 0);
                    if (this.a) {
                        this.a(n11);
                    }
                    int n12 = this.l.unpad(byArray3, 0, byArray3.length);
                    System.arraycopy(byArray3, 0, byArray2, n4, n12);
                    int n13 = (n4 += n12) - n5;
                    return n13;
                }
            }
            if (this.e > 0) {
                if ((long)n3 + (long)this.e < (long)this.f) {
                    System.arraycopy(byArray, n2, this.d, this.e, n3);
                    this.e += n3;
                    int n14 = 0;
                    return n14;
                }
                int n15 = this.f - this.e;
                System.arraycopy(byArray, n2, this.d, this.e, n15);
                n2 += n15;
                n3 -= n15;
                if (this.a) {
                    this.b("engineUpdate(<" + Cipher.a(this.d) + ">, 0, " + this.f + ", <" + Cipher.a(byArray2) + ">, " + n4 + ")");
                }
                int n16 = this.engineUpdate(this.d, 0, this.f, byArray2, n4);
                if (this.a) {
                    this.a(n16);
                }
                n4 += n16;
            }
            this.e = n3 % this.f;
            if (this.e > 0) {
                System.arraycopy(byArray, n2 + n3 - this.e, this.d, 0, this.e);
                n3 -= this.e;
            }
            while (n3 > 0) {
                if (this.a) {
                    this.b("engineUpdate(<" + Cipher.a(byArray) + ">, " + n2 + ", " + this.f + ", <" + Cipher.a(byArray2) + ">, " + n4 + ")");
                }
                int n17 = this.engineUpdate(byArray, n2, this.f, byArray2, n4);
                if (this.a) {
                    this.a(n17);
                }
                n4 += n17;
                n2 += this.f;
                n3 -= this.f;
            }
            int n18 = n4 - n5;
            return n18;
        }
        catch (RuntimeException runtimeException) {
            if (this.a) {
                runtimeException.printStackTrace();
            }
            bl2 = true;
            throw runtimeException;
        }
        finally {
            if (this.a && !bl2) {
                this.a(n4 - n5);
            }
        }
    }

    @Override
    public void setParameter(String param, Object value) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (param == null) {
            throw new NullPointerException("param == null");
        }
        if (this.a) {
            this.a("engineSetParameter(\"" + param + "\", <" + value + ">)");
        }
        this.engineSetParameter(param, value);
    }

    @Override
    public Object getParameter(String param) throws NoSuchParameterException, InvalidParameterException {
        if (param == null) {
            throw new NullPointerException("param == null");
        }
        if (this.a) {
            this.b("engineGetParameter(\"" + param + "\")");
        }
        Object object = this.engineGetParameter(param);
        if (this.a) {
            this.c("<" + object + ">");
        }
        return object;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return "Cipher [" + this.getProvider() + " " + this.getAlgorithm() + "/" + this.getMode() + "/" + this.getPadding() + "]";
    }

    protected void engineSetPaddingScheme(PaddingScheme padding) {
        if (this.m != 0) {
            throw new IllegalStateException("Cipher is already initialized");
        }
        this.l = padding;
    }

    protected int engineBlockSize() {
        throw new Error("cipher classes must implement either engineBlockSize, or enginePlaintextBlockSize and engineCiphertextBlockSize");
    }

    protected int enginePlaintextBlockSize() {
        return this.engineBlockSize();
    }

    protected int engineCiphertextBlockSize() {
        return this.engineBlockSize();
    }

    protected int engineOutBufferSize(int inLen, boolean isFinal) {
        return inLen / this.f * this.g;
    }

    protected int engineInBufferSize(int outLen, boolean isFinal) {
        return outLen / this.g * this.f;
    }

    protected abstract void engineInitEncrypt(Key var1) throws KeyException;

    protected abstract void engineInitDecrypt(Key var1) throws KeyException;

    protected abstract int engineUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5);

    protected int engineCrypt(byte[] out, int outOffset) {
        return 0;
    }

    protected void engineSetParameter(String param, Object value) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        throw new NoSuchParameterException(this.getAlgorithm() + ": " + param);
    }

    protected Object engineGetParameter(String param) throws NoSuchParameterException, InvalidParameterException {
        throw new NoSuchParameterException(this.getAlgorithm() + ": " + param);
    }

    public static String[] getAlgorithms(Provider provider) {
        return IJCE.getAlgorithms(provider, "Cipher");
    }

    public static String[] getAlgorithms() {
        return IJCE.getAlgorithms("Cipher");
    }
}

