/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.AMQP;

import au.com.aemo.Common.AMQP.AMQPChannelException;
import au.com.aemo.Common.AMQP.AMQPChannelFactory;
import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import com.rabbitmq.client.Channel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQPChannelPool {
    private static Logger logger = LoggerFactory.getLogger(AMQPChannelPool.class);
    private GenericObjectPool<Channel> internalPool;
    public static GenericObjectPoolConfig defaultConfig;
    private Date itsPoolLastCleared;
    private int itsPoolTimeoutMins;
    private String itsId;
    private String itsConfigId;
    private Properties itsConfiguration;
    private Integer itsPrefetchCount;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public AMQPChannelPool(String string, String string2, Properties properties, String string3) throws ApplicationException {
        this.itsId = string2;
        this.itsConfigId = string + "_" + this.itsId + "_";
        this.itsConfiguration = properties;
        String string4 = Util.getProperty(properties, this.itsConfigId + "amqp_prefetch_count", null);
        this.itsPrefetchCount = Util.isBlank(string4) ? null : Integer.valueOf(string4);
        this.createAMQPConnectionPool();
    }

    public String getId() {
        return this.itsId;
    }

    public Integer getPrefetchCount() {
        return this.itsPrefetchCount;
    }

    private void createAMQPConnectionPool() {
        if (this.internalPool != null) {
            try {
                this.internalPool.clear();
                this.internalPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setBlockWhenExhausted(true);
        genericObjectPoolConfig.setMaxTotal(Integer.parseInt(Util.getProperty(this.itsConfiguration, this.itsConfigId + "amqp_max_connections", "10")));
        genericObjectPoolConfig.setTestWhileIdle(true);
        genericObjectPoolConfig.setTimeBetweenEvictionRuns(Duration.ofSeconds(Long.parseLong(Util.getProperty(this.itsConfiguration, this.itsConfigId + "amqp_eviction_cycle", "120"))));
        genericObjectPoolConfig.setMinEvictableIdleTime(Duration.ofSeconds(Integer.parseInt(Util.getProperty(this.itsConfiguration, this.itsConfigId + "amqp_eviction_timeout", "1800"))));
        genericObjectPoolConfig.setTestOnBorrow(true);
        genericObjectPoolConfig.setTestOnReturn(true);
        genericObjectPoolConfig.setLifo(true);
        genericObjectPoolConfig.setMaxWait(Duration.ofSeconds(Integer.parseInt(Util.getProperty(this.itsConfiguration, this.itsConfigId + "amqp_max_wait", "30"))));
        this.internalPool = new GenericObjectPool((PooledObjectFactory)new AMQPChannelFactory(this.itsPrefetchCount, this.itsId, this.itsConfigId, this.itsConfiguration));
        this.internalPool.setConfig(genericObjectPoolConfig);
        this.itsPoolLastCleared = new Date();
        this.itsPoolTimeoutMins = Integer.parseInt(Util.getProperty(this.itsConfiguration, this.itsConfigId + "amqp_pool_timeout", "10"));
    }

    public void returnChannel(Channel channel) {
        try {
            if (channel.isOpen()) {
                this.internalPool.returnObject((Object)channel);
            } else {
                this.internalPool.invalidateObject((Object)channel);
            }
        }
        catch (Exception exception) {
            throw new AMQPChannelException("Could not return the resource to the AMQP pool: " + exception.getMessage(), exception);
        }
    }

    public Channel getChannel() {
        try {
            return (Channel)this.internalPool.borrowObject();
        }
        catch (NoSuchElementException noSuchElementException) {
            if (null == noSuchElementException.getCause()) {
                throw new AMQPChannelException("Could not get a resource since the AMQP pool is exhausted", noSuchElementException);
            }
            throw new AMQPChannelException("Could not get a resource from the AMQP pool: " + noSuchElementException.getMessage(), noSuchElementException);
        }
        catch (Exception exception) {
            throw new AMQPChannelException("Could not get a resource from the AMQP pool: " + exception.getMessage(), exception);
        }
    }

    public synchronized void clearCache() {
        try {
            Date date = Util.dateOffset(new Date(), -this.itsPoolTimeoutMins, 12);
            if (this.itsPoolLastCleared.before(date)) {
                this.createAMQPConnectionPool();
                Util_Logger.warning(logger, "Flushed AMQP connection pool");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error clearing object pool cache for AMQPChannelPool:" + exception.getMessage(), exception);
        }
    }
}

