/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.API;

import au.com.aemo.Common.Authentication.AuthenticationManager;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Authentication.IdentityPrincipal;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebPath(value="/api/authentication/users")
public class WebAPIAuthenticationUsers {
    private static Logger logger = LoggerFactory.getLogger(WebAPIAuthenticationUsers.class);

    @WebGET(AdminAccessOnly=true, Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getUsers() {
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        String string = JsonUtilities.listToJson(authenticationManager.getUsers());
        return string;
    }

    @WebPOST(AdminAccessOnly=true, Action=AuthorisationActionEnum.WRITE)
    @WebContent(value=WebContent.MediaType.TEXT_PLAIN)
    public String createUser(@WebParam(source="_body", mandatory=true, validator=WebParamValidationEnum.NONE) String string) throws Exception {
        if (Util.isBlank(string)) {
            throw new Exception("Detected empty POST data");
        }
        Object object = null;
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        try {
            IdentityPrincipal identityPrincipal = JsonUtilities.fromJson(string, IdentityPrincipal.class);
            authenticationManager.createUser(identityPrincipal);
            object = "Successfully saved user";
        }
        catch (Exception exception) {
            object = "Failed to save user: " + exception.getMessage();
        }
        return object;
    }
}

