/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Alerting;

import au.com.aemo.Common.Alerting.AlertConfig;
import au.com.aemo.Common.Alerting.AlertDelivery;
import au.com.aemo.Common.Application.AppConfiguration;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Scheduler.JobSchedulerManager;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertManager {
    private static Logger logger = LoggerFactory.getLogger(AlertManager.class);

    public static AlertConfig loadConfigFromProperties(Properties properties) {
        AlertConfig alertConfig = new AlertConfig();
        alertConfig.CronJobSchedule = Util.getProperty(properties, "alert_test_message_cron_job_schedule", null);
        alertConfig.TestMessageText = Util.getProperty(properties, "alert_test_message_text", null);
        return alertConfig;
    }

    public static void configureAlert(AppConfiguration appConfiguration) {
        try {
            AlertConfig alertConfig = appConfiguration.Alert;
            if (alertConfig != null && !Util.isBlank(alertConfig.CronJobSchedule)) {
                JobSchedulerManager jobSchedulerManager = JobSchedulerManager.getInstance();
                if (Util.isBlank(alertConfig.TestMessageText)) {
                    alertConfig.TestMessageText = "Alert Test Message: " + appConfiguration.AppName + " v" + appConfiguration.AppVersion + " on " + System.getProperty("hostname");
                }
                String string = "AlertTestMessage";
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("MESSAGE", alertConfig.TestMessageText);
                jobSchedulerManager.scheduleJob(string, "AlertTestMessage", alertConfig.CronJobSchedule, new AlertDelivery(), hashMap);
                jobSchedulerManager.start();
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error configuring alert monitor: " + exception.getMessage(), exception);
        }
    }
}

