/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Application;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockLocal;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.File;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceLockManager {
    private static Logger logger = LoggerFactory.getLogger(InstanceLockManager.class);
    private fsFileInfo itsLockFile;

    private InstanceLockManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                InstanceLockManager.releaseLock();
            }
        });
    }

    public static InstanceLockManager getInstance() {
        return SingletonHolder.instance;
    }

    public boolean setLock(String string) {
        this.itsLockFile = new fsFileInfo(new File(string));
        this.itsLockFile.setFileType(fsFileTypeEnum.FILE);
        fsFileLockLocal fsFileLockLocal2 = new fsFileLockLocal();
        fsFileLockLocal2.lockFile(this.itsLockFile);
        return this.itsLockFile.hasValidLock();
    }

    public void touchLockFile() {
        try {
            if (this.itsLockFile != null) {
                byte[] byArray = Util.dateToStr(new Date(), "dd/MM/yyyy HH:mm:ss").getBytes();
                this.itsLockFile.getLockData().updateLockedFileContents(byArray);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error touching application instance lock file: " + exception.getMessage(), exception);
        }
    }

    public static void releaseLock() {
        InstanceLockManager instanceLockManager = InstanceLockManager.getInstance();
        instanceLockManager.releaseFileLock();
    }

    private void releaseFileLock() {
        try {
            if (this.itsLockFile != null) {
                this.itsLockFile.releaseLock();
                FileUtilities.deleteFile(this.itsLockFile.getPath());
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error releasing application instance lock file: " + exception.getMessage(), exception);
        }
    }

    private static class SingletonHolder {
        private static InstanceLockManager instance = new InstanceLockManager();

        private SingletonHolder() {
        }
    }
}

