/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Certificate;

import au.com.aemo.Common.Application.ApplicationManager;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Certificate.CertificateStoreConfig;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Java.propertiesFileEntry;
import au.com.aemo.Common.Java.propertiesFileUpdater;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppCertificateManager {
    public static final String VERSION = "1.0.0";
    private static final String PARAM_WEBSERVER_PORT = "web_server_port";
    private static final String PARAM_INSTANCE_IDENTIFIER = "instance_identifier";
    private static Logger logger = LoggerFactory.getLogger(AppCertificateManager.class);

    private static void listCertificates(CertificateManager certificateManager, String string) {
        certificateManager.logCertificates(string);
    }

    private static void removeCertificate(CertificateManager certificateManager, CommandLine commandLine) throws Exception {
        String string = commandLine.getOptionValue("remove");
        certificateManager.removeCertificate(string);
    }

    private static void updatePropertiesFile(CertificateStoreConfig certificateStoreConfig, String string, String string2, String string3) throws Exception {
        ArrayList<propertiesFileEntry> arrayList = new ArrayList<propertiesFileEntry>();
        propertiesFileEntry propertiesFileEntry2 = new propertiesFileEntry();
        propertiesFileEntry2.Name = string2 + "_https_keystore_file";
        propertiesFileEntry2.Value = certificateStoreConfig.KeyStoreFile;
        propertiesFileEntry2.InsertAfter = string3;
        arrayList.add(propertiesFileEntry2);
        propertiesFileEntry2 = new propertiesFileEntry();
        propertiesFileEntry2.Name = string2 + "_https_keystore_type";
        propertiesFileEntry2.Value = certificateStoreConfig.KeyStoreType;
        propertiesFileEntry2.InsertAfter = string2 + "_https_keystore_file";
        arrayList.add(propertiesFileEntry2);
        propertiesFileUpdater propertiesFileUpdater2 = new propertiesFileUpdater();
        propertiesFileUpdater2.run(string, arrayList);
    }

    private static void createCertificate(CertificateManager certificateManager, CommandLine commandLine, String string, String string2, CertificateStoreConfig certificateStoreConfig, String string3, String string4) throws Exception {
        if (Util.isBlank(string2)) {
            throw new Exception("Missing configuration for instance_identifier in " + string3);
        }
        String string5 = commandLine.getOptionValue("validity");
        if (!Util.isInteger(string5)) {
            throw new Exception("Invalid option -validity, parameter must be an integer");
        }
        if (Util.isBlank(string5)) {
            throw new Exception("Missing option -validity to specify the certificate end in elapsed days");
        }
        int n = Integer.parseInt(string5);
        String string6 = commandLine.getOptionValue("ext", null);
        String string7 = string + "_" + string2 + "_" + Util.dateToStr(new Date(), "yyyyMMdd");
        certificateManager.createCertificate(string7, n, string6);
        AppCertificateManager.updatePropertiesFile(certificateStoreConfig, string3, string4, PARAM_WEBSERVER_PORT);
    }

    private static void importCertificate(CertificateManager certificateManager, CommandLine commandLine, CertificateStoreConfig certificateStoreConfig, String string, String string2) throws Exception {
        String string3 = commandLine.getOptionValue("import");
        String string4 = commandLine.getOptionValue("alias");
        if (Util.isBlank(string4)) {
            throw new Exception("Missing option -alias to specify the certificate alias for import");
        }
        certificateManager.importCertificate(string3, string4);
        AppCertificateManager.updatePropertiesFile(certificateStoreConfig, string, string2, PARAM_INSTANCE_IDENTIFIER);
    }

    private static void importCertificateToChain(CertificateManager certificateManager, CommandLine commandLine) throws Exception {
        String string = commandLine.getOptionValue("chain");
        String string2 = commandLine.getOptionValue("alias");
        if (Util.isBlank(string2)) {
            throw new Exception("Missing option -alias to specify the certificate alias for import");
        }
        certificateManager.addCertificatesToChain(string2, Util.getList(string, ','));
    }

    private static void importCertificateSignRequestReply(CertificateManager certificateManager, CommandLine commandLine) throws Exception {
        String string = commandLine.getOptionValue("reply");
        String string2 = commandLine.getOptionValue("alias");
        if (Util.isBlank(string2)) {
            throw new Exception("Missing option -alias to specify for importing cert signing request response");
        }
        certificateManager.importCertificateSignRequestReply(string2, string);
    }

    private static void exportCertificate(CertificateManager certificateManager, CommandLine commandLine) throws Exception {
        String string = commandLine.getOptionValue("export");
        String string2 = commandLine.getOptionValue("alias");
        if (Util.isBlank(string2)) {
            throw new Exception("Missing option -alias to specify for exporting a certificate");
        }
        certificateManager.exportCertificate(string2, string);
    }

    private static void createCertificateSigningRequest(CertificateManager certificateManager, CommandLine commandLine) throws Exception {
        String string = commandLine.getOptionValue("certsignreq");
        String string2 = commandLine.getOptionValue("alias");
        if (Util.isBlank(string2)) {
            throw new Exception("Missing option -alias to specify for exporting a certificate");
        }
        certificateManager.createCertificateSigningRequest(string2, string);
    }

    private static CertificateStoreConfig loadCertStoreConfig(String string, Properties properties, String string2, CommandLine commandLine, String string3, boolean bl) throws Exception {
        Object object = string2 == null ? "" : string2 + "_";
        String string4 = (String)object + "https_keystore_file";
        String string5 = (String)object + "https_store_password";
        String string6 = (String)object + "https_key_password";
        CertificateStoreConfig certificateStoreConfig = CertificateManager.loadConfigFromProperties(properties, string2);
        if (certificateStoreConfig == null) {
            if (bl) {
                certificateStoreConfig = new CertificateStoreConfig();
                certificateStoreConfig.AllowToCreate = true;
                File file = new File(string);
                certificateStoreConfig.KeyStoreFile = file.getName().substring(0, file.getName().lastIndexOf(".")) + ".cert_" + string3.toLowerCase() + "." + certificateStoreConfig.KeyStoreType.toLowerCase();
                Util_Logger.info(logger, "Generated default name for keystore file [" + certificateStoreConfig.KeyStoreFile + "]");
            } else {
                throw new Exception("Missing definition for [" + string4 + "] in " + string);
            }
        }
        if (Util.isBlank(certificateStoreConfig.KeyStoreFile)) {
            certificateStoreConfig.KeyStoreFile = commandLine.getOptionValue("keystore");
        } else {
            Util_Logger.info(logger, "Using [" + string4 + "] from properties file");
        }
        if (Util.isBlank(certificateStoreConfig.KeyStoreFile)) {
            throw new Exception("keystore parameter must be supplied as no definition for [" + string4 + "] in " + string);
        }
        if (!Util.isBlank(certificateStoreConfig.StorePassword)) {
            Util_Logger.info(logger, "Using [" + string5 + "] from properties file");
        }
        if (!Util.isBlank(certificateStoreConfig.KeyPassword)) {
            Util_Logger.info(logger, "Using [" + string6 + "] from properties file");
        }
        return certificateStoreConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) throws Exception {
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        try {
            String string;
            Options options = new Options();
            OptionGroup optionGroup = new OptionGroup();
            optionGroup.setRequired(true);
            Option option = new Option("s", "server", false, "Web Server keystore");
            optionGroup.addOption(option);
            Option option2 = new Option("c", "client", false, "Client keystore");
            optionGroup.addOption(option2);
            options.addOptionGroup(optionGroup);
            OptionGroup optionGroup2 = new OptionGroup();
            optionGroup2.setRequired(true);
            Option option3 = new Option("l", "list", false, "List certificates");
            optionGroup2.addOption(option3);
            Option option4 = new Option("r", "remove", true, "Remove certificate from keystore");
            optionGroup2.addOption(option4);
            Option option5 = new Option("cr", "create", false, "Create certificate and add to keystore");
            optionGroup2.addOption(option5);
            Option option6 = new Option("i", "import", true, "Import certificate and add to keystore");
            optionGroup2.addOption(option6);
            Option option7 = new Option("ch", "chain", true, "Import certificate and add to chain in keystore");
            optionGroup2.addOption(option7);
            Option option8 = new Option("rp", "reply", true, "Import CA reply from certificate signing request");
            optionGroup2.addOption(option8);
            Option option9 = new Option("e", "export", true, "Export certificate to file");
            optionGroup2.addOption(option9);
            Option option10 = new Option("sr", "certsignreq", true, "Create certificate signing request");
            optionGroup2.addOption(option10);
            options.addOptionGroup(optionGroup2);
            options.addOption("al", "alias", true, "The alias of a certificate");
            options.addRequiredOption("ap", "application", true, "The application name");
            options.addOption("cn", "configuration", true, "The properties configuration file");
            options.addRequiredOption("d", "defaultconfiguration", true, "The default properties configuration file");
            options.addOption("v", "validity", true, "The validity days");
            options.addOption("k", "keystore", true, "The keystore filename");
            options.addOption("x", "ext", true, "The X509 extension attributes");
            DefaultParser defaultParser = new DefaultParser();
            CommandLine commandLine = null;
            try {
                commandLine = defaultParser.parse(options, stringArray);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp(AppCertificateManager.class.getName(), options);
                System.exit(1);
            }
            String string2 = commandLine.getOptionValue("application");
            String string3 = commandLine.getOptionValue("defaultconfiguration", null);
            String string4 = commandLine.getOptionValue("configuration", string3);
            applicationManager.init(string4, "AppCreateCertificate", VERSION, string2, AppCertificateManager.class, applicationManager.buildStartOptions());
            Properties properties = Util.getPropertiesObject(string4);
            String string5 = properties.getProperty(PARAM_INSTANCE_IDENTIFIER);
            boolean bl = commandLine.hasOption("server");
            boolean bl2 = commandLine.hasOption("client");
            boolean bl3 = commandLine.hasOption("create");
            boolean bl4 = commandLine.hasOption("import");
            boolean bl5 = bl4 || bl3;
            String string6 = bl ? "Server" : "Trusted";
            String string7 = string = bl ? "web_server" : "client";
            if (bl && !properties.containsKey(PARAM_WEBSERVER_PORT)) {
                throw new Exception("Application is not configured to support web services, no definition for [web_server_port] in " + string4);
            }
            CertificateStoreConfig certificateStoreConfig = AppCertificateManager.loadCertStoreConfig(string4, properties, string, commandLine, string6, bl5);
            CertificateManager certificateManager = CertificateManager.getInstance();
            certificateManager.setCertStoreConfig(certificateStoreConfig);
            if (commandLine.hasOption("list")) {
                AppCertificateManager.listCertificates(certificateManager, string6);
            } else if (commandLine.hasOption("remove")) {
                AppCertificateManager.removeCertificate(certificateManager, commandLine);
            } else if (bl3) {
                AppCertificateManager.createCertificate(certificateManager, commandLine, string2, string5, certificateStoreConfig, string4, string);
            } else if (bl4) {
                AppCertificateManager.importCertificate(certificateManager, commandLine, certificateStoreConfig, string4, string);
            } else if (commandLine.hasOption("chain")) {
                if (!bl2) throw new Exception("Chain option is only valid for a Client based keystore");
                AppCertificateManager.importCertificateToChain(certificateManager, commandLine);
            } else if (commandLine.hasOption("reply")) {
                AppCertificateManager.importCertificateSignRequestReply(certificateManager, commandLine);
            } else if (commandLine.hasOption("export")) {
                AppCertificateManager.exportCertificate(certificateManager, commandLine);
            } else if (commandLine.hasOption("certsignreq")) {
                AppCertificateManager.createCertificateSigningRequest(certificateManager, commandLine);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error managing certificates: " + exception.getMessage(), exception);
        }
        applicationManager.shutdown();
    }
}

