/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Cryptography;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Application.XProperties;
import au.com.aemo.Common.Cryptography.CryptProviderFactory;
import au.com.aemo.Common.Cryptography.CryptProviderInt;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Crypt {
    private static Logger logger = LoggerFactory.getLogger(Crypt.class);
    private CryptProviderInt secObject;
    private String itsSeed;

    public static Crypt getInstance() {
        return SingletonHolder.instance;
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="Required for docker")
    private Crypt() {
        try {
            File file = new File("/run/secrets/pdr_key");
            if (file.exists()) {
                XProperties xProperties = new XProperties();
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    xProperties.load(fileInputStream);
                    this.itsSeed = Util.getProperty((Properties)xProperties, "hash", "381DA419C63BF771");
                }
            } else {
                this.itsSeed = Util.getProperty("pdr_key.properties", "hash", "381DA419C63BF771");
            }
            if (!Util.isBlank(this.itsSeed)) {
                this.secObject = CryptProviderFactory.getProvider(this.itsSeed);
            } else {
                Util_Logger.errorNoRaise(logger, "Error initialising Crypt provider, unable to retrieve encryption key");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error initialising Crypt provider: " + exception.getMessage(), exception);
        }
    }

    public void setSeed(String string) {
        this.secObject = CryptProviderFactory.getProvider(string);
    }

    public String getSeed() {
        return this.itsSeed;
    }

    public String encrypt(String string) throws ApplicationException {
        String string2 = null;
        try {
            string2 = this.secObject.encrypt(string);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing encrypt: " + exception.getMessage(), exception);
        }
        return string2;
    }

    public String decrypt(String string) throws ApplicationException {
        String string2 = null;
        try {
            string2 = this.secObject.decrypt(string);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing decrypt: " + exception.getMessage(), exception);
        }
        return string2;
    }

    public static void main(String[] stringArray) throws ApplicationException {
        try {
            Crypt crypt = Crypt.getInstance();
            System.out.println("Passwd - encrypting - " + stringArray[0]);
            String string = crypt.encrypt(stringArray[0]);
            System.out.println("Returns - " + string);
            System.out.println("Decrypting - " + crypt.decrypt(string));
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing encrypt: " + exception.getMessage(), exception);
        }
    }

    private static class SingletonHolder {
        private static Crypt instance = new Crypt();

        private SingletonHolder() {
        }
    }
}

