/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.DataVault;

import au.com.aemo.Common.DataVault.AWSContainerMeta;
import au.com.aemo.Common.DataVault.AWSKeyResponse;
import au.com.aemo.Common.DataVault.AWSSecretRequest;
import au.com.aemo.Common.DataVault.AWSSecretResponse;
import au.com.aemo.Common.DataVault.ApplicationDataVaultProviderInt;
import au.com.aemo.Common.DataVault.ApplicationDataVaultToken;
import au.com.aemo.Common.DataVault.DataVault;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebHelper;
import au.com.aemo.Common.Web.WebHttpResponse;
import au.com.aemo.Common.Web.WebRequestConfig;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.lucasweb.aws.v4.signer.HttpRequest;
import uk.co.lucasweb.aws.v4.signer.Signer;
import uk.co.lucasweb.aws.v4.signer.credentials.AwsCredentials;
import uk.co.lucasweb.aws.v4.signer.hash.Sha256;

public class ApplicationDataVaultProviderAWSSecretsManager
implements ApplicationDataVaultProviderInt {
    private static Logger logger = LoggerFactory.getLogger(ApplicationDataVaultProviderAWSSecretsManager.class);
    private static final String ID = "AWS_SECRETS_MANAGER";
    private static final String AUTH_METHOD_VMMI = "VMMI";
    private DataVault Config;
    private ApplicationDataVaultToken Token;
    private String Region;
    private String MetaAccessToken;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void initialise(DataVault dataVault) throws Exception {
        if (Util.isBlank(dataVault.Reference)) {
            Util_Logger.error(logger, "URL reference is not defined for AWS Secrets Manager [" + dataVault.Name + "]");
        }
        if (Util.isBlank(dataVault.AuthMethod)) {
            Util_Logger.error(logger, "Auth Method is not defined for AWS Secrets Manager [" + dataVault.Name + "]");
        }
        if (Util.isBlank(dataVault.ServiceContext)) {
            Util_Logger.error(logger, "Service context is not defined for AWS Secrets Manager [" + dataVault.Name + "]");
        }
        this.Config = dataVault;
        this.Token = this.getToken();
        if (this.Token == null) {
            throw new Exception("Failed to initialise AWS Secrets Manager [" + this.Config.Name + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationDataVaultToken getToken() {
        ApplicationDataVaultToken applicationDataVaultToken = null;
        if (this.Config.AuthMethod.toUpperCase().startsWith(AUTH_METHOD_VMMI)) {
            HttpURLConnection httpURLConnection = null;
            try {
                Object object;
                URL uRL = null;
                WebHttpResponse webHttpResponse = null;
                String string = System.getenv("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI");
                if (null == string) {
                    uRL = new URL("http://169.254.169.254/latest/api/token");
                    httpURLConnection = WebHelper.getHttpURLConnection(uRL, "PUT", new WebRequestConfig(){

                        @Override
                        public void configure(HttpURLConnection httpURLConnection) {
                            httpURLConnection.setRequestProperty("X-aws-ec2-metadata-token-ttl-seconds", "21600");
                        }
                    });
                    webHttpResponse = WebHelper.readResponse(httpURLConnection);
                    if (webHttpResponse.ReturnCode != 200) {
                        throw new Exception("URL " + uRL.getPath() + " HTTP Response code " + webHttpResponse.ReturnCode);
                    }
                    this.MetaAccessToken = webHttpResponse.Body;
                    httpURLConnection.disconnect();
                }
                uRL = null == string ? new URL("http://169.254.169.254/latest/meta-data/placement/region") : new URL(System.getenv("ECS_CONTAINER_METADATA_URI_V4") + "/task");
                httpURLConnection = WebHelper.getHttpURLConnection(uRL, "GET", new WebRequestConfig(){

                    @Override
                    public void configure(HttpURLConnection httpURLConnection) {
                        httpURLConnection.setRequestProperty("X-aws-ec2-metadata-token", ApplicationDataVaultProviderAWSSecretsManager.this.MetaAccessToken);
                    }
                });
                webHttpResponse = WebHelper.readResponse(httpURLConnection);
                Util_Logger.info(logger, "response: " + webHttpResponse.Body);
                if (webHttpResponse.ReturnCode == 200) {
                    if (null == string) {
                        this.Region = webHttpResponse.Body;
                    } else {
                        object = JsonUtilities.fromJson(webHttpResponse.Body, AWSContainerMeta.class);
                        if (null != ((AWSContainerMeta)object).AvailabilityZone) {
                            this.Region = ((AWSContainerMeta)object).AvailabilityZone.substring(0, ((AWSContainerMeta)object).AvailabilityZone.length() - 1);
                        }
                    }
                } else {
                    throw new Exception("URL " + uRL.getPath() + " HTTP Response code " + webHttpResponse.ReturnCode);
                }
                httpURLConnection.disconnect();
                uRL = null == string ? new URL("http://169.254.169.254/latest/meta-data/iam/security-credentials/" + this.Config.ServiceContext) : new URL("http://169.254.170.2" + string);
                httpURLConnection = WebHelper.getHttpURLConnection(uRL, "GET", new WebRequestConfig(){

                    @Override
                    public void configure(HttpURLConnection httpURLConnection) {
                        httpURLConnection.setRequestProperty("X-aws-ec2-metadata-token", ApplicationDataVaultProviderAWSSecretsManager.this.MetaAccessToken);
                    }
                });
                webHttpResponse = WebHelper.readResponse(httpURLConnection);
                if (webHttpResponse.ReturnCode != 200) {
                    throw new Exception("URL " + uRL.getPath() + " HTTP Response code " + webHttpResponse.ReturnCode);
                }
                object = JsonUtilities.fromJson(webHttpResponse.Body, AWSKeyResponse.class);
                applicationDataVaultToken = new ApplicationDataVaultToken(((AWSKeyResponse)object).AccessKeyId + ":" + ((AWSKeyResponse)object).SecretAccessKey + ":" + ((AWSKeyResponse)object).Token, ((AWSKeyResponse)object).Expiration);
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error extracting managed identity token for AWS Secrets Manager : " + exception.getMessage(), exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        } else {
            Util_Logger.errorNoRaise(logger, "Detected unsupported Auth_Method [" + this.Config.AuthMethod + "] in AWS Secrets Manager [" + this.Config.Name + "] configuration");
        }
        return applicationDataVaultToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue(String string) {
        String string2 = null;
        if (this.Token == null) {
            this.Token = this.getToken();
        } else if (this.Token.isExpired()) {
            this.Token = this.getToken();
        }
        if (this.Token == null) {
            Util_Logger.errorNoRaise(logger, "Unable to extract AWS Secrets Manager secret [" + string + "] as authorisation token is unavailable");
        } else {
            HttpURLConnection httpURLConnection = null;
            try {
                AWSSecretResponse aWSSecretResponse;
                OffsetDateTime offsetDateTime = OffsetDateTime.now(ZoneOffset.UTC);
                final String string3 = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").format(offsetDateTime);
                AWSSecretRequest aWSSecretRequest = new AWSSecretRequest();
                aWSSecretRequest.SecretId = this.Config.Reference;
                aWSSecretRequest.VersionStage = "AWSCURRENT";
                final String string4 = JsonUtilities.toJson(aWSSecretRequest);
                String string5 = Sha256.get((String)string4, (Charset)Charset.forName("UTF-8"));
                String[] stringArray = Util.getColumns(this.Token.getToken(), ':');
                String string6 = stringArray[0];
                String string7 = stringArray[1];
                final String string8 = stringArray[2];
                String string9 = "secretsmanager." + this.Region + ".amazonaws.com";
                URL uRL = new URL("https://" + string9);
                HttpRequest httpRequest = new HttpRequest("POST", uRL.toURI());
                final String string10 = Signer.builder().awsCredentials(new AwsCredentials(string6, string7)).header("Host", string9).header("X-Amz-Target", "secretsmanager.GetSecretValue").header("Content-Type", "application/x-amz-json-1.1").header("X-Amz-Date", string3).region(this.Region).build(httpRequest, "secretsmanager", string5).getSignature();
                httpURLConnection = WebHelper.getHttpURLConnection(uRL, httpRequest.getMethod(), new WebRequestConfig(){

                    @Override
                    public void configure(HttpURLConnection httpURLConnection) throws IOException {
                        httpURLConnection.setRequestProperty("X-Amz-Target", "secretsmanager.GetSecretValue");
                        httpURLConnection.setRequestProperty("Content-Type", "application/x-amz-json-1.1");
                        httpURLConnection.setRequestProperty("X-Amz-Date", string3);
                        httpURLConnection.setRequestProperty("x-amz-security-token", string8);
                        httpURLConnection.setRequestProperty("Authorization", string10);
                        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(string4.length()));
                        httpURLConnection.getOutputStream().write(string4.getBytes());
                    }
                });
                WebHttpResponse webHttpResponse = WebHelper.readResponse(httpURLConnection);
                if (webHttpResponse.ReturnCode == 200) {
                    aWSSecretResponse = JsonUtilities.fromJson(webHttpResponse.Body, AWSSecretResponse.class);
                    string2 = JsonUtilities.getJsonMember(aWSSecretResponse.SecretString, string);
                    if (Util.isBlank(string2)) {
                        throw new Exception("Key not found");
                    }
                } else {
                    throw new Exception("HTTP Response code " + webHttpResponse.ReturnCode);
                }
                Util_Logger.info(logger, "Successfully extracted secret [" + string + "] from AWS Secrets Manager [" + this.Config.Name + "], value last updated " + Util.dateToStr(new Date(Double.valueOf(aWSSecretResponse.CreatedDate * 1000.0).longValue()), "dd/MM/yyyy HH:mm:ss"));
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Unable to extract AWS Secrets Manager secret [" + string + "]: " + exception.getMessage(), exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
        return string2;
    }
}

