/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbHandlerField;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbPreparedStatementParam;
import au.com.aemo.Common.Database.DbSpaceStats;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHandlerSnowFlake
extends DbHandler {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerSnowFlake.class);

    public DbHandlerSnowFlake(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        super(databaseConfig, string, string2);
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="SQL statement uses only variables from application properties configuration file and is therefore not vulnerable to SQL injection")
    public void afterConnect(Connection connection) throws SQLException {
        if (this.hasConfig()) {
            try (Statement statement = connection.createStatement();){
                if (!Util.isBlank(this.getDbDateFormat())) {
                    statement.execute("ALTER SESSION SET DATE_OUTPUT_FORMAT='" + this.getDbDateFormat() + "'");
                }
                if (this.getDefaultSchemaSQL() != null) {
                    statement.execute(this.getDefaultSchemaSQL());
                    Util_Logger.debug(logger, "Database session current schema set to " + this.getDefaultSchema());
                }
                statement.execute("ALTER SESSION SET JDBC_QUERY_RESULT_FORMAT='JSON'");
            }
        }
    }

    @Override
    public boolean getPreferExistsStatement() {
        return true;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Script parameters are driven by managed configuration and not user input. No significant risk of SQL injection")
    public Map<String, DbHandlerField> getColumnList(Connection connection, String string, String string2) throws ApplicationException {
        LinkedHashMap<String, DbHandlerField> linkedHashMap = new LinkedHashMap<String, DbHandlerField>();
        try (Statement statement = connection.createStatement();){
            String string3 = "SELECT UPPER(COLUMN_NAME) AS COLUMN_NAME,UPPER(DATA_TYPE) AS DATA_TYPE,NVL(CHARACTER_MAXIMUM_LENGTH,NUMERIC_PRECISION) AS DATA_LENGTH,NUMERIC_SCALE FROM " + this.getDbName(string) + "INFORMATION_SCHEMA.COLUMNS   WHERE UPPER(TABLE_NAME) = '" + string2.toUpperCase() + "'" + this.getInformationSchemaPredicate(null, string) + " ORDER BY ORDINAL_POSITION";
            try (ResultSet resultSet = statement.executeQuery(string3);){
                while (resultSet.next()) {
                    DbHandlerField dbHandlerField = new DbHandlerField(resultSet.getString(1), resultSet.getString(2), this.maptoFieldTypeId(resultSet.getString(2)), resultSet.getInt(3), resultSet.getInt(4), linkedHashMap.size());
                    linkedHashMap.put(dbHandlerField.getFieldName().toUpperCase(), dbHandlerField);
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected error in getColumnList: " + exception.getMessage(), exception);
        }
        return linkedHashMap;
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Return value not required for Snowflake PK inspection")
    public List<String> getPkList(Connection connection, String string, String string2) throws ApplicationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (Statement statement = connection.createStatement();){
            Object object = "DESCRIBE TABLE ";
            if (!Util.isBlank(string)) {
                object = (String)object + string;
                object = (String)object + ".";
            }
            object = (String)object + string2;
            statement.executeQuery((String)object);
            object = "SELECT \"name\" FROM TABLE(RESULT_SCAN(LAST_QUERY_ID())) WHERE \"kind\" = 'COLUMN' AND \"primary key\" ='Y'";
            try (ResultSet resultSet = statement.executeQuery((String)object);){
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected error in getPkList: " + exception.getMessage(), exception);
        }
        return arrayList;
    }

    @Override
    public long getSequence(Connection connection, String string, String string2) throws ApplicationException {
        long l = -1L;
        try (Statement statement = connection.createStatement();){
            String string3 = "select " + this.getTableReference(string, string2) + ".nextval from dual";
            try (ResultSet resultSet = statement.executeQuery(string3);){
                while (resultSet.next()) {
                    l = resultSet.getLong(1);
                }
            }
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Detected error in getSequence: " + sQLException.getMessage(), sQLException);
        }
        return l;
    }

    @Override
    public String getCurrentDateTime() {
        return "CURRENT_TIMESTAMP()";
    }

    @Override
    public String getCurrentUser() {
        return "CURRENT_USER()";
    }

    @Override
    public String getCurrentSchema() {
        return "CURRENT_SCHEMA()";
    }

    @Override
    public String getNoTable() {
        return "from dual";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbSpaceStats> getSpaceUsage() throws ApplicationException {
        ArrayList<DbSpaceStats> arrayList = new ArrayList<DbSpaceStats>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbManager.getDbConnection();
            statement = connection.createStatement();
            String string = "select\n     used.tablespace_name,\n     used.bytes as used_bytes,\n     reserv.maxbytes as max_bytes\nfrom\n    (select tablespace_name, count(1) datafiles, sum(greatest(maxbytes,bytes)) maxbytes, sum(bytes) bytes from dba_data_files group by tablespace_name) reserv,\n    (select tablespace_name, sum(bytes) bytes from dba_segments group by tablespace_name) used\n where used.tablespace_name = reserv.tablespace_name" + this.getTablespaceToReportSQL("and", "used.tablespace_name") + " order by 1";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                DbSpaceStats dbSpaceStats = new DbSpaceStats(resultSet.getString("tablespace_name"));
                dbSpaceStats.setUsedBytes(resultSet.getLong("used_bytes"));
                dbSpaceStats.setTotalBytes(resultSet.getLong("max_bytes"));
                arrayList.add(dbSpaceStats);
            }
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error extracting database space statistics: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        return arrayList;
    }

    @Override
    public String getSqlDate(Date date) {
        return this.getSqlDate(Util.dateToStr(date, this.getJavaDateFormat()));
    }

    @Override
    public String getSqlDate(String string) {
        return "to_timestamp('" + string + "','" + this.getDbDateFormat() + "')";
    }

    @Override
    public String concatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    @Override
    public String getDateFieldFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return this.getJavaDateFormat();
        }
        if (dbHandlerField.getFieldType().startsWith("TIMESTAMP")) {
            return this.getJavaTimestampFormat();
        }
        return null;
    }

    @Override
    public DbPreparedStatementParam getSqlPreparedStatementFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField == null) {
            return new DbPreparedStatementParam("?", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("NUMBER")) {
            return new DbPreparedStatementParam("to_number(?," + dbHandlerField.getDataLength() + "," + dbHandlerField.getDataScale() + ")", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATE")) {
            return new DbPreparedStatementParam("to_date(?,'" + this.getDbDateFormat() + "')", 12);
        }
        if (dbHandlerField.getFieldType().startsWith("TIMESTAMP")) {
            return new DbPreparedStatementParam("to_timestamp(?,'" + this.getDbTimestampFormat() + "')", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("CHAR")) {
            return new DbPreparedStatementParam(this.rightPad("?", dbHandlerField.getDataLength()), 12);
        }
        return new DbPreparedStatementParam("?", 12);
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Return value not required for database connectivity check")
    public boolean isValid(Connection connection) {
        boolean bl = false;
        if (connection != null) {
            try (Statement statement = connection.createStatement();){
                statement.executeQuery("select 1 from dual");
                bl = true;
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Error on SQL connection: " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    @Override
    public String ifNull(String string, String string2) {
        return "NVL(" + string + "," + string2 + ")";
    }

    private String rightPad(String string, int n) {
        return "RPAD(" + string + "," + n + ")";
    }

    @Override
    public String getSqlRowLimited(String string, String string2, int n) {
        return "SELECT TOP " + n + string + " ORDER BY " + string2;
    }

    @Override
    public String getBitOperator(String string, String string2) {
        return "bitand(" + string + "," + string2 + ")";
    }

    @Override
    public String getSqlDateRoundUp(String string, int n) {
        int n2 = 1440 / n;
        String string2 = "cast(" + string + " as DATE)";
        return "CEIL((" + string2 + " - trunc(" + string2 + ")) * " + n2 + " )/" + n2 + " + trunc(" + string2 + ")";
    }

    @Override
    public String getSqlDateDiffInSecs(String string, String string2) {
        return "DATEDIFF(millisecond," + string + "," + string2 + ")/1000";
    }

    @Override
    public String getSqlDateAdd(String string, String string2, int n) throws Exception {
        switch (n) {
            case 13: {
                return "TIMESTAMPADD(second, " + string2 + ", " + string + ")";
            }
            case 12: {
                return "TIMESTAMPADD(minute, " + string2 + ", " + string + ")";
            }
            case 11: {
                return "TIMESTAMPADD(hour, " + string2 + ", " + string + ")";
            }
            case 5: {
                return "TIMESTAMPADD(day, " + string2 + ", " + string + ")";
            }
        }
        throw new Exception("Unsupported operation getSqlDateAdd for Calendar field ID " + n);
    }

    @Override
    public String getScriptDelimiter() {
        return ";";
    }

    @Override
    public String getCodeBlockDeclare() {
        return "declare";
    }

    @Override
    public String getCodeBlockBegin() {
        return "begin";
    }

    @Override
    public String getCodeBlockEnd() {
        return "end;";
    }

    @Override
    public String getDefaultSchemaSQL() {
        String string = null;
        if (!Util.isBlank(this.getDefaultSchema())) {
            string = "ALTER SESSION SET CURRENT_SCHEMA=" + this.getDefaultSchema();
        }
        return string;
    }

    @Override
    public boolean isPrimaryKeyViolation(SQLException sQLException) {
        return false;
    }
}

