/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbHandlerSqlServer;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbSpaceStats;
import au.com.aemo.Common.Logging.Util_Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHandlerSqlServerAzure
extends DbHandlerSqlServer {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerSqlServerAzure.class);

    public DbHandlerSqlServerAzure(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        super(databaseConfig, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbSpaceStats> getSpaceUsage() throws ApplicationException {
        ArrayList<DbSpaceStats> arrayList = new ArrayList<DbSpaceStats>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbManager.getDbConnection();
            statement = connection.createStatement();
            String string = "SELECT\n\tdb_name() as database_name, t1.used_bytes, t2.max_bytes\nFROM\n\t(SELECT TOP 1 SUM(reserved_page_count) * 8192 as used_bytes FROM sys.dm_db_partition_stats) t1,\n\t(SELECT DATABASEPROPERTYEX(DB_NAME(), 'MaxSizeInBytes') as max_bytes) t2" + this.getTablespaceToReportSQL("where", "db_name()") + " order by db_name()";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                DbSpaceStats dbSpaceStats = new DbSpaceStats(resultSet.getString("database_name").toUpperCase());
                dbSpaceStats.setUsedBytes(resultSet.getLong("used_bytes"));
                dbSpaceStats.setTotalBytes(resultSet.getLong("max_bytes"));
                arrayList.add(dbSpaceStats);
            }
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error extracting database space statistics: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        return arrayList;
    }
}

