/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FTP;

import au.com.aemo.Common.FTP.FtpConnectionIntBase;
import au.com.aemo.Common.FTP.FtpException;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;
import com.enterprisedt.util.license.License;
import com.enterprisedt.util.proxy.ProxyType;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpConnectionIntEDT_FTPS
extends FtpConnectionIntBase
implements FTPMessageListener {
    private static Logger logger = LoggerFactory.getLogger(FtpConnectionIntEDT_FTPS.class);
    private SSLFTPClient itsFtp;
    private static boolean licenceDetailsAdded = false;

    public void logCommand(String string) {
        Util_Logger.debug(logger, "FTP COMMAND [" + this.getId() + "] - " + string);
    }

    public void logReply(String string) {
        Util_Logger.debug(logger, "FTP REPLY [" + this.getId() + "] - " + string);
    }

    private static synchronized void setLicenceDetails() {
        if (!licenceDetailsAdded) {
            License.setLicenseDetails((String)"AEMO.com.au", (String)"382-2681-9839-9862");
            licenceDetailsAdded = true;
            Util_Logger.debug(logger, "Registered licence details for EnterpriseDT FTP component");
        }
    }

    @Override
    public String toString() {
        return this.getId();
    }

    @Override
    public void connect(String string, Integer n, String string2, String string3, String string4, String string5, String string6, int n2, String string7, String string8, String string9, boolean bl, boolean bl2, String string10, String string11, String string12, boolean bl3) throws Exception {
        FtpConnectionIntEDT_FTPS.setLicenceDetails();
        this.setId(string8);
        this.setExtractLastModifiedDate(bl);
        this.itsFtp = new SSLFTPClient();
        this.itsFtp.setRemoteHost(string);
        if (n != null) {
            this.itsFtp.setRemotePort(n.intValue());
        }
        this.itsFtp.setImplicitFTPS(bl3);
        this.itsFtp.setValidateServer(bl2);
        if (!Util.isBlank(string12)) {
            this.itsFtp.getRootCertificateStore().importPEMFile(string12);
        }
        if (!Util.isBlank(string5)) {
            this.itsFtp.getProxySettings().setProxyAddress(string5);
            this.itsFtp.getProxySettings().setProxyPort(Integer.parseInt(string6));
            this.itsFtp.getProxySettings().setProxyType(ProxyType.HTTP);
        }
        this.itsFtp.connect();
        if (string7.equalsIgnoreCase("active")) {
            this.itsFtp.setConnectMode(FTPConnectMode.ACTIVE);
        } else if (string7.equalsIgnoreCase("passive")) {
            this.itsFtp.setConnectMode(FTPConnectMode.PASV);
        } else {
            throw new Exception("Unknown FTP connect mode " + string7);
        }
        if (logger.isDebugEnabled()) {
            this.itsFtp.setMessageListener((FTPMessageListener)this);
        }
        if (bl3) {
            try {
                this.itsFtp.auth('P');
            }
            catch (FTPException fTPException) {}
        } else {
            this.itsFtp.auth("TLS");
        }
        this.itsFtp.setTimeout(n2 * 1000);
        this.itsFtp.setId(string9);
        this.itsFtp.login(string2, string3);
    }

    @Override
    public void disconnect() throws FtpException, IOException {
        try {
            this.itsFtp.quit();
        }
        catch (FTPException fTPException) {
            throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
        }
    }

    @Override
    public boolean isConnected() {
        boolean bl = false;
        try {
            Util_Logger.debug(logger, "Testing FTP connection " + this.itsFtp.toString());
            this.itsFtp.keepAlive();
            bl = this.itsFtp.connected();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public void setBandwidthThrottle(int n) {
        this.itsFtp.setMaxTransferRate(n);
    }

    @Override
    public void resetBandwidthThrottle() {
        this.itsFtp.setMaxTransferRate(-1);
    }

    @Override
    public void setTransferBufferSize(int n) {
        this.itsFtp.setTransferBufferSize(n);
    }

    @Override
    public void chdirImp(String string) throws FtpException, IOException {
        try {
            this.itsFtp.chdir(string);
        }
        catch (FTPException fTPException) {
            throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
        }
    }

    @Override
    public void mkdir(String string) throws FtpException, IOException {
        try {
            this.itsFtp.mkdir(string);
        }
        catch (FTPException fTPException) {
            throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
        }
    }

    @Override
    public void setType(String string) throws FtpException, IOException {
        try {
            if (!string.equalsIgnoreCase("binary")) {
                throw new FtpException("Unknown FTP transfer mode " + string);
            }
            this.itsFtp.setType(FTPTransferType.BINARY);
        }
        catch (FTPException fTPException) {
            throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
        }
    }

    @Override
    public void put(String string, String string2) throws FtpException, IOException {
        try {
            this.itsFtp.put(string, string2);
        }
        catch (FTPException fTPException) {
            throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
        }
    }

    @Override
    public fsFileInfo[] dir(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2) throws FtpException, IOException, ParseException {
        fsFileInfo[] fsFileInfoArray;
        block10: {
            fsFileInfoArray = null;
            try {
                FTPFile[] fTPFileArray;
                Object object = string;
                if (fsConnectionFileFilterInt2 != null && !Util.isBlank(fsConnectionFileFilterInt2.getServerDirectoryListingFileMask())) {
                    object = (String)object + "/" + fsConnectionFileFilterInt2.getServerDirectoryListingFileMask();
                }
                if ((fTPFileArray = this.itsFtp.dirDetails((String)object)) == null) break block10;
                ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
                for (int i = 0; i < fTPFileArray.length; ++i) {
                    boolean bl = true;
                    fsFileInfo fsFileInfo2 = new fsFileInfo();
                    fsFileInfo2.setDirectory(string);
                    fsFileInfo2.setFilename(fTPFileArray[i].getName());
                    fsFileInfo2.setSize(fTPFileArray[i].size());
                    fsFileInfo2.setModifiedDate(fTPFileArray[i].lastModified(), false);
                    if (fTPFileArray[i].isDir()) {
                        fsFileInfo2.setFileType(fsFileTypeEnum.DIRECTORY);
                    } else {
                        fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
                        if (this.getExtractLastModifiedDate()) {
                            try {
                                Date date = this.itsFtp.modtime(string + "/" + fTPFileArray[i].getName());
                                fsFileInfo2.setModifiedDate(date, true);
                            }
                            catch (FTPException fTPException) {
                                if (fTPException.getReplyCode() != 550) {
                                    throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
                                }
                                bl = false;
                            }
                        }
                    }
                    if (!bl) continue;
                    arrayList.add(fsFileInfo2);
                }
                fsFileInfoArray = arrayList.toArray(new fsFileInfo[0]);
            }
            catch (FTPException fTPException) {
                throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
            }
        }
        return fsFileInfoArray;
    }

    @Override
    public void delete(String string) throws FtpException, IOException {
        try {
            this.itsFtp.delete(string);
        }
        catch (FTPException fTPException) {
            throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
        }
    }

    @Override
    public void get(String string, String string2) throws FtpException, IOException {
        try {
            this.itsFtp.get(string, string2);
        }
        catch (FTPException fTPException) {
            throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
        }
    }

    @Override
    public boolean exists(String string, String string2) throws FtpException, IOException {
        try {
            this.itsFtp.chdir(string);
            return this.itsFtp.existsFile(string2);
        }
        catch (FTPException fTPException) {
            throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
        }
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws FtpException, IOException {
        boolean bl;
        block3: {
            bl = false;
            try {
                this.itsFtp.chdir(fsFileInfo2.getDirectory());
                Date date = this.itsFtp.modtime(fsFileInfo2.getFilename());
                if (date != null) {
                    fsFileInfo2.setModifiedDate(date, true);
                    bl = true;
                }
            }
            catch (FTPException fTPException) {
                if (fTPException.getReplyCode() == 550) break block3;
                throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
            }
        }
        return bl;
    }

    @Override
    public void rename(String string, String string2) throws FtpException, IOException {
        try {
            this.itsFtp.rename(string, string2);
        }
        catch (FTPException fTPException) {
            throw new FtpException((Exception)((Object)fTPException), fTPException.getReplyCode());
        }
    }
}

