/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.AMQP.AMQPUtilities;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionBase;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsConnectionLocal;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.FileSystem.fsFileLockNone;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionAMQP
extends fsConnectionBase {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionAMQP.class);
    private Channel itsChannel;
    private String itsDataSourceId;
    private Integer itsPrefetchCount;
    private fsConnectionLocal itsLocal;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public fsConnectionAMQP(Channel channel, String string, Integer n) {
        super(string);
        this.itsChannel = channel;
        this.itsDataSourceId = string;
        this.itsPrefetchCount = n;
        this.itsLocal = new fsConnectionLocal(string, false);
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    protected Channel getChannel() {
        return this.itsChannel;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return false;
    }

    @Override
    public boolean supportsFileMasks() {
        return false;
    }

    @Override
    public fsFileInfo resolveFilenameSpec(String string) throws Exception {
        fsFileInfo fsFileInfo2 = new fsFileInfo();
        int n = string.lastIndexOf("/");
        if (n < 0) {
            throw new Exception("Missing folder specification (/) in filename [" + string + "]");
        }
        fsFileInfo2.setDirectory(string.substring(0, n));
        fsFileInfo2.setFilename(string.substring(n + 1));
        return fsFileInfo2;
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("makeDir operation not supported in AMQP connector");
    }

    @Override
    public void changeDir(String string) throws Exception {
    }

    private fsFileInfo eventToFile(fsEventData fsEventData2, String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2) throws Exception {
        Object object = null;
        if (fsConnectionFileFilterInt2 != null) {
            object = fsConnectionFileFilterInt2.getOutputFilenameMask();
        }
        if (Util.isBlank(object)) {
            object = "AMQP_" + this.getDataSourceId() + "_" + fsEventData2.getEventId() + ".json";
        }
        fsFileInfo fsFileInfo2 = new fsFileInfo();
        fsFileInfo2.setDirectory(string);
        fsFileInfo2.setSize(Long.valueOf(fsEventData2.getEventData().toString().length()));
        fsFileInfo2.setEventData(fsEventData2);
        if (fsConnectionFileFilterInt2 != null) {
            fsFileInfo2.addAPIHeaderValues(fsConnectionFileFilterInt2.getAPIHeaderValues());
        }
        fsFileInfo2.setUniqueId(this.getDataSourceId() + "_" + fsEventData2.getEventId());
        String string2 = FileNameTokenResolver.process((String)object, fsFileInfo2);
        fsFileInfo2.setFilename(string2);
        return fsFileInfo2;
    }

    @Override
    public Map<String, fsFileInfo> listFiles(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        try {
            if (!Util.isBlank(string2)) {
                List<fsEventData> list = FilesystemManager.getInstance().getNewFileEvents(string2);
                Util_Logger.debug(logger, "Detected " + list.size() + " events");
                for (fsEventData fsEventData2 : list) {
                    if (fsEventData2.isCompleted()) continue;
                    fsFileInfo fsFileInfo2 = this.eventToFile(fsEventData2, string, fsConnectionFileFilterInt2);
                    hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
                }
            } else {
                GetResponse getResponse;
                int n = this.itsPrefetchCount == null ? Integer.MAX_VALUE : this.itsPrefetchCount;
                String string3 = string;
                for (int i = 0; i < n && (getResponse = this.itsChannel.basicGet(string3, false)) != null; ++i) {
                    Envelope envelope = getResponse.getEnvelope();
                    AMQP.BasicProperties basicProperties = getResponse.getProps();
                    long l = envelope.getDeliveryTag();
                    Util_Logger.debug(logger, "Received new message [" + l + "] from AMQP queue [" + string3 + "]");
                    fsEventData fsEventData3 = AMQPUtilities.messageToEvent(this.getDataSourceId(), string3, this.itsChannel, envelope, basicProperties, getResponse.getBody());
                    fsFileInfo fsFileInfo3 = this.eventToFile(fsEventData3, string3, fsConnectionFileFilterInt2);
                    hashMap.put(fsFileInfo3.getFilename(), fsFileInfo3);
                }
            }
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error listing new content from AMQP events: " + exception.getMessage(), exception);
        }
        return hashMap;
    }

    @Override
    public fsFileInfo getFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        fsEventData fsEventData2 = fsFileInfo2.getEventData();
        File file = new File(string + "/" + fsFileInfo2.getFilename());
        try (Object object = new FileOutputStream(file);){
            ((FileOutputStream)object).write(fsEventData2.getEventData().toString().getBytes());
            ((OutputStream)object).flush();
        }
        object = new fsFileInfo(file);
        return object;
    }

    @Override
    public void writeData(String string, String string2, byte[] byArray, Date date, fsFileLockInt fsFileLockInt2) throws Exception {
        throw new Exception("WriteData operation not supported in AMQP connector");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public fsProcessStatus putFile(fsFileInfo fsFileInfo2, String string, boolean bl, String string2) throws Exception {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        File file = null;
        try {
            void var10_16;
            byte[] byArray = Files.readAllBytes(Paths.get(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename()));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (fsFileInfo2.getAPIHeaderValues() != null) {
                for (Map.Entry<String, String> object2 : fsFileInfo2.getAPIHeaderValues().entrySet()) {
                    hashMap.put(object2.getKey(), object2.getValue());
                }
            }
            AMQP.BasicProperties basicProperties = new AMQP.BasicProperties.Builder().timestamp(new Date()).messageId(UUID.randomUUID().toString()).headers(hashMap).build();
            String string3 = "";
            String string4 = "";
            String[] stringArray = Util.getColumns(string, ':');
            if (stringArray.length == 1) {
                String string5 = stringArray[0];
            } else {
                String string6 = Util.noNull(stringArray[0]);
                string4 = Util.noNull(stringArray[1]);
            }
            this.itsChannel.basicPublish((String)var10_16, string4, basicProperties, byArray);
            fsProcessStatus2.setProcessSuccess();
            if (bl) {
                FileUtilities.deleteFile(fsFileInfo2);
            }
        }
        catch (Exception exception) {
            try {
                FileUtilities.deleteFile(file);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error publishing " + fsFileInfo2.getFilename() + " to AMQP: " + exception.getMessage(), exception);
        }
        return fsProcessStatus2;
    }

    @Override
    public void deleteFile(fsFileInfo fsFileInfo2) throws Exception {
        if (fsFileInfo2.getEventData() != null) {
            if (fsFileInfo2.getEventData().getEventSourceChannel() == null) {
                throw new Exception("Delete operation not supported in AMQP connector without event source channel");
            }
        } else {
            throw new Exception("Delete operation not supported in AMQP connector without event data");
        }
        Channel channel = (Channel)fsFileInfo2.getEventData().getEventSourceChannel();
        channel.basicAck(Long.parseLong(fsFileInfo2.getEventData().getNotificationId()), false);
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        throw new Exception("Delete operation with folder and filename specification not supported in AMQP connector");
    }

    @Override
    public void setBandwidthThrottle(int n) {
    }

    @Override
    public void setTransferBufferSize(int n) {
    }

    @Override
    public void disconnect() throws Exception {
        throw new Exception("Disconnect operation not supported in AMQP connector");
    }

    @Override
    public boolean exists(String string, String string2) throws Exception {
        throw new Exception("Exists operation not supported in AMQP connector");
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws Exception {
        return true;
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("Rename file operation not supported in AMQP connector");
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public fsFileLockInt lockFile(fsFileInfo fsFileInfo2) {
        return new fsFileLockNone();
    }
}

