/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsConnectionLocal;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebContent;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class fsConnectionBase
implements fsConnectionInt {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionBase.class);
    private String itsDataSourceId;
    private fsConnectionLocal itsLocal;

    public fsConnectionBase(String string) {
        this.itsDataSourceId = string;
        this.itsLocal = new fsConnectionLocal(string, false);
    }

    @Override
    public fsProcessStatus putFile(fsFileInfo fsFileInfo2, String string, boolean bl, String string2) throws Exception {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        try {
            byte[] byArray = Files.readAllBytes(Paths.get(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename()));
            this.writeData(string, fsFileInfo2.getFilename(), byArray, fsFileInfo2.getModifiedDate(), null);
            if (bl) {
                this.itsLocal.deleteFile(fsFileInfo2);
            }
            fsProcessStatus2.setProcessSuccess();
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error putting file " + fsFileInfo2.getFilename() + " to storage: " + exception.getMessage(), exception);
        }
        return fsProcessStatus2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readData(fsFileInfo fsFileInfo2) throws Exception {
        byte[] byArray = null;
        Path path = null;
        try {
            String string = System.getProperty("java.io.tmpdir");
            this.getFile(fsFileInfo2, string);
            path = Paths.get(string, fsFileInfo2.getFilename());
            byArray = Files.readAllBytes(path);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error reading file " + fsFileInfo2.getFilename() + ": " + exception.getMessage(), exception);
        }
        finally {
            if (path != null) {
                FileUtilities.deleteFile(path.toString());
            }
        }
        return byArray;
    }

    @Override
    public void releaseFileLock(fsFileInfo fsFileInfo2) {
        fsFileInfo2.releaseLock();
    }

    @Override
    public void deleteFile(fsFileInfo fsFileInfo2) throws Exception {
        this.deleteFile(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
    }

    protected fsFileInfo writeAckFile(fsFileInfo fsFileInfo2, String string, String string2) throws ApplicationException {
        fsFileInfo fsFileInfo3 = null;
        if (!Util.isBlank(string2)) {
            try {
                File file = new File(string + "/" + fsFileInfo2.getName() + "_RESPONSE." + fsFileInfo2.getExtension());
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    fileOutputStream.write(string2.getBytes());
                    fileOutputStream.flush();
                }
                fsFileInfo3 = new fsFileInfo(file);
                fsFileInfo3.setEventData(fsFileInfo2.getEventData());
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error writing acknowledgement response for submission of " + fsFileInfo2.getFilename() + ": " + exception.getMessage(), exception);
            }
        }
        return fsFileInfo3;
    }

    public WebContent.MediaType getMediaType(String string) throws Exception {
        WebContent.MediaType mediaType;
        if (string.toLowerCase().endsWith(".xml")) {
            mediaType = WebContent.MediaType.TEXT_XML;
        } else if (string.toLowerCase().endsWith(".json")) {
            mediaType = WebContent.MediaType.APPLICATION_JSON;
        } else if (string.toLowerCase().endsWith(".csv")) {
            mediaType = WebContent.MediaType.TEXT_CSV;
        } else if (string.toLowerCase().endsWith(".txt")) {
            mediaType = WebContent.MediaType.TEXT_PLAIN;
        } else {
            throw new Exception("Unsupported media type in source " + string);
        }
        return mediaType;
    }
}

