/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.AMQP.AMQPUtilities;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsEventNotificationAMQP;
import au.com.aemo.Common.Logging.Util_Logger;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsEventNotificationAMQPProcessor
extends DefaultConsumer {
    public static final String JSON_EVENT_TRANSFORM_ID = "amqp_event_transform";
    private static Logger logger = LoggerFactory.getLogger(fsEventNotificationAMQP.class);
    private fsEventNotificationAMQP itsEventHandler;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public fsEventNotificationAMQPProcessor(fsEventNotificationAMQP fsEventNotificationAMQP2) {
        super(fsEventNotificationAMQP2.getChannel());
        this.itsEventHandler = fsEventNotificationAMQP2;
    }

    public void handleDelivery(String string, Envelope envelope, AMQP.BasicProperties basicProperties, byte[] byArray) {
        try {
            String string2 = this.itsEventHandler.getQueueName();
            Util_Logger.info(logger, "Received new message [" + basicProperties.getMessageId() + "] from AMQP queue [" + string2 + "]");
            fsEventData fsEventData2 = AMQPUtilities.messageToEvent(this.itsEventHandler.getDataSourceId(), string2, this.itsEventHandler.getChannel(), envelope, basicProperties, byArray);
            this.itsEventHandler.addNewFileEvent(fsEventData2);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error processing new AMQP event: " + exception.getMessage(), exception);
        }
    }
}

