/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Files;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Files.FileMaskSpecification;
import au.com.aemo.Common.Files.FilePurgeThreadRec;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePurgeThread
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(FilePurgeThread.class);
    private boolean itsIsRunning;
    private int itsDelayMins;
    private FilePurgeThreadRec[] itsPurgeRecs;

    public FilePurgeThread(Properties properties) throws ApplicationException {
        boolean bl = true;
        String string = Util.getProperty(properties, "file_purge_configurations", "");
        if (!Util.isBlank(string)) {
            String[] stringArray = Util.getColumns(string, ',');
            this.itsPurgeRecs = new FilePurgeThreadRec[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                try {
                    FilePurgeThreadRec filePurgeThreadRec;
                    Util_Logger.info(logger, "Adding automated filesystem purging configuration " + string2);
                    String string3 = Util.getProperty(properties, "file_purge_" + string2 + "_directory");
                    int n = Integer.parseInt(Util.getProperty(properties, "file_purge_" + string2 + "_retention_time_mins", "-1"));
                    int n2 = Integer.parseInt(Util.getProperty(properties, "file_purge_" + string2 + "_max_no_files", "-1"));
                    int n3 = Integer.parseInt(Util.getProperty(properties, "file_purge_" + string2 + "_max_size_MB", "-1"));
                    int n4 = Integer.parseInt(Util.getProperty(properties, "file_purge_" + string2 + "_purge_frequency_mins", "1440"));
                    FileMaskSpecification fileMaskSpecification = new FileMaskSpecification();
                    fileMaskSpecification.setIncludeFileMask(Util.getProperty(properties, "file_purge_" + string2 + "_inc", null));
                    fileMaskSpecification.setExcludeFileMask(Util.getProperty(properties, "file_purge_" + string2 + "_exc", null));
                    fileMaskSpecification.setFileMaskMode(Util.getProperty(properties, "file_purge_" + string2 + "_mask_mode", "EXCLUSIVE"));
                    this.itsPurgeRecs[i] = filePurgeThreadRec = new FilePurgeThreadRec(string3, n, n2, n3, n4, fileMaskSpecification);
                    continue;
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Detected configuration error in purge thread " + string2 + ": " + exception.getMessage(), exception);
                    bl = false;
                }
            }
        }
        if (!bl) {
            Util_Logger.warning(logger, "Detected invalid filesystem purge check configuration. Invalid checks will be skipped");
        }
        this.itsIsRunning = true;
    }

    public boolean getHasConfiguration() {
        return this.itsPurgeRecs != null;
    }

    public void stop() {
        this.itsIsRunning = false;
    }

    @Override
    public void run() {
        while (this.itsIsRunning) {
            try {
                if (this.itsPurgeRecs != null) {
                    for (int i = 0; i < this.itsPurgeRecs.length; ++i) {
                        if (this.itsPurgeRecs[i] != null) {
                            this.itsPurgeRecs[i].runCheck();
                            continue;
                        }
                        Util_Logger.warning(logger, "Skipping filesystem purge check [" + i + "] due to invalid configuration");
                    }
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Detected exception in filesystem purge thread: " + exception.getMessage(), exception);
            }
            try {
                Util_Logger.debug(logger, "Sleeping for 2 mins in filesystem purge thread");
                Thread.sleep(120000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

