/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Files;

import au.com.aemo.Common.Files.FileComparator;
import au.com.aemo.Common.Files.FileMaskSpecification;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilePurgeThreadRec
implements FilenameFilter {
    private static Logger logger = LoggerFactory.getLogger(FilePurgeThreadRec.class);
    private String itsDirectory;
    private int itsRententionMins;
    private int itsMaxNoFiles;
    private long itsMaxSizeMB;
    private int itsPurgeFrequencyMins;
    private FileMaskSpecification itsFileMaskSpec;
    private Date itsLastRun;
    private Date itsLastRunPurgeDate;
    private Date itsNextRun;

    public FilePurgeThreadRec(String string, int n, int n2, int n3, int n4, FileMaskSpecification fileMaskSpecification) {
        this.itsDirectory = string;
        this.itsRententionMins = n;
        this.itsMaxNoFiles = n2;
        this.itsMaxSizeMB = n3;
        this.itsPurgeFrequencyMins = n4;
        this.itsFileMaskSpec = fileMaskSpecification;
    }

    @Override
    public boolean accept(File file, String string) {
        File file2 = new File(file.getPath() + File.separator + string);
        boolean bl = file2.isFile();
        if (bl) {
            boolean bl2 = bl = this.itsRententionMins > 0 || this.itsMaxNoFiles > 0 || this.itsMaxSizeMB > 0L;
        }
        if (bl) {
            bl = this.itsFileMaskSpec.checkFileMask(string);
        }
        return bl;
    }

    private boolean runAgain(Date date) {
        if (this.itsNextRun == null) {
            return true;
        }
        return date.after(this.itsNextRun);
    }

    private void doPurge() {
        File file = new File(this.itsDirectory);
        File[] fileArray = file.listFiles(this);
        if (fileArray != null) {
            Arrays.sort(fileArray, FileComparator.getComparator("NEWEST"));
            int n = 0;
            long l = 0L;
            for (int i = 0; i < fileArray.length; ++i) {
                long l2;
                boolean bl = false;
                if (this.itsRententionMins > 0) {
                    boolean bl2 = bl = fileArray[i].lastModified() < this.itsLastRunPurgeDate.getTime();
                }
                if (this.itsMaxNoFiles > 0 && i >= this.itsMaxNoFiles) {
                    bl = true;
                }
                if (this.itsMaxSizeMB > 0L && (l += (l2 = fileArray[i].length())) > this.itsMaxSizeMB * 1024L * 1024L) {
                    bl = true;
                }
                if (!bl) continue;
                if (fileArray[i].delete()) {
                    Util_Logger.debug(logger, "Purged file " + fileArray[i].getPath());
                    ++n;
                    continue;
                }
                Util_Logger.warning(logger, "Error purging file " + fileArray[i].getName());
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.itsRententionMins > 0) {
                stringBuffer.append(" with last modified date < " + Util.dateToStr(this.itsLastRunPurgeDate, "dd-MM-yyyy HH:mm:ss"));
            }
            if (this.itsMaxNoFiles > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" and");
                }
                stringBuffer.append(" leaving only the " + this.itsMaxNoFiles + " most recent files");
            }
            if (this.itsMaxSizeMB > 0L) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" and");
                }
                stringBuffer.append(" removing the oldest files to limit total size to a maximum of " + this.itsMaxSizeMB + "MB");
            }
            Util_Logger.info(logger, "Purged " + n + " files from directory " + this.itsDirectory + stringBuffer.toString());
        }
    }

    public void runCheck() {
        Date date = new Date();
        if (this.runAgain(date)) {
            this.itsLastRunPurgeDate = Util.dateOffset(date, -this.itsRententionMins, 12);
            this.doPurge();
            this.itsLastRun = new Date();
            this.itsNextRun = Util.dateOffset(this.itsLastRun, this.itsPurgeFrequencyMins, 12);
        }
    }
}

