/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Files;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Files.FilesystemMonitorAlert;
import au.com.aemo.Common.Files.FilesystemMonitorConfig;
import au.com.aemo.Common.Files.FilesystemStatus;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.File;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemMonitor {
    private static Logger logger = LoggerFactory.getLogger(FilesystemMonitor.class);
    private FilesystemMonitorConfig Config;

    private FilesystemMonitor() {
    }

    public static FilesystemMonitor getInstance() {
        return SingletonHolder.instance;
    }

    public void configure(FilesystemMonitorConfig filesystemMonitorConfig) {
        if (filesystemMonitorConfig != null && filesystemMonitorConfig.Filesystem != null) {
            ArrayList<FilesystemMonitorAlert> arrayList = new ArrayList<FilesystemMonitorAlert>();
            for (FilesystemMonitorAlert filesystemMonitorAlert : filesystemMonitorConfig.Filesystem) {
                if (new File(filesystemMonitorAlert.Path).exists()) {
                    arrayList.add(filesystemMonitorAlert);
                    continue;
                }
                Util_Logger.warning(logger, "Ignoring file system monitoring for invalid path " + filesystemMonitorAlert.Path);
            }
            filesystemMonitorConfig.Filesystem = arrayList;
            if (filesystemMonitorConfig.Filesystem.size() > 0) {
                this.Config = filesystemMonitorConfig;
                Util_Logger.info(logger, "Loaded " + this.Config.Filesystem.size() + " filesystem monitoring configurations");
            }
        }
    }

    public static FilesystemMonitorConfig loadConfigFromProperties(Properties properties) throws ApplicationException {
        String[] stringArray;
        FilesystemMonitorConfig filesystemMonitorConfig = new FilesystemMonitorConfig();
        String string = Util.getProperty(properties, "filesystem_monitor_configurations", null);
        if (!Util.isBlank(string) && (stringArray = Util.getColumns(string, ',')) != null) {
            for (String string2 : stringArray) {
                String string3;
                String string4;
                if (Util.isBlank(string2)) continue;
                FilesystemMonitorAlert filesystemMonitorAlert = new FilesystemMonitorAlert();
                filesystemMonitorAlert.Path = Util.getProperty(properties, "filesystem_monitor_" + string2 + "_path", null);
                String string5 = Util.getProperty(properties, "filesystem_monitor_" + string2 + "_warning_pct", null);
                if (Util.isInteger(string5)) {
                    filesystemMonitorAlert.WarningPct = Integer.valueOf(string5);
                }
                if (Util.isInteger(string4 = Util.getProperty(properties, "filesystem_monitor_" + string2 + "_alert_pct", null))) {
                    filesystemMonitorAlert.AlertPct = Integer.valueOf(string4);
                }
                if (Util.isInteger(string3 = Util.getProperty(properties, "filesystem_monitor_" + string2 + "_check_interval_minutes", null))) {
                    filesystemMonitorAlert.CheckIntervalMinutes = Integer.valueOf(string3);
                }
                filesystemMonitorConfig.Filesystem.add(filesystemMonitorAlert);
            }
        }
        return filesystemMonitorConfig;
    }

    private FilesystemStatus getStatus(FilesystemMonitorAlert filesystemMonitorAlert) {
        FilesystemStatus filesystemStatus = null;
        try {
            URI uRI = new URI("file:///");
            Path path = Paths.get(uRI);
            Path path2 = path.resolve(filesystemMonitorAlert.Path);
            FileStore fileStore = Files.getFileStore(path2);
            long l = fileStore.getTotalSpace();
            long l2 = fileStore.getTotalSpace() - fileStore.getUnallocatedSpace();
            long l3 = fileStore.getUsableSpace();
            filesystemStatus = new FilesystemStatus(filesystemMonitorAlert.Path, fileStore.name());
            filesystemStatus.setTotalBytes(l);
            filesystemStatus.setUsedBytes(l2);
            filesystemStatus.setAvailBytes(l3);
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Unable to check filesystem at " + filesystemMonitorAlert.Path + ": " + exception.getMessage(), exception);
            filesystemStatus = null;
        }
        return filesystemStatus;
    }

    public List<FilesystemStatus> getStatus() {
        ArrayList<FilesystemStatus> arrayList = new ArrayList<FilesystemStatus>();
        if (this.Config != null) {
            for (FilesystemMonitorAlert filesystemMonitorAlert : this.Config.Filesystem) {
                FilesystemStatus filesystemStatus = this.getStatus(filesystemMonitorAlert);
                if (filesystemStatus == null) continue;
                arrayList.add(filesystemStatus);
            }
        }
        return arrayList;
    }

    public void doCheck() {
        if (this.Config != null) {
            for (FilesystemMonitorAlert filesystemMonitorAlert : this.Config.Filesystem) {
                Object object;
                boolean bl = false;
                if (filesystemMonitorAlert.LastChecked == null) {
                    bl = true;
                } else {
                    object = Util.dateOffset(new Date(), -filesystemMonitorAlert.CheckIntervalMinutes.intValue(), 12);
                    if (filesystemMonitorAlert.LastChecked.before((Date)object)) {
                        bl = true;
                    }
                }
                if (!bl || (object = this.getStatus(filesystemMonitorAlert)) == null) continue;
                boolean bl2 = false;
                if (filesystemMonitorAlert.AlertPct != null && ((FilesystemStatus)object).getPercentFull() * 100.0 > (double)filesystemMonitorAlert.AlertPct.intValue()) {
                    bl2 = true;
                }
                boolean bl3 = false;
                if (filesystemMonitorAlert.WarningPct != null && ((FilesystemStatus)object).getPercentFull() * 100.0 > (double)filesystemMonitorAlert.WarningPct.intValue()) {
                    bl3 = true;
                }
                String string = ((FilesystemStatus)object).getDisplayName();
                String string2 = Util.formatBytes(((FilesystemStatus)object).getUsedBytes());
                String string3 = Util.formatBytes(((FilesystemStatus)object).getTotalBytes());
                String string4 = String.format("%.1f%s", ((FilesystemStatus)object).getPercentFull() * 100.0, "%");
                String string5 = String.format("%d%s", filesystemMonitorAlert.WarningPct, "%");
                String string6 = String.format("%d%s", filesystemMonitorAlert.AlertPct, "%");
                if (bl2) {
                    Util_Logger.errorNoRaise(logger, "Filesystem [" + string + "] Used space above " + string6 + " threshold: Used=" + string2 + ", Total=" + string3 + ", UsedPct=" + string4);
                } else if (bl3) {
                    Util_Logger.warning(logger, "Filesystem [" + string + "] Used space above " + string5 + " threshold: Used=" + string2 + ", Total=" + string3 + ", UsedPct=" + string4);
                } else {
                    Util_Logger.info(logger, "Filesystem [" + string + "] Used=" + string2 + ", Total=" + string3 + ", FreePct=" + string4);
                }
                filesystemMonitorAlert.LastChecked = new Date();
            }
        }
    }

    private static class SingletonHolder {
        private static FilesystemMonitor instance = new FilesystemMonitor();

        private SingletonHolder() {
        }
    }
}

