/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Java;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Java.propertiesFileEntry;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class propertiesFileUpdater {
    private static Logger logger = LoggerFactory.getLogger(propertiesFileUpdater.class);

    private void processProperty(propertiesFileEntry propertiesFileEntry2, List<propertiesFileEntry> list, PrintWriter printWriter) throws Exception {
        if (!propertiesFileEntry2.FoundEntry) {
            if (Util.isBlank(propertiesFileEntry2.Value)) {
                printWriter.println("# " + propertiesFileEntry2.Name);
            } else {
                printWriter.println(propertiesFileEntry2.Name + "=" + propertiesFileEntry2.Value);
            }
            propertiesFileEntry2.FoundEntry = true;
            for (propertiesFileEntry propertiesFileEntry3 : list) {
                if (Util.isBlank(propertiesFileEntry3.InsertAfter) || !propertiesFileEntry2.Name.trim().equalsIgnoreCase(propertiesFileEntry3.InsertAfter)) continue;
                this.processProperty(propertiesFileEntry3, list, printWriter);
                break;
            }
        }
    }

    private void processLine(String string, List<propertiesFileEntry> list, PrintWriter printWriter) throws Exception {
        String[] stringArray = string.split("=");
        String string2 = stringArray[0];
        boolean bl = false;
        for (propertiesFileEntry propertiesFileEntry2 : list) {
            if (!string2.trim().equalsIgnoreCase(propertiesFileEntry2.Name)) continue;
            this.processProperty(propertiesFileEntry2, list, printWriter);
            bl = true;
            break;
        }
        if (!bl) {
            printWriter.println(string);
        }
        for (propertiesFileEntry propertiesFileEntry2 : list) {
            if (Util.isBlank(propertiesFileEntry2.InsertAfter) || !string2.trim().equalsIgnoreCase(propertiesFileEntry2.InsertAfter)) continue;
            this.processProperty(propertiesFileEntry2, list, printWriter);
            break;
        }
    }

    protected void processFile(String string, List<propertiesFileEntry> list) throws Exception {
        String string2 = string + ".tmp";
        try {
            try (FileReader fileReader = new FileReader(string);
                 BufferedReader bufferedReader = new BufferedReader(fileReader);
                 FileWriter fileWriter = new FileWriter(string2);
                 PrintWriter printWriter = new PrintWriter(fileWriter);){
                Object object;
                while ((object = bufferedReader.readLine()) != null) {
                    this.processLine((String)object, list, printWriter);
                }
                for (propertiesFileEntry propertiesFileEntry2 : list) {
                    if (propertiesFileEntry2.FoundEntry) continue;
                    throw new Exception("Detected missing property [" + propertiesFileEntry2.Name + "] in " + string);
                }
            }
            FileUtilities.renameFile(string2, string);
        }
        catch (Exception exception) {
            try {
                FileUtilities.deleteFile(string2);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    public void run(String string, List<propertiesFileEntry> list) throws ApplicationException {
        try {
            if (list != null) {
                for (propertiesFileEntry propertiesFileEntry2 : list) {
                    if (!string.toLowerCase().endsWith(".properties") || propertiesFileEntry2.Value == null) continue;
                    propertiesFileEntry2.Value = propertiesFileEntry2.Value.replace('\\', '/');
                }
                this.processFile(string, list);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing updates to " + string + ": " + exception.getMessage(), exception);
        }
    }
}

