/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClientAuthInt;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebHttpResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClient {
    private static Logger logger = LoggerFactory.getLogger(WebClient.class);
    private Proxy itsProxy;
    private Integer itsTimeoutConnectionSecs;
    private Integer itsTimeoutTransferSecs;
    private UUID itsUUID;
    private String itsUsername;
    private String itsPassword;
    private WebClientAuthInt itsAuthProvider;

    public WebClient(Integer n, Integer n2) {
        this.itsTimeoutConnectionSecs = n;
        this.itsTimeoutTransferSecs = n2;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public WebClient(Proxy proxy, Integer n, Integer n2) {
        this(n, n2);
        this.itsProxy = proxy;
    }

    public WebClient(String string, Integer n, Integer n2, Integer n3) {
        this(n2, n3);
        if (!Util.isBlank(string)) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, (int)n);
            this.itsProxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
        }
    }

    public UUID getUUID() {
        return this.itsUUID;
    }

    public void setUUID(UUID uUID) {
        this.itsUUID = uUID;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void setAuthProvider(WebClientAuthInt webClientAuthInt) {
        this.itsAuthProvider = webClientAuthInt;
    }

    public void setBasicAuthDetails(String string, String string2) {
        if (!Util.isBlank(string) && !Util.isBlank(string2)) {
            this.itsUsername = string;
            this.itsPassword = string2;
        }
    }

    public void setAPIAuthDetails(String string) {
        if (!Util.isBlank(string)) {
            // empty if block
        }
    }

    public HttpURLConnection getHttpURLConnection(String string, URL uRL, Map<String, String> map) throws ApplicationException {
        HttpURLConnection httpURLConnection = null;
        try {
            boolean bl = uRL.getProtocol().equalsIgnoreCase("https");
            httpURLConnection = bl ? (this.itsProxy == null ? (HttpsURLConnection)uRL.openConnection(Proxy.NO_PROXY) : (HttpsURLConnection)uRL.openConnection(this.itsProxy)) : (this.itsProxy == null ? (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY) : (HttpURLConnection)uRL.openConnection(this.itsProxy));
            httpURLConnection.setRequestMethod(string);
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(string.equalsIgnoreCase("POST") || string.equalsIgnoreCase("PUT"));
            if (this.itsTimeoutConnectionSecs != null) {
                httpURLConnection.setConnectTimeout(this.itsTimeoutConnectionSecs * 1000);
            }
            if (this.itsTimeoutTransferSecs != null) {
                httpURLConnection.setReadTimeout(this.itsTimeoutTransferSecs * 1000);
            }
            httpURLConnection.setUseCaches(false);
            if (bl) {
                SSLContext sSLContext = CertificateManager.getInstance().getSslContext();
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sSLContext.getSocketFactory());
            }
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    httpURLConnection.addRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.error(logger, "Error connecting to HTTP URL " + uRL.toString() + ": " + exception.getMessage(), exception);
        }
        return httpURLConnection;
    }

    @SuppressFBWarnings(value={"DM_STRING_CTOR"}, justification="Avoid holding object references")
    public WebHttpResponse readResponse(HttpURLConnection httpURLConnection) throws IOException {
        BufferedReader bufferedReader;
        WebHttpResponse webHttpResponse = new WebHttpResponse();
        webHttpResponse.ReturnCode = httpURLConnection.getResponseCode();
        if (!Util.isBlank(httpURLConnection.getContentType())) {
            webHttpResponse.ContentType = new String(httpURLConnection.getContentType());
        }
        if (httpURLConnection.getResponseCode() == 200) {
            try (BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                webHttpResponse.Body = bufferedReader2.lines().collect(Collectors.joining("\n"));
            }
        }
        if (httpURLConnection.getErrorStream() != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
            try {
                webHttpResponse.Body = bufferedReader.lines().collect(Collectors.joining("\n"));
            }
            finally {
                bufferedReader.close();
            }
        }
        if (Util.isBlank(webHttpResponse.Body) && httpURLConnection.getInputStream() != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            try {
                webHttpResponse.Body = bufferedReader.lines().collect(Collectors.joining("\n"));
            }
            finally {
                bufferedReader.close();
            }
        }
        if (Util.isBlank(webHttpResponse.Body)) {
            webHttpResponse.Body = httpURLConnection.getResponseMessage();
        }
        return webHttpResponse;
    }

    public WebHttpResponse doGet(String string, Map<String, String> map) throws ApplicationException {
        WebHttpResponse webHttpResponse = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = this.itsAuthProvider.updateURL(string);
            httpURLConnection = this.getHttpURLConnection("GET", uRL, map);
            this.itsAuthProvider.addAuthentication(httpURLConnection, null);
            if (this.itsUUID != null) {
                httpURLConnection.setRequestProperty("X-UUID", this.itsUUID.toString());
            }
            httpURLConnection.connect();
            webHttpResponse = this.readResponse(httpURLConnection);
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring HTTP request from " + string + ": " + exception.getMessage(), exception);
        }
        if (!Util.isBlank(webHttpResponse.Body)) {
            Util_Logger.debug(logger, "API response body is " + webHttpResponse.Body);
        }
        return webHttpResponse;
    }

    public WebHttpResponse doPost(String string, Map<String, String> map, WebContent.MediaType mediaType, String string2) throws ApplicationException {
        WebHttpResponse webHttpResponse = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = this.itsAuthProvider.updateURL(string);
            httpURLConnection = this.getHttpURLConnection("POST", uRL, map);
            this.itsAuthProvider.addAuthentication(httpURLConnection, string2);
            if (this.itsUUID != null) {
                httpURLConnection.setRequestProperty("X-UUID", this.itsUUID.toString());
            }
            httpURLConnection.setRequestProperty("Content-Type", mediaType.toString().replace('_', '/'));
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(string2.length()));
            httpURLConnection.getOutputStream().write(string2.getBytes());
            httpURLConnection.connect();
            webHttpResponse = this.readResponse(httpURLConnection);
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring data to " + string + ": " + exception.getMessage(), exception);
        }
        if (!Util.isBlank(webHttpResponse.Body)) {
            Util_Logger.debug(logger, "API response body is " + webHttpResponse.Body);
        }
        return webHttpResponse;
    }
}

