/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Web.WebParamValidatorTypeBoolean;
import au.com.aemo.Common.Web.WebParamValidatorTypeDate;
import au.com.aemo.Common.Web.WebParamValidatorTypeDecimal;
import au.com.aemo.Common.Web.WebParamValidatorTypeInt;
import au.com.aemo.Common.Web.WebParamValidatorTypeInteger;
import au.com.aemo.Common.Web.WebParamValidatorTypeString;
import java.util.HashMap;
import java.util.Map;

public class WebParamValidatorTypeFactory {
    private Map<String, WebParamValidatorTypeInt> itsValidators = new HashMap<String, WebParamValidatorTypeInt>();

    private WebParamValidatorTypeFactory() {
        this.registorValidator(new WebParamValidatorTypeInteger());
        this.registorValidator(new WebParamValidatorTypeDecimal());
        this.registorValidator(new WebParamValidatorTypeDate());
        this.registorValidator(new WebParamValidatorTypeBoolean());
        this.registorValidator(new WebParamValidatorTypeString());
    }

    public static WebParamValidatorTypeFactory getInstance() {
        return SingletonHolder.instance;
    }

    public void registorValidator(WebParamValidatorTypeInt webParamValidatorTypeInt) {
        for (String string : webParamValidatorTypeInt.getTypes()) {
            this.itsValidators.put(string.toUpperCase(), webParamValidatorTypeInt);
        }
    }

    public WebParamValidatorTypeInt getValidator(String string) throws Exception {
        WebParamValidatorTypeInt webParamValidatorTypeInt = this.itsValidators.get(string.toUpperCase());
        if (webParamValidatorTypeInt != null) {
            return (WebParamValidatorTypeInt)webParamValidatorTypeInt.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return null;
    }

    private static class SingletonHolder {
        private static WebParamValidatorTypeFactory instance = new WebParamValidatorTypeFactory();

        private SingletonHolder() {
        }
    }
}

