/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebParamException;
import au.com.aemo.Common.Web.WebParamValidationConfig;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebParamValidatorTypeInt;
import java.util.Arrays;
import java.util.List;

public class WebParamValidatorTypeString
implements WebParamValidatorTypeInt {
    @Override
    public List<String> getTypes() {
        return Arrays.asList("java.lang.String");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object validate(String string, WebParamValidationConfig webParamValidationConfig) throws WebParamException, IllegalArgumentException {
        String string2 = null;
        if (webParamValidationConfig.getValidator() == WebParamValidationEnum.STR_FILEMASK) {
            if (!string.matches("^[a-zA-Z0-9_\\-*]*$")) throw new WebParamException("Invalid filemask parameter [" + webParamValidationConfig.getSource() + "] with value [" + string + "], aborting request");
            return string;
        }
        if (webParamValidationConfig.getValidator() == WebParamValidationEnum.STR_FILENAME) {
            if (!string.matches("^[a-zA-Z0-9_\\-.]*$")) throw new WebParamException("Invalid filemask parameter [" + webParamValidationConfig.getSource() + "] with value [" + string + "], aborting request");
            return string;
        }
        if (webParamValidationConfig.getValidator() == WebParamValidationEnum.STR_COMMA_DELIMITED_LIST) {
            if (!string.matches("^[a-zA-Z0-9_\\-,]*$")) throw new WebParamException("Invalid parameter [" + webParamValidationConfig.getSource() + "] with value [" + string + "], aborting request");
            return string;
        }
        if (webParamValidationConfig.getValidator() == WebParamValidationEnum.STR_OBJECT_ID) {
            if (!string.matches("^[a-zA-Z0-9_\\-]*$")) throw new WebParamException("Invalid parameter [" + webParamValidationConfig.getSource() + "] with value [" + string + "], aborting request");
            return string;
        }
        if (webParamValidationConfig.getValidator() == WebParamValidationEnum.STR_HEX_KEY) {
            if (!string.matches("^[0-9a-fA-F]+$")) throw new WebParamException("Invalid hex key parameter [" + webParamValidationConfig.getSource() + "] with value [" + string + "], aborting request");
            return string;
        }
        if (webParamValidationConfig.getValidator() == WebParamValidationEnum.STR_CUSTOM) {
            if (Util.isBlank(webParamValidationConfig.getRegex())) {
                throw new IllegalArgumentException("Missing regex specification for parameter [" + webParamValidationConfig.getSource() + "], aborting request");
            }
            if (!string.matches(webParamValidationConfig.getRegex())) throw new WebParamException("Invalid parameter [" + webParamValidationConfig.getSource() + "] with value [\" + theValue + \"], aborting request");
            return string;
        }
        if (webParamValidationConfig.getValidator() != WebParamValidationEnum.NONE) throw new IllegalArgumentException("Unsupported validator [" + webParamValidationConfig.getValidator().name() + "] for String parameter [" + string + "] with value [" + string + "], aborting request");
        return string;
    }
}

