/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Pdr.Database.Engine.EnginePackaging;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPdrReleaseManager {
    private static Logger logger = LoggerFactory.getLogger(AppPdrReleaseManager.class);

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Options options = new Options();
        options.addOption("mi", "minor", false, "Use to generate a minor release");
        options.addOption("mj", "major", false, "Use to generate a major release");
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(options.getOption("minor"));
        optionGroup.addOption(options.getOption("major"));
        optionGroup.setRequired(true);
        options.addOptionGroup(optionGroup);
        options.addOption("b", "base", true, "Powerdesigner model base file");
        options.addOption("u", "update", true, "Powerdesigner model update file");
        options.addRequiredOption("o", "output", true, "The output folder");
        options.addRequiredOption("v", "version", true, "The version of this release");
        options.addRequiredOption("d", "description", true, "The description of this release");
        options.addRequiredOption("cn", "change_notice", true, "The change notice associated with this release");
        options.addOption("s", "source", true, "The source folder for the Data Model");
        DefaultParser defaultParser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            object2 = new HelpFormatter();
            object2.printHelp("AppDatabaseReleaseManager", options);
            System.exit(1);
        }
        String string = commandLine.getOptionValue("base");
        object2 = commandLine.getOptionValue("update");
        String string2 = commandLine.getOptionValue("version");
        String string3 = commandLine.getOptionValue("description");
        String string4 = commandLine.getOptionValue("change_notice");
        String string5 = commandLine.getOptionValue("output");
        boolean bl = commandLine.hasOption("minor");
        String string6 = commandLine.getOptionValue("source");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            if (Util.isBlank(string)) {
                arrayList.add("Configuration option base must be specified for a minor release");
            }
            if (Util.isBlank((String)object2)) {
                arrayList.add("Configuration option update must be specified for a minor release");
            }
        } else if (Util.isBlank(string6)) {
            arrayList.add("Configuration option source must be specified for a major release");
        }
        if (!arrayList.isEmpty()) {
            for (String string7 : arrayList) {
                Util_Logger.error(logger, string7);
            }
            Util_Logger.error(logger, "Detected invalid configuration specification");
            object = new HelpFormatter();
            object.printHelp("AppDatabaseReleaseManager", options);
            System.exit(1);
        }
        try {
            Util_Logger.info(logger, "Generating " + (bl ? "minor" : "major") + " release " + string2);
            object = new EnginePackaging();
            if (bl) {
                ((EnginePackaging)object).processMinorRelease(string2, string3, string4, string5, string, (String)object2);
            } else {
                ((EnginePackaging)object).processMajorRelease(string2, string3, string4, string5, string6);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected error: " + exception.getMessage(), exception);
            System.exit(-1);
        }
    }
}

