/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database.Config;

import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.XML.XmlUtilities;
import au.com.aemo.Common.Zip.ZipUtilities;
import au.com.aemo.Pdr.Database.Config.Artefact;
import au.com.aemo.Pdr.Database.Config.Change;
import au.com.aemo.Pdr.Database.Config.Check;
import au.com.aemo.Pdr.Database.Config.Column;
import au.com.aemo.Pdr.Database.Config.ColumnType;
import au.com.aemo.Pdr.Database.Config.DBSQL;
import au.com.aemo.Pdr.Database.Config.DatabaseSchemaConfig;
import au.com.aemo.Pdr.Database.Config.DatabaseType;
import au.com.aemo.Pdr.Database.Config.Schema;
import au.com.aemo.Pdr.Database.Config.Script;
import au.com.aemo.Pdr.Database.Config.Table;
import au.com.aemo.Pdr.Database.Config.Variable;
import au.com.aemo.Pdr.Database.Config.xStreamDatabaseTypeConverter;
import au.com.aemo.Pdr.Database.Engine.DatabasePackage;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Configuration is consumed by trusted code")
public class ConfigManager {
    public static final String VARIABLE_DATABASE_USER = "DATABASE_USER";
    public static final String VARIABLE_DATABASE_PASSWORD = "DATABASE_PASSWORD";
    public static final String VARIABLE_TABLESPACE_DIR = "TABLESPACE_DIR";
    public static final String VARIABLE_PATH_SEP = "PATH_SEP";
    private static final String SUPPORTED_SCHEMA = "1.0";
    public static final String INSTALL_OPTION_CREATE_SCHEMA = "Create Schema/apply grants";
    private static Logger logger = LoggerFactory.getLogger(ConfigManager.class);
    private DatabaseSchemaConfig itsConfig;
    private Map<String, String> itsScriptParams;
    private List<String> itsInstallPackOptions;
    private DatabasePackage itsDatabasePackage;

    private ConfigManager() {
    }

    public static ConfigManager getInstance() {
        return SingletonHolder.instance;
    }

    private void adjustPrerequistes(List<Check> list) {
        if (list != null) {
            for (Check check : list) {
                if (!Util.isBlank(check.Table)) {
                    check.Table = check.Table.toUpperCase().trim();
                }
                if (!Util.isBlank(check.Column)) {
                    check.Column = check.Column.toUpperCase().trim();
                }
                if (check.DBSQL == null) continue;
                for (DBSQL dBSQL : check.DBSQL) {
                    if (Util.isBlank(dBSQL.DatabaseStr)) continue;
                    dBSQL.Database = DatabaseType.valueOf(dBSQL.DatabaseStr.trim().toUpperCase());
                }
            }
        }
    }

    private void adjustTable(Table table) {
        table.Name = table.Name.toUpperCase().trim();
        if (table.Columns != null) {
            for (Column column : table.Columns) {
                column.Name = column.Name.toUpperCase().trim();
            }
        }
    }

    private void postProcess(DatabaseSchemaConfig databaseSchemaConfig) {
        databaseSchemaConfig.setGeneratedDate(new Date());
        if (databaseSchemaConfig.Package != null) {
            this.adjustPrerequistes(databaseSchemaConfig.Package.Prerequisites);
        }
        if (databaseSchemaConfig.Changes != null) {
            databaseSchemaConfig.Changes.sort((change, change2) -> Integer.compare(change.Order, change2.Order));
            for (Change change3 : databaseSchemaConfig.Changes) {
                if (change3.Variables != null) {
                    for (Variable variable : change3.Variables) {
                        if (variable.Param == null) continue;
                        if (variable.Param.trim().equalsIgnoreCase("SCHEMA_OWNER")) {
                            variable.Param = VARIABLE_DATABASE_USER;
                        }
                        if (!variable.Param.trim().equalsIgnoreCase("SCHEMA_PASSWORD")) continue;
                        variable.Param = VARIABLE_DATABASE_PASSWORD;
                    }
                }
                if (change3.Artefacts == null) continue;
                change3.Artefacts.sort((artefact, artefact2) -> Integer.compare(artefact.Order, artefact2.Order));
                for (Artefact artefact3 : change3.Artefacts) {
                    this.adjustPrerequistes(artefact3.Prerequisites);
                    if (artefact3.Schema == null || artefact3.Schema.Tables == null) continue;
                    artefact3.Schema.Tables.sort((table, table2) -> Integer.compare(table.Order, table2.Order));
                    for (Table table3 : artefact3.Schema.Tables) {
                        this.adjustTable(table3);
                    }
                }
            }
        }
    }

    private boolean checkScriptExists(String string, String string2) {
        return Files.exists(Paths.get(string, string2), new LinkOption[0]);
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Is populated via XML serialisation")
    private void validateConfig(DatabaseSchemaConfig databaseSchemaConfig) throws Exception {
        String string = databaseSchemaConfig.getConfigFolder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Util_Logger.info(logger, "Validating configuration");
        if (databaseSchemaConfig.Package == null) {
            arrayList.add("Detected missing /Package element");
        } else if (databaseSchemaConfig.Package.Data_Model == null) {
            arrayList.add("Detected missing /Package/Type element");
        } else if (databaseSchemaConfig.Package.Description == null) {
            arrayList.add("Detected missing /Package/Description element");
        }
        if (databaseSchemaConfig.Changes == null) {
            arrayList.add("Detected missing /Changes element");
        } else if (databaseSchemaConfig.Changes.size() == 0) {
            arrayList.add("Detected missing /Changes/Change element");
        } else {
            for (Change object : databaseSchemaConfig.Changes) {
                if (object.Id == null) {
                    arrayList.add("Detected missing /Changes/Change/Id attribute");
                }
                if (object.ReleaseDate == null) {
                    arrayList.add("Detected missing /Changes/Change/ReleaseDate attribute");
                }
                if (object.ChangeNotice == null) {
                    arrayList.add("Detected missing /Changes/Change/ChangeNotice attribute");
                }
                if (object.Description == null) {
                    arrayList.add("Detected missing /Changes/Change/Description element");
                }
                if (!Util.isBlank(object.LoaderMappingConfig) && !this.checkScriptExists(string, object.LoaderMappingConfig)) {
                    arrayList.add("Detected missing Loader Mapping for Change " + object.Id + ": " + object.LoaderMappingConfig);
                }
                if (object.Artefacts == null) {
                    arrayList.add("Detected missing /Changes/Change/Artefacts element");
                    continue;
                }
                if (object.Artefacts.size() == 0) {
                    arrayList.add("Detected missing /Changes/Change/Artefacts/Artefact element");
                    continue;
                }
                for (Artefact artefact : object.Artefacts) {
                    if (artefact.Type == null) {
                        arrayList.add("Detected missing /Changes/Change/Artefacts/Artefact/Type attribute");
                    }
                    if (artefact.UserPack == null) {
                        arrayList.add("Detected missing /Changes/Change/Artefacts/Artefact/UserPack attribute");
                    }
                    if (artefact.Description == null) {
                        arrayList.add("Detected missing /Changes/Change/Artefacts/Artefact/Description attribute");
                    }
                    if (artefact.Prerequisites != null) {
                        for (Check check : artefact.Prerequisites) {
                            if (check.Type == null) {
                                arrayList.add("Detected missing /Changes/Change/Artefacts/Prerequisites/Check/Type attribute");
                            }
                            if (check.Action == null) {
                                arrayList.add("Detected missing /Changes/Change/Artefacts/Prerequisites/Check/Action attribute");
                            }
                            if (check.Column != null && check.Table == null) {
                                arrayList.add("Detected missing /Changes/Change/Artefacts/Prerequisites/Check/Table element");
                            }
                            if (check.DBSQL == null) continue;
                            for (DBSQL dBSQL : check.DBSQL) {
                                if (dBSQL.SQL.toUpperCase().trim().startsWith("SELECT ")) continue;
                                arrayList.add("Element /Changes/Change/Artefacts/Prerequisites/Check/SQL must be a select statement");
                            }
                        }
                    }
                    if (artefact.Scripts == null && artefact.Schema == null) {
                        arrayList.add("Element /Changes/Change/Artefacts/Artefact must have either Scripts or Schema element");
                    }
                    if (artefact.Scripts != null) {
                        for (Script script : artefact.Scripts) {
                            if (script.Name == null) {
                                arrayList.add("Detected missing /Changes/Change/Artefacts/Scripts/Name attribute");
                                continue;
                            }
                            if (script.Database == DatabaseType.UNKNOWN || this.checkScriptExists(string, script.Name)) continue;
                            arrayList.add("Detected missing script for Change " + object.Id + ": " + script.Name);
                        }
                    }
                    if (artefact.Schema == null) continue;
                    if (artefact.Schema.Tables == null) {
                        arrayList.add("Detected missing /Changes/Change/Artefacts/Schema/Tables element");
                        continue;
                    }
                    if (artefact.Schema.Tables.size() == 0) {
                        arrayList.add("Detected missing /Changes/Change/Artefacts/Schema/Tables/Table element");
                        continue;
                    }
                    for (Table table : artefact.Schema.Tables) {
                        if (table.Name == null) {
                            arrayList.add("Detected missing /Changes/Change/Artefacts/Schema/Tables/Table/Name attribute");
                        }
                        if (table.Columns == null) {
                            arrayList.add("Detected missing /Changes/Change/Artefacts/Schema/Tables/Tables/Columns element");
                            continue;
                        }
                        if (table.Columns.size() == 0) {
                            arrayList.add("Detected missing /Changes/Change/Artefacts/Schema/Tables/Tables/Columns/Column element");
                            continue;
                        }
                        for (Column column : table.Columns) {
                            if (column.Name == null) {
                                arrayList.add("Detected missing /Changes/Change/Artefacts/Schema/Tables/Table/Columns/Column/Name attribute");
                            }
                            if (column.Type == null) {
                                arrayList.add("Detected missing /Changes/Change/Artefacts/Schema/Tables/Table/Columns/Column/Type attribute");
                                continue;
                            }
                            if (column.Type == ColumnType.NUMBER && column.Scale == null) {
                                arrayList.add("Detected missing /Changes/Change/Artefacts/Schema/Tables/Table/Columns/Column/Scale attribute for NUMBER type");
                                continue;
                            }
                            if (column.Type == ColumnType.DATE || column.Length != null) continue;
                            arrayList.add("Detected missing /Changes/Change/Artefacts/Schema/Tables/Table/Columns/Column/Length attribute");
                        }
                    }
                }
            }
        }
        if (arrayList.size() > 0) {
            for (String string2 : arrayList) {
                Util_Logger.errorNoRaise(logger, string2);
            }
            throw new Exception("Detected fatal configuration error");
        }
        Util_Logger.info(logger, "Validated configuration");
    }

    private XStream getXStreamInstance() {
        XStream xStream = XmlUtilities.getConverter();
        xStream.registerConverter(new DateConverter("dd/MM/yyyy", null, true));
        xStream.processAnnotations(DatabaseSchemaConfig.class);
        xStream.processAnnotations(Change.class);
        xStream.processAnnotations(Artefact.class);
        xStream.processAnnotations(Table.class);
        xStream.processAnnotations(Column.class);
        xStream.processAnnotations(Schema.class);
        xStream.processAnnotations(Variable.class);
        xStream.registerConverter(new xStreamDatabaseTypeConverter());
        return xStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadConfig(String string, String string2) throws Exception {
        Object object;
        String string3 = null;
        Object object2 = string2;
        if (string == null) {
            throw new Exception("Missing database config package zip");
        }
        Object object3 = new File(string);
        if (!((File)object3).exists()) throw new Exception("Database config package [" + string + "] does not exist");
        if (((File)object3).isFile()) {
            if (!string.toLowerCase().endsWith(".zip")) throw new Exception("Database config package must be a zip file");
            if (Util.isBlank((String)object2)) {
                object2 = ((File)object3).getParent();
            }
            if (!((File)(object = new File((String)(object2 = (String)object2 + File.separator + ((File)object3).getName().substring(0, ((File)object3).getName().length() - 4))))).exists() && ((File)object).mkdirs()) {
                Util_Logger.info(logger, "Created package configuration folder: " + ((File)object).getName());
            }
            ZipUtilities.unzip(string, false, (String)object2);
        } else if (((File)object3).isDirectory()) {
            object2 = string;
        }
        string3 = ((File)object3).getName();
        object3 = new DatabaseSchemaConfig();
        ((DatabaseSchemaConfig)object3).setSourcePackageFile(string3);
        ((DatabaseSchemaConfig)object3).setConfigFolder((String)object2);
        object = ((DatabaseSchemaConfig)object3).getConfigFolder() + File.separatorChar + "schema.xml";
        if (!Files.exists(Paths.get((String)object, new String[0]), new LinkOption[0])) {
            throw new Exception("Missing schema.xml in database package");
        }
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File((String)object));
        XStream xStream = this.getXStreamInstance();
        xStream.unmarshal(new DomReader(document), object3);
        Util_Logger.info(logger, "Loaded configuration from " + (String)object);
        boolean bl = false;
        if (((DatabaseSchemaConfig)object3).Version == null) {
            bl = true;
        } else if (((DatabaseSchemaConfig)object3).Version.equalsIgnoreCase(SUPPORTED_SCHEMA)) {
            bl = true;
        } else {
            double d = Double.parseDouble(((DatabaseSchemaConfig)object3).Version);
            double d2 = Double.parseDouble(SUPPORTED_SCHEMA);
            boolean bl2 = bl = d2 >= d;
        }
        if (!bl) {
            throw new Exception("Databaase package [" + (String)object + "] schema [v" + ((DatabaseSchemaConfig)object3).Version + "] is not supported by this application which supports up to schema [v1.0]. Please update this software to the latest version.");
        }
        this.postProcess((DatabaseSchemaConfig)object3);
        this.validateConfig((DatabaseSchemaConfig)object3);
        this.itsConfig = object3;
    }

    public String saveConfig(DatabaseSchemaConfig databaseSchemaConfig, Path path, List<String> list, String string) throws Exception {
        String string2 = null;
        for (Change object2 : databaseSchemaConfig.Changes) {
            string2 = object2.Id;
        }
        String string3 = String.valueOf(path) + "/schema.xml";
        XStream xStream = this.getXStreamInstance();
        StringWriter stringWriter = new StringWriter();
        PrettyPrintWriter prettyPrintWriter = new PrettyPrintWriter(stringWriter);
        xStream.marshal(databaseSchemaConfig, prettyPrintWriter);
        try (Object object = new PrintWriter(string3);){
            ((PrintWriter)object).println(stringWriter.toString());
        }
        object = new ArrayList();
        object.add(string3);
        if (list != null) {
            object.addAll(list);
        }
        String string4 = "database_update_package_v" + string2 + ".zip";
        String string5 = String.valueOf(path) + "/" + string4;
        ZipUtilities.zip(string5, (List<String>)object, true, false);
        String string6 = string + "/" + string4;
        FileUtilities.renameFile(string5, string6);
        return string6;
    }

    public DatabaseSchemaConfig getConfig() {
        return this.itsConfig;
    }

    public String createHeading() {
        StringBuilder stringBuilder = new StringBuilder();
        DatabaseSchemaConfig databaseSchemaConfig = this.itsConfig;
        if (databaseSchemaConfig != null) {
            stringBuilder.append(databaseSchemaConfig.Package.Type + " install for " + databaseSchemaConfig.Package.Description);
            if (databaseSchemaConfig.Changes != null) {
                stringBuilder.append(" - ");
                String string = "";
                for (Change change : databaseSchemaConfig.Changes) {
                    stringBuilder.append(string);
                    stringBuilder.append("v");
                    stringBuilder.append(change.Id);
                    string = " + ";
                }
            }
        }
        return stringBuilder.toString();
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "VA_FORMAT_STRING_USES_NEWLINE"})
    public String createSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        DatabaseSchemaConfig databaseSchemaConfig = this.itsConfig;
        if (databaseSchemaConfig != null) {
            stringBuilder.append("Database " + databaseSchemaConfig.Package.Type + " install for " + databaseSchemaConfig.Package.Description + "\n");
            stringBuilder.append("\n");
            if (databaseSchemaConfig.Changes != null) {
                stringBuilder.append("Release details:\n");
                stringBuilder.append("\n");
                stringBuilder.append("ID    Notice              Release Date   Description\n");
                for (Change change : databaseSchemaConfig.Changes) {
                    formatter.format("%-6s%-20s%-15s%-50s\n", change.Id, change.ChangeNotice, Util.dateToStr(change.ReleaseDate, "dd/MM/yyyy"), change.Description);
                    if (Util.isBlank(change.Release_Notes)) continue;
                    Stream<String> stream = change.Release_Notes.lines();
                    List list = stream.collect(Collectors.toList());
                    for (String string : list) {
                        formatter.format("      %s\n", string);
                    }
                }
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public Map<String, String> getScriptParams() {
        return this.itsScriptParams;
    }

    public void setScriptParams(Map<String, String> map) {
        this.itsScriptParams = map;
    }

    public List<String> getInstallPackOptions() {
        return this.itsInstallPackOptions;
    }

    public void setInstallPackOptions(List<String> list) {
        this.itsInstallPackOptions = list;
    }

    public DatabasePackage getDatabasePackage() {
        return this.itsDatabasePackage;
    }

    public void setDatabasePackage(DatabasePackage databasePackage) {
        this.itsDatabasePackage = databasePackage;
    }

    private static class SingletonHolder {
        private static ConfigManager instance = new ConfigManager();

        private SingletonHolder() {
        }
    }
}

