/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database.Engine;

import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.XML.XmlUtilities;
import au.com.aemo.Pdr.Database.Config.Artefact;
import au.com.aemo.Pdr.Database.Config.ArtefactType;
import au.com.aemo.Pdr.Database.Config.Change;
import au.com.aemo.Pdr.Database.Config.Check;
import au.com.aemo.Pdr.Database.Config.CheckAction;
import au.com.aemo.Pdr.Database.Config.CheckType;
import au.com.aemo.Pdr.Database.Config.Column;
import au.com.aemo.Pdr.Database.Config.ColumnType;
import au.com.aemo.Pdr.Database.Config.ConfigManager;
import au.com.aemo.Pdr.Database.Config.DatabaseSchemaConfig;
import au.com.aemo.Pdr.Database.Config.DatabaseType;
import au.com.aemo.Pdr.Database.Config.Package;
import au.com.aemo.Pdr.Database.Config.Schema;
import au.com.aemo.Pdr.Database.Config.Script;
import au.com.aemo.Pdr.Database.Config.Table;
import au.com.aemo.Pdr.Database.Engine.DataModelCheck;
import au.com.aemo.Pdr.Database.Engine.DataModelVersion;
import au.com.aemo.Pdr.Database.Engine.DataModelVersionConfig;
import au.com.aemo.Pdr.Database.Engine.EngineBase;
import au.com.aemo.Pdr.PowerDesigner.PDColumnWrapper;
import au.com.aemo.Pdr.PowerDesigner.PDKeyWrapper;
import au.com.aemo.Pdr.PowerDesigner.PDModelWrapper;
import au.com.aemo.Pdr.PowerDesigner.PDPackageWrapper;
import au.com.aemo.Pdr.PowerDesigner.PDTableWrapper;
import au.com.aemo.Pdr.PowerDesigner.PowerDesignerManager;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnginePackaging
extends EngineBase {
    private static Logger logger = LoggerFactory.getLogger(EnginePackaging.class);

    private boolean compareForMatch(Integer n, Integer n2) {
        boolean bl = true;
        if (n != null && n2 != null) {
            bl = n.intValue() == n2.intValue();
        } else if (n == null && n2 != null) {
            bl = false;
        }
        return bl;
    }

    private boolean compareForMatch(String string, String string2) {
        boolean bl = true;
        if (string != null && string2 != null) {
            bl = string.equalsIgnoreCase(string2);
        } else if (string == null && string2 != null) {
            bl = false;
        }
        return bl;
    }

    private Table prepareTable(PDTableWrapper pDTableWrapper, int n) {
        Table table = new Table();
        table.Name = pDTableWrapper.Name;
        table.Comment = pDTableWrapper.Comment;
        table.Order = n;
        table.Tablespace = pDTableWrapper.PhysicalOptions;
        PDKeyWrapper pDKeyWrapper = pDTableWrapper.getPrimaryKey();
        if (pDKeyWrapper != null) {
            table.NamePK = pDKeyWrapper.ConstraintName;
            table.TablespacePK = pDKeyWrapper.PhysicalOptions;
        }
        for (PDColumnWrapper pDColumnWrapper : pDTableWrapper.Columns) {
            Column column = new Column();
            column.Name = pDColumnWrapper.Name;
            column.Comment = pDColumnWrapper.Comment;
            String string = pDColumnWrapper.DataType;
            if (string.indexOf("(") > 0) {
                string = pDColumnWrapper.DataType.substring(0, pDColumnWrapper.DataType.indexOf("("));
            }
            string = string.toUpperCase();
            column.Type = ColumnType.valueOf(string);
            column.Length = pDColumnWrapper.Length;
            column.Scale = pDColumnWrapper.Precision;
            column.PK = pDColumnWrapper.isPK;
            table.Columns.add(column);
        }
        return table;
    }

    private DatabaseSchemaConfig createDatabaseSchemaConfig(boolean bl) {
        DatabaseSchemaConfig databaseSchemaConfig = new DatabaseSchemaConfig();
        Package package_ = new Package();
        package_.Data_Model = bl ? "MMSDM" : "GASDM";
        package_.Description = package_.Data_Model + " Data Model";
        databaseSchemaConfig.Package = package_;
        Check check = new Check();
        check.Type = CheckType.EXISTS;
        check.Action = CheckAction.ERROR;
        check.Table = bl ? "TRADINGPRICE" : "GAS_CAPACITY_TYPE";
        check.Description = "Valid " + package_.Data_Model + " database installation";
        package_.Prerequisites.add(check);
        return databaseSchemaConfig;
    }

    public String processMinorRelease(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        Object object;
        Object object5;
        PDModelWrapper pDModelWrapper = PowerDesignerManager.loadPowerDesignerDefinitions(string5);
        PDModelWrapper pDModelWrapper2 = PowerDesignerManager.loadPowerDesignerDefinitions(string6);
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        ArrayList<PDTableWrapper> arrayList2 = new ArrayList<PDTableWrapper>();
        ArrayList<PDTableWrapper> arrayList3 = new ArrayList<PDTableWrapper>();
        Iterator<PDPackageWrapper> iterator = pDModelWrapper2.Packages.iterator();
        while (iterator.hasNext()) {
            object5 = iterator.next();
            for (PDTableWrapper object42 : ((PDPackageWrapper)object5).Tables) {
                boolean configManager;
                object = pDModelWrapper.getTable(object42.Name);
                if (object == null) {
                    arrayList2.add(object42);
                    Util_Logger.info(logger, "Detected new table [" + object42.Name + "]");
                    continue;
                }
                PDTableWrapper n = new PDTableWrapper();
                n.Name = object42.Name;
                n.Comment = object42.Comment;
                boolean bl = configManager = !this.compareForMatch(((PDTableWrapper)object).Comment, object42.Comment);
                if (configManager) {
                    Util_Logger.info(logger, "Detected comment update on [" + object42.Name + "]");
                }
                for (PDColumnWrapper pDColumnWrapper : object42.Columns) {
                    PDColumnWrapper pDColumnWrapper2 = null;
                    for (PDColumnWrapper pDColumnWrapper3 : ((PDTableWrapper)object).Columns) {
                        if (!pDColumnWrapper.Name.equalsIgnoreCase(pDColumnWrapper3.Name)) continue;
                        pDColumnWrapper2 = pDColumnWrapper3;
                        break;
                    }
                    if (pDColumnWrapper2 == null) {
                        if (!pDColumnWrapper.isPK) {
                            n.Columns.add(pDColumnWrapper);
                            Util_Logger.info(logger, "Detected new column [" + object42.Name + "." + pDColumnWrapper.Name + "]");
                            continue;
                        }
                        arrayList.add((CallSite)((Object)("Packaging method cannot support adding column [" + n.Name + "." + pDColumnWrapper.Name + "] to primary key")));
                        continue;
                    }
                    boolean bl2 = false;
                    if (!this.compareForMatch(pDColumnWrapper2.Comment, pDColumnWrapper.Comment)) {
                        bl2 = true;
                    } else if (!pDColumnWrapper2.DataType.equalsIgnoreCase(pDColumnWrapper.DataType)) {
                        bl2 = true;
                    } else if (!this.compareForMatch(pDColumnWrapper2.Length, pDColumnWrapper.Length)) {
                        bl2 = true;
                    } else if (!this.compareForMatch(pDColumnWrapper2.Precision, pDColumnWrapper.Precision)) {
                        bl2 = true;
                    } else if (pDColumnWrapper2.isPK != pDColumnWrapper.isPK) {
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    if (pDColumnWrapper2.isPK == pDColumnWrapper.isPK) {
                        n.Columns.add(pDColumnWrapper);
                        Util_Logger.info(logger, "Detected modified column [" + n.Name + "." + pDColumnWrapper.Name + "]");
                        continue;
                    }
                    arrayList.add((CallSite)((Object)("Packaging method cannot support primary key changes to modified column [" + n.Name + "." + pDColumnWrapper.Name + "]")));
                }
                if (n.Columns.size() <= 0 && !configManager) continue;
                arrayList3.add(n);
            }
        }
        if (arrayList.size() > 0 && (iterator = arrayList.iterator()).hasNext()) {
            object5 = (String)((Object)iterator.next());
            Util_Logger.errorNoRaise(logger, (String)object5);
            throw new Exception("Model updates failed validation");
        }
        boolean bl = pDModelWrapper.getTable("TRADINGPRICE") != null;
        object5 = this.createDatabaseSchemaConfig(bl);
        Change change = new Change();
        change.Id = string;
        change.Description = string2;
        change.ChangeNotice = string3;
        change.ReleaseDate = this.InstallationDate;
        change.Order = 1;
        ((DatabaseSchemaConfig)object5).Changes.add(change);
        Artefact artefact = new Artefact();
        artefact.Order = 1;
        artefact.Type = ArtefactType.DDL;
        change.Artefacts.add(artefact);
        artefact.Schema = object = new Schema();
        int n = 1;
        for (PDTableWrapper pDTableWrapper : arrayList2) {
            Table table = this.prepareTable(pDTableWrapper, n);
            ((Schema)object).Tables.add(table);
            ++n;
        }
        for (PDTableWrapper pDTableWrapper : arrayList3) {
            Table table = this.prepareTable(pDTableWrapper, n);
            ((Schema)object).Tables.add(table);
            ++n;
        }
        ConfigManager configManager = ConfigManager.getInstance();
        Path path = Files.createTempDirectory("pdr_sb_release", new FileAttribute[0]);
        String string7 = configManager.saveConfig((DatabaseSchemaConfig)object5, path, null, string4);
        Util_Logger.info(logger, "Generated output package: " + string7);
        return string7;
    }

    public String processMajorRelease(String string, String string2, String string3, String string4, String string5) throws Exception {
        Object object;
        int n;
        Iterator iterator;
        XStream xStream = XmlUtilities.getConverter();
        xStream.processAnnotations(DataModelVersionConfig.class);
        xStream.processAnnotations(DataModelVersion.class);
        xStream.processAnnotations(DataModelCheck.class);
        xStream.ignoreUnknownElements();
        File file = new File(string5, "mmsdm_version_checks.xml");
        DataModelVersionConfig dataModelVersionConfig = (DataModelVersionConfig)xStream.fromXML(file);
        Util_Logger.info(logger, "Loaded " + dataModelVersionConfig.versions.size() + " version checks from " + file.getPath());
        ArrayList arrayList = new ArrayList();
        if (arrayList.size() > 0 && (iterator = arrayList.iterator()).hasNext()) {
            String string6 = (String)iterator.next();
            Util_Logger.errorNoRaise(logger, string6);
            throw new Exception("Model updates failed validation");
        }
        boolean bl = string5.indexOf("Electricity") > 0;
        DatabaseSchemaConfig databaseSchemaConfig = this.createDatabaseSchemaConfig(bl);
        Change change = new Change();
        change.Id = string;
        change.Description = string2;
        change.ChangeNotice = string3;
        change.ReleaseDate = this.InstallationDate;
        change.Order = 1;
        databaseSchemaConfig.Changes.add(change);
        Path path = Files.createTempDirectory("pdr_sb_release", new FileAttribute[0]);
        Path path2 = Paths.get(path.toString(), change.Id);
        Files.createDirectory(path2, new FileAttribute[0]);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Artefact artefact = new Artefact();
        artefact.Order = 1;
        artefact.Type = ArtefactType.DDL;
        for (n = 0; n < dataModelVersionConfig.versions.size(); ++n) {
            object = dataModelVersionConfig.versions.get(n);
            for (DataModelCheck dataModelCheck : ((DataModelVersion)object).checks) {
                Check object2 = new Check();
                if (n < dataModelVersionConfig.versions.size() - 1) {
                    object2.Description = "Data Model v" + ((DataModelVersion)object).VersionNo + " applied";
                    object2.Type = CheckType.EXISTS;
                } else {
                    object2.Description = "Data Model v" + ((DataModelVersion)object).VersionNo + " (this upgrade) not already applied";
                    object2.Type = CheckType.DOES_NOT_EXIST;
                }
                object2.Action = CheckAction.ERROR;
                object2.Table = dataModelCheck.TableName;
                if (!Util.isBlank(dataModelCheck.ColumnName)) {
                    object2.Column = dataModelCheck.ColumnName;
                }
                artefact.Prerequisites.add(object2);
            }
        }
        n = 1;
        for (DatabaseType databaseType : DatabaseType.values()) {
            String string6 = databaseType.toString().toLowerCase() + "_alter_mms_data_model.sql";
            Script script = new Script();
            script.Order = n;
            script.Database = databaseType;
            script.Name = string6;
            artefact.Scripts.add(script);
            String string7 = databaseType.toString().equalsIgnoreCase("SQLSERVER") ? "MSSQLSERVER" : databaseType.toString();
            File file2 = new File(path2.toString(), string6);
            FileUtilities.copy(new File(string5 + "/" + string7, "alter_mms_data_model.sql"), new File(path2.toString(), string6));
            arrayList2.add(file2.toString());
            ++n;
        }
        change.Artefacts.add(artefact);
        object = ConfigManager.getInstance();
        String string9 = ((ConfigManager)object).saveConfig(databaseSchemaConfig, path, arrayList2, string4);
        Util_Logger.info(logger, "Generated output package: " + string9);
        return string9;
    }
}

