/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database.Engine;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.CSV.CsvSerialisation;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Pdr.Database.Config.DatabaseSchemaConfig;
import au.com.aemo.Pdr.Database.Config.LoaderConfig;
import au.com.aemo.Pdr.Database.Config.LoaderConfigReportAuditSummary;
import au.com.aemo.Pdr.Database.Config.LoaderConfigReportRecordMapping;
import au.com.aemo.Pdr.Database.Config.LoaderConfigReportRecords;
import au.com.aemo.Pdr.Database.Config.LoaderConfigReportTypeConfig;
import java.sql.Connection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderConfigManager {
    protected static final String PDR_REPORT_TYPE_CONFIG = "PDR_REPORT_TYPE_CONFIG";
    protected static final String PDR_REPORT_RECORDS = "PDR_REPORT_RECORDS";
    protected static final String PDR_REPORT_RECORD_MAPPING = "PDR_REPORT_RECORD_MAPPING";
    protected static final String PDR_REPORT_AUDIT_SUMMARY = "PDR_REPORT_AUDIT_SUMMARY";
    protected static final String NEW_TABLE = "<NEW>";
    private static Logger logger = LoggerFactory.getLogger(LoaderConfigManager.class);

    public LoaderConfig loadFromDatabase(Connection connection, DatabaseSchemaConfig databaseSchemaConfig, DbHandler dbHandler) throws ApplicationException {
        LoaderConfig loaderConfig = new LoaderConfig();
        try {
            Util_Logger.info(logger, "Loading pdrLoader configuration from database");
            String string = dbHandler.getTableReference(databaseSchemaConfig.SchemaManagementTables, PDR_REPORT_TYPE_CONFIG);
            String string2 = "Select * from " + string;
            loaderConfig.itsReportTypes = DbManager.selectObjects(connection, LoaderConfigReportTypeConfig.class, databaseSchemaConfig.SchemaManagementTables, PDR_REPORT_TYPE_CONFIG, string2);
            string = dbHandler.getTableReference(databaseSchemaConfig.SchemaManagementTables, PDR_REPORT_RECORDS);
            string2 = "Select * from " + string;
            loaderConfig.itsReportRecords = DbManager.selectObjects(connection, LoaderConfigReportRecords.class, databaseSchemaConfig.SchemaManagementTables, PDR_REPORT_RECORDS, string2);
            string = dbHandler.getTableReference(databaseSchemaConfig.SchemaManagementTables, PDR_REPORT_RECORD_MAPPING);
            string2 = "Select * from " + string;
            loaderConfig.itsReportRecordMapping = DbManager.selectObjects(connection, LoaderConfigReportRecordMapping.class, databaseSchemaConfig.SchemaManagementTables, PDR_REPORT_RECORD_MAPPING, string2);
            string = dbHandler.getTableReference(databaseSchemaConfig.SchemaManagementTables, PDR_REPORT_AUDIT_SUMMARY);
            string2 = "Select * from " + string;
            loaderConfig.itsReportAuditSummary = DbManager.selectObjects(connection, LoaderConfigReportAuditSummary.class, databaseSchemaConfig.SchemaManagementTables, PDR_REPORT_AUDIT_SUMMARY, string2);
            Util_Logger.info(logger, "Loaded pdrLoader configuration from database");
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error loading pdrLoader configuration:" + exception.getMessage(), exception);
        }
        return loaderConfig;
    }

    public LoaderConfig loadFromFile(String string) throws ApplicationException {
        LoaderConfig loaderConfig = null;
        try {
            Util_Logger.info(logger, "Loading pdrLoader configuration release updates from change package");
            LoaderConfig loaderConfig2 = new LoaderConfig();
            loaderConfig2.itsReportTypes = CsvSerialisation.readObjects(string, List.of("PDR_REPORT", "FILE", "*"), LoaderConfigReportTypeConfig.class);
            loaderConfig2.itsReportRecords = CsvSerialisation.readObjects(string, List.of("PDR_REPORT", "TABLE", "*"), LoaderConfigReportRecords.class);
            loaderConfig2.itsReportRecordMapping = CsvSerialisation.readObjects(string, List.of("PDR_REPORT", "COLUMN", "*"), LoaderConfigReportRecordMapping.class);
            loaderConfig2.itsReportAuditSummary = CsvSerialisation.readObjects(string, List.of("PDR_REPORT", "MAPPING", "*"), LoaderConfigReportAuditSummary.class);
            Util_Logger.info(logger, "Loaded pdrLoader configuration release updates from change package");
            loaderConfig = loaderConfig2;
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error loading pdrLoader configuration from file [" + string + "]:" + exception.getMessage(), exception);
        }
        return loaderConfig;
    }

    public LoaderConfig assessDifferences(LoaderConfig loaderConfig, LoaderConfig loaderConfig2) {
        LoaderConfig loaderConfig3 = new LoaderConfig();
        for (LoaderConfigReportTypeConfig object : loaderConfig2.itsReportTypes) {
            if (loaderConfig.containsConfig(object)) continue;
            loaderConfig3.itsReportTypes.add(object);
        }
        if (loaderConfig3.itsReportTypes.size() > 0) {
            Util_Logger.info(logger, "Detected [" + loaderConfig3.itsReportTypes.size() + "] new configurations for PDR_REPORT_TYPE_CONFIG");
        }
        for (LoaderConfigReportRecords loaderConfigReportRecords : loaderConfig2.itsReportRecords) {
            if (loaderConfig.containsConfig(loaderConfigReportRecords)) continue;
            loaderConfig3.itsReportRecords.add(loaderConfigReportRecords);
        }
        if (loaderConfig3.itsReportRecords.size() > 0) {
            Util_Logger.info(logger, "Detected [" + loaderConfig3.itsReportRecords.size() + "] new configurations for PDR_REPORT_RECORDS");
        }
        for (LoaderConfigReportRecordMapping loaderConfigReportRecordMapping : loaderConfig2.itsReportRecordMapping) {
            if (loaderConfig.containsConfig(loaderConfigReportRecordMapping)) continue;
            loaderConfig3.itsReportRecordMapping.add(loaderConfigReportRecordMapping);
        }
        if (loaderConfig3.itsReportRecordMapping.size() > 0) {
            Util_Logger.info(logger, "Detected [" + loaderConfig3.itsReportRecordMapping.size() + "] new configurations for PDR_REPORT_RECORD_MAPPING");
        }
        for (LoaderConfigReportAuditSummary loaderConfigReportAuditSummary : loaderConfig2.itsReportAuditSummary) {
            if (loaderConfig.containsConfig(loaderConfigReportAuditSummary)) continue;
            loaderConfig3.itsReportAuditSummary.add(loaderConfigReportAuditSummary);
        }
        if (loaderConfig3.itsReportAuditSummary.size() > 0) {
            Util_Logger.info(logger, "Detected [" + loaderConfig3.itsReportAuditSummary.size() + "] new configurations for PDR_REPORT_AUDIT_SUMMARY");
        }
        return loaderConfig3;
    }

    public LoaderConfig appendDeltaUpdates(LoaderConfig loaderConfig, LoaderConfig loaderConfig2) {
        LoaderConfig loaderConfig3 = new LoaderConfig();
        loaderConfig3.itsReportTypes.addAll(loaderConfig.itsReportTypes);
        loaderConfig3.itsReportRecords.addAll(loaderConfig.itsReportRecords);
        loaderConfig3.itsReportRecordMapping.addAll(loaderConfig.itsReportRecordMapping);
        loaderConfig3.itsReportAuditSummary.addAll(loaderConfig.itsReportAuditSummary);
        loaderConfig3.itsReportTypes.addAll(loaderConfig2.itsReportTypes);
        loaderConfig3.itsReportRecords.addAll(loaderConfig2.itsReportRecords);
        loaderConfig3.itsReportRecordMapping.addAll(loaderConfig2.itsReportRecordMapping);
        loaderConfig3.itsReportAuditSummary.addAll(loaderConfig2.itsReportAuditSummary);
        return loaderConfig3;
    }
}

