/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database.Engine;

import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Pdr.Database.Config.Change;
import au.com.aemo.Pdr.Database.Config.DatabaseSchemaConfig;
import au.com.aemo.Pdr.Database.Engine.DatabasePackage;
import au.com.aemo.Pdr.Database.Engine.EngineGeneratedSQLScript;
import au.com.aemo.Pdr.Database.Providers.DbProviderInt;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class ScriptManager {
    private DatabaseSchemaConfig itsConfig;
    private DbProviderInt itsProvider;
    private int itsScriptNumber;
    private EngineGeneratedSQLScript currentScript;
    private List<EngineGeneratedSQLScript> itsGeneratedSQL;
    private String itsSqlDirectory;
    private List<String> WarningMessages;
    private List<String> FailedChecks;
    private List<String> InstallationInstructions;
    private Change lastWrittenChangeHeader;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Method is called by trusted code")
    public ScriptManager(DatabaseSchemaConfig databaseSchemaConfig, DbProviderInt dbProviderInt, String string) {
        this.itsConfig = databaseSchemaConfig;
        this.itsProvider = dbProviderInt;
        this.itsSqlDirectory = string;
        this.itsGeneratedSQL = new ArrayList<EngineGeneratedSQLScript>();
        this.WarningMessages = new ArrayList<String>();
        this.FailedChecks = new ArrayList<String>();
        this.InstallationInstructions = new ArrayList<String>();
    }

    private String getFilename(int n, boolean bl) {
        Object object = Util.replaceAll(this.itsConfig.Package.Description, " ", "_") + "_" + n + "_" + this.itsProvider.getUser(bl);
        object = ((String)object).replaceAll(" ", "_");
        return object;
    }

    private void createNewScript(boolean bl) throws IOException {
        ++this.itsScriptNumber;
        EngineGeneratedSQLScript engineGeneratedSQLScript = new EngineGeneratedSQLScript();
        engineGeneratedSQLScript.Order = this.itsScriptNumber;
        engineGeneratedSQLScript.Administrator = bl;
        File file = Files.createTempFile(this.getFilename(this.itsScriptNumber, bl), ".sql", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        engineGeneratedSQLScript.File = file;
        engineGeneratedSQLScript.HasActiveArtefact = false;
        this.itsGeneratedSQL.add(engineGeneratedSQLScript);
        this.currentScript = engineGeneratedSQLScript;
        this.lastWrittenChangeHeader = null;
    }

    public EngineGeneratedSQLScript getCurrentScript(Change change, boolean bl) throws IOException {
        boolean bl2 = false;
        if (this.currentScript == null) {
            bl2 = true;
        } else if (bl != this.currentScript.Administrator) {
            bl2 = true;
        }
        if (bl2) {
            this.createNewScript(bl);
        }
        if (this.lastWrittenChangeHeader == null) {
            this.writeChangeHeader(this.currentScript.File, change);
            this.lastWrittenChangeHeader = change;
        } else if (!change.Id.equalsIgnoreCase(this.lastWrittenChangeHeader.Id)) {
            this.writeChangeHeader(this.currentScript.File, change);
            this.lastWrittenChangeHeader = change;
        }
        return this.currentScript;
    }

    public DatabasePackage getDatabasePackage() throws IOException {
        DatabasePackage databasePackage = new DatabasePackage();
        ArrayList<EngineGeneratedSQLScript> arrayList = new ArrayList<EngineGeneratedSQLScript>();
        int n = 0;
        for (EngineGeneratedSQLScript engineGeneratedSQLScript : this.itsGeneratedSQL) {
            if (!engineGeneratedSQLScript.HasActiveArtefact) continue;
            EngineGeneratedSQLScript engineGeneratedSQLScript2 = new EngineGeneratedSQLScript();
            engineGeneratedSQLScript2.Order = ++n;
            engineGeneratedSQLScript2.Administrator = engineGeneratedSQLScript.Administrator;
            String string = this.itsSqlDirectory + File.separatorChar + this.getFilename(n, engineGeneratedSQLScript2.Administrator) + ".sql";
            engineGeneratedSQLScript2.File = new File(string);
            this.writeScriptHeader(engineGeneratedSQLScript2.File, engineGeneratedSQLScript2.Administrator, n);
            try (FileOutputStream fileOutputStream = new FileOutputStream(engineGeneratedSQLScript2.File, true);){
                fileOutputStream.write(Files.readAllBytes(engineGeneratedSQLScript.File.toPath()));
            }
            arrayList.add(engineGeneratedSQLScript2);
        }
        databasePackage.setGeneratedSQL(arrayList);
        databasePackage.setWarningMessages(this.WarningMessages);
        databasePackage.setImplementationInstructions(this.InstallationInstructions);
        this.createSummaryFile(databasePackage);
        return databasePackage;
    }

    private void createSummaryFile(DatabasePackage databasePackage) throws IOException {
        Path path = Files.createTempFile("database_changes_summary_", ".txt", new FileAttribute[0]);
        Files.deleteIfExists(path);
        path.toFile().deleteOnExit();
        if (databasePackage.getGeneratedSQL().size() > 0) {
            for (EngineGeneratedSQLScript engineGeneratedSQLScript : databasePackage.getGeneratedSQL()) {
                Path path2 = engineGeneratedSQLScript.File.toPath();
                byte[] byArray = Files.readAllBytes(path2);
                Files.write(path, byArray, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
        } else {
            for (Change change : this.itsConfig.Changes) {
                this.writeChangeHeader(path.toFile(), change);
                try (FileWriter fileWriter = new FileWriter(path.toFile(), true);
                     PrintWriter printWriter = new PrintWriter(fileWriter);){
                    printWriter.println();
                    printWriter.println("/* no changes detected */");
                    printWriter.println();
                }
            }
        }
        databasePackage.setSummaryFile(path.toString());
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Encoding new line is not a material issue")
    private void writeScriptHeader(File file, boolean bl, int n) throws IOException {
        try (FileWriter fileWriter = new FileWriter(file, true);
             PrintWriter printWriter = new PrintWriter(fileWriter);){
            DbHandler dbHandler;
            String string;
            printWriter.println("/*==============================================================================*/");
            printWriter.printf("/* DBMS type:                %-50s */\n", new Object[]{this.itsProvider.getId()});
            printWriter.printf("/* Created on:               %-50s */\n", Util.dateToStr(this.itsConfig.getGeneratedDate(), "dd/MM/yyyy HH:mm:ss"));
            printWriter.printf("/* Created against database: %-50s */\n", this.itsProvider.getURL());
            printWriter.printf("/* Created against user:     %-50s */\n", this.itsProvider.getUser(bl));
            if (!Util.isBlank(this.itsConfig.SchemaDataModelTables)) {
                printWriter.printf("/* Data Model schema:        %-50s */\n", this.itsConfig.SchemaDataModelTables);
            }
            if (!Util.isBlank(this.itsConfig.SchemaManagementTables)) {
                printWriter.printf("/* PDR Tables schema:        %-50s */\n", this.itsConfig.SchemaManagementTables);
            }
            printWriter.printf("/* Script number:            %-50s */\n", n);
            printWriter.println("/*==============================================================================*/");
            if (!Util.isBlank(this.itsConfig.SchemaDataModelTables) && !Util.isBlank(string = (dbHandler = this.itsProvider.getHandler(bl)).getDefaultSchemaSQL())) {
                printWriter.println();
                printWriter.println("/* Setting the schema for data model installation */");
                printWriter.println(string + ";");
            }
            printWriter.println();
        }
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Encoding new line is not a material issue")
    private void writeChangeHeader(File file, Change change) throws IOException {
        try (FileWriter fileWriter = new FileWriter(file, true);
             PrintWriter printWriter = new PrintWriter(fileWriter);){
            printWriter.println("/*==============================================================================*/");
            printWriter.printf("/* Change ID:                %-50s */\n", change.Id);
            printWriter.printf("/* Change Notice:            %-50s */\n", change.ChangeNotice);
            printWriter.printf("/* Change Description:       %-50s */\n", change.Description);
            printWriter.printf("/* Release date:             %-50s */\n", Util.dateToStr(change.ReleaseDate, "dd/MM/yyyy"));
            printWriter.println("/*==============================================================================*/");
            printWriter.println();
        }
    }

    public void addWarning(String string) {
        this.WarningMessages.add(string);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Method is called by trusted code")
    public List<String> getWarningMessages() {
        return this.WarningMessages;
    }

    public void addFailedCheck(String string) {
        this.FailedChecks.add(string);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Method is called by trusted code")
    public List<String> getFailedChecks() {
        return this.FailedChecks;
    }

    public void addInstallationInstructions(String string) {
        this.InstallationInstructions.add(string);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Method is called by trusted code")
    public List<String> getInstallationInstructions() {
        return this.InstallationInstructions;
    }
}

