/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database.Providers;

import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Pdr.Database.Config.Script;
import au.com.aemo.Pdr.Database.Config.Table;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class DbProviderBase {
    private DbHandler HandlerSchema;
    private DbHandler HandlerSystem;
    private DatabaseConfig ConfigSchema;
    private DatabaseConfig ConfigSystem;
    private Map<Pattern, String> DatabaseMessages = new HashMap<Pattern, String>();
    private final Pattern REGEX_DML_INSERT = Pattern.compile("(?i)^\\s*insert\\s+.*");
    private final Pattern REGEX_DML_UPDATE = Pattern.compile("(?i)^\\s*update\\s+.*");
    private final Pattern REGEX_DML_DELETE = Pattern.compile("(?i)^\\s*delete\\s+.*");
    private final Pattern REGEX_TABLE_CREATE = Pattern.compile("(?i)^\\s*create\\s+table\\s+.*");
    private final Pattern REGEX_TABLE_ALTER = Pattern.compile("(?i)^\\s*alter\\s+table\\s+.*");
    private final Pattern REGEX_COMMENT_CREATE = Pattern.compile("(?i)^\\s*comment\\s+on\\s+.*");
    private final Pattern REGEX_INDEX_CREATE = Pattern.compile("(?i)^\\s*create\\s+index\\s+.*");
    private final Pattern REGEX_TABLE_TRUNCATE = Pattern.compile("(?i)^\\s*truncate\\s+table\\s+.*");

    public DbProviderBase() {
        this.DatabaseMessages.put(this.REGEX_DML_INSERT, "%d row%s created.");
        this.DatabaseMessages.put(this.REGEX_DML_UPDATE, "%d row%s updated.");
        this.DatabaseMessages.put(this.REGEX_DML_DELETE, "%d row%s deleted.");
        this.DatabaseMessages.put(this.REGEX_TABLE_CREATE, "Table created.");
        this.DatabaseMessages.put(this.REGEX_TABLE_ALTER, "Table altered.");
        this.DatabaseMessages.put(this.REGEX_COMMENT_CREATE, "Comment created.");
        this.DatabaseMessages.put(this.REGEX_INDEX_CREATE, "Index created.");
        this.DatabaseMessages.put(this.REGEX_TABLE_TRUNCATE, "Table truncated.");
    }

    protected void addDatabaseMessage(Pattern pattern, String string) {
        this.DatabaseMessages.put(pattern, string);
    }

    protected void setConfig(String string, String string2, DatabaseConfig databaseConfig, DatabaseConfig databaseConfig2) throws Exception {
        Constructor<?> constructor;
        Object object;
        this.ConfigSchema = databaseConfig;
        if (this.ConfigSchema != null) {
            object = Class.forName(this.ConfigSchema.DbHandler);
            constructor = ((Class)object).getConstructor(DatabaseConfig.class, String.class, String.class);
            this.HandlerSchema = (DbHandler)constructor.newInstance(databaseConfig, string, string2);
        }
        this.ConfigSystem = databaseConfig2;
        if (this.ConfigSystem != null) {
            object = Class.forName(this.ConfigSystem.DbHandler);
            constructor = ((Class)object).getConstructor(DatabaseConfig.class, String.class, String.class);
            this.HandlerSystem = (DbHandler)constructor.newInstance(this.ConfigSystem, string, string2);
        }
        object = null;
        constructor = null;
        if (this.HandlerSchema != null) {
            object = this.HandlerSchema.getCodeBlockDeclare();
            constructor = this.HandlerSchema.getCodeBlockBegin();
        } else if (this.HandlerSystem != null) {
            object = this.HandlerSystem.getCodeBlockDeclare();
            constructor = this.HandlerSystem.getCodeBlockBegin();
        }
        if (!Util.isBlank((String)object)) {
            this.addDatabaseMessage(Pattern.compile("(?i)^\\s*" + (String)object + "\\s+.*"), "Procedure executed.");
        }
        if (!Util.isBlank((String)((Object)constructor))) {
            this.addDatabaseMessage(Pattern.compile("(?i)^\\s*" + (String)((Object)constructor) + "\\s+.*"), "Procedure executed.");
        }
    }

    public boolean getHandlerPrimaryIsSystem() {
        return this.HandlerSystem != null;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Database handler is required for SQL constructs")
    public DbHandler getHandler(boolean bl) {
        if (bl) {
            return this.HandlerSystem;
        }
        return this.HandlerSchema;
    }

    public String getUser(boolean bl) {
        String string = null;
        if (bl) {
            if (this.ConfigSystem != null) {
                string = this.ConfigSystem.User;
            }
        } else if (this.ConfigSchema != null) {
            string = this.ConfigSchema.User;
        }
        return string;
    }

    public String getURL() {
        if (this.HandlerSchema != null) {
            return this.HandlerSchema.getURL();
        }
        if (this.HandlerSystem != null) {
            return this.HandlerSystem.getURL();
        }
        return null;
    }

    public String getPKConstraintName(Table table) {
        if (Util.isBlank(table.NamePK)) {
            return table.Name + "_PK";
        }
        return table.NamePK;
    }

    public String processSQLParameters(String string, Map<String, String> map, String string2) throws Exception {
        return string;
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Encoding new line is not a material issue")
    public String processScript(String string, Script script, Map<String, String> map, PrintWriter printWriter) throws Exception {
        String string2 = string + "/" + script.Name;
        printWriter.printf("/* Changes sourced from script %s */\n", script.Name);
        printWriter.println();
        byte[] byArray = Files.readAllBytes(Paths.get(string2, new String[0]));
        printWriter.println(new String(byArray));
        printWriter.println();
        return new String(byArray);
    }

    public List<String> scanSQLForParameters(String string) {
        return new ArrayList<String>();
    }

    public List<String> scanScriptForParameters(String string, Script script) throws IOException {
        return new ArrayList<String>();
    }

    public String getDatabaseResponse(String string, int n) {
        String string2 = null;
        for (Map.Entry<Pattern, String> entry : this.DatabaseMessages.entrySet()) {
            if (!entry.getKey().matcher(string).matches()) continue;
            string2 = String.format(entry.getValue(), n, n == 1 ? "" : "s");
            break;
        }
        return string2;
    }
}

