/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database.Providers;

import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Pdr.Database.Config.Column;
import au.com.aemo.Pdr.Database.Config.ColumnType;
import au.com.aemo.Pdr.Database.Config.DatabaseType;
import au.com.aemo.Pdr.Database.Config.Table;
import au.com.aemo.Pdr.Database.Providers.DbProviderBase;
import au.com.aemo.Pdr.Database.Providers.DbProviderInt;
import java.sql.Connection;

public class DbProviderMySQL
extends DbProviderBase
implements DbProviderInt {
    private static final String DELIMITER = ";";

    @Override
    public DatabaseType getId() {
        return DatabaseType.MYSQL;
    }

    @Override
    public String getHandlerClassName() {
        return "au.com.aemo.Common.Database.DbHandlerMySQL";
    }

    @Override
    public String getDriverClassName() {
        return "com.mysql.cj.jdbc.Driver";
    }

    @Override
    public String getDbDateFormat() {
        return "%Y/%m/%d %H:%i:%s.%f";
    }

    private String getColumnType(Column column) throws Exception {
        if (column.Type == ColumnType.CHAR) {
            return "char(" + column.Length + ")";
        }
        if (column.Type == ColumnType.DATE) {
            return "datetime";
        }
        if (column.Type == ColumnType.NUMBER) {
            return "numeric(" + column.Length + "," + column.Scale + ")";
        }
        if (column.Type == ColumnType.TIMESTAMP) {
            return "Timestamp(" + column.Length + ")";
        }
        if (column.Type == ColumnType.VARCHAR2) {
            return "varchar(" + column.Length + ")";
        }
        throw new Exception("Unsupported type " + String.valueOf((Object)column.Type) + " for column " + column.Name);
    }

    @Override
    public String generateSQL(Table table, Connection connection, DbHandler dbHandler) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (connection != null) {
            bl = dbHandler.checkTableExists(connection, null, table.Name);
        }
        if (bl) {
            for (Column column : table.Columns) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\r\n");
                }
                if (dbHandler.checkColumnExists(connection, null, table.Name, column.Name)) {
                    stringBuilder.append("ALTER TABLE ");
                    stringBuilder.append(table.Name);
                    stringBuilder.append(" MODIFY ");
                    stringBuilder.append(column.Name);
                    stringBuilder.append(" ");
                    stringBuilder.append(this.getColumnType(column));
                } else {
                    stringBuilder.append("ALTER TABLE ");
                    stringBuilder.append(table.Name);
                    stringBuilder.append(" ADD ");
                    stringBuilder.append(column.Name);
                    stringBuilder.append(" ");
                    stringBuilder.append(this.getColumnType(column));
                }
                if (!Util.isBlank(column.Comment)) {
                    stringBuilder.append(" comment '");
                    stringBuilder.append(column.Comment);
                    stringBuilder.append("'");
                }
                stringBuilder.append(DELIMITER);
                stringBuilder.append("\r\n");
            }
        } else {
            stringBuilder.append("CREATE TABLE ");
            stringBuilder.append(table.Name);
            stringBuilder.append(" ( ");
            String string = "";
            boolean bl2 = false;
            for (Column column : table.Columns) {
                stringBuilder.append("\r\n");
                stringBuilder.append("    ");
                stringBuilder.append(string);
                stringBuilder.append(column.Name);
                stringBuilder.append(" ");
                stringBuilder.append(this.getColumnType(column));
                if (column.PK) {
                    stringBuilder.append(" NOT NULL");
                    bl2 = true;
                }
                if (!Util.isBlank(column.Comment)) {
                    stringBuilder.append(" comment '");
                    stringBuilder.append(column.Comment);
                    stringBuilder.append("'");
                }
                string = ",";
            }
            stringBuilder.append("\r\n");
            stringBuilder.append(")");
            stringBuilder.append(DELIMITER);
            stringBuilder.append("\r\n");
            if (bl2) {
                stringBuilder.append("ALTER TABLE ");
                stringBuilder.append(table.Name);
                stringBuilder.append(" add primary key (");
                string = "";
                for (Column column : table.Columns) {
                    if (!column.PK) continue;
                    stringBuilder.append(string);
                    stringBuilder.append(column.Name);
                    string = ",";
                }
                stringBuilder.append(")");
                stringBuilder.append(DELIMITER);
                stringBuilder.append("\r\n");
            }
        }
        if (!Util.isBlank(table.Comment)) {
            stringBuilder.append("\r\n");
            stringBuilder.append("ALTER TABLE ");
            stringBuilder.append(table.Name);
            stringBuilder.append(" COMMENT '");
            stringBuilder.append(table.Comment);
            stringBuilder.append("'");
            stringBuilder.append(DELIMITER);
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }
}

