/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Pdr.Database.Providers;

import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Pdr.Database.Config.Column;
import au.com.aemo.Pdr.Database.Config.ColumnType;
import au.com.aemo.Pdr.Database.Config.DatabaseType;
import au.com.aemo.Pdr.Database.Config.Script;
import au.com.aemo.Pdr.Database.Config.Table;
import au.com.aemo.Pdr.Database.Providers.DbProviderBase;
import au.com.aemo.Pdr.Database.Providers.DbProviderInt;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbProviderOracle
extends DbProviderBase
implements DbProviderInt {
    private static Logger logger = LoggerFactory.getLogger(DbProviderOracle.class);
    private static final String DELIMITER = ";";
    private static final Pattern REGEX_SCRIPT_PARAM = Pattern.compile("&([A-Za-z0-9_]+).");
    private final Pattern REGEX_TABLESPACE_CREATE = Pattern.compile("(?i)^\\s*create\\s+tablespace\\s+.*");
    private final Pattern REGEX_TABLESPACE_TEMP_CREATE = Pattern.compile("(?i)^\\s*create\\s+temporary\\s+tablespace\\s+.*");
    private final Pattern REGEX_USER_CREATE = Pattern.compile("(?i)^\\s*create\\s+user\\s+.*");
    private final Pattern REGEX_USER_ALTER = Pattern.compile("(?i)^\\s*alter\\s+user\\s+.*");
    private final Pattern REGEX_GRANT = Pattern.compile("(?i)^\\s*grant\\s+.*");

    public DbProviderOracle() {
        this.addDatabaseMessage(this.REGEX_TABLESPACE_CREATE, "Tablespace created.");
        this.addDatabaseMessage(this.REGEX_TABLESPACE_TEMP_CREATE, "Tablespace created.");
        this.addDatabaseMessage(this.REGEX_USER_CREATE, "User created.");
        this.addDatabaseMessage(this.REGEX_USER_ALTER, "User altered.");
        this.addDatabaseMessage(this.REGEX_GRANT, "Grant succeeded.");
    }

    @Override
    public DatabaseType getId() {
        return DatabaseType.ORACLE;
    }

    @Override
    public String getHandlerClassName() {
        return "au.com.aemo.Common.Database.DbHandlerOracle";
    }

    @Override
    public String getDriverClassName() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public String getDbDateFormat() {
        return "YYYY/MM/DD HH24:MI:SS";
    }

    private String getColumnType(Column column) throws Exception {
        if (column.Type == ColumnType.CHAR) {
            return "CHAR(" + column.Length + ")";
        }
        if (column.Type == ColumnType.DATE) {
            return "DATE";
        }
        if (column.Type == ColumnType.NUMBER) {
            return "NUMBER(" + column.Length + "," + column.Scale + ")";
        }
        if (column.Type == ColumnType.TIMESTAMP) {
            return "TIMESTAMP(" + column.Length + ")";
        }
        if (column.Type == ColumnType.VARCHAR2) {
            return "VARCHAR2(" + column.Length + ")";
        }
        throw new Exception("Unsupported type " + String.valueOf((Object)column.Type) + " for column " + column.Name);
    }

    @Override
    public String generateSQL(Table table, Connection connection, DbHandler dbHandler) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (connection != null) {
            bl = dbHandler.checkTableExists(connection, null, table.Name);
        }
        if (bl) {
            for (Column column : table.Columns) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\r\n");
                }
                if (dbHandler.checkColumnExists(connection, null, table.Name, column.Name)) {
                    stringBuilder.append("ALTER TABLE ");
                    stringBuilder.append(table.Name);
                    stringBuilder.append(" MODIFY ");
                    stringBuilder.append(column.Name);
                    stringBuilder.append(" ");
                    stringBuilder.append(this.getColumnType(column));
                } else {
                    stringBuilder.append("ALTER TABLE ");
                    stringBuilder.append(table.Name);
                    stringBuilder.append(" ADD ");
                    stringBuilder.append(column.Name);
                    stringBuilder.append(" ");
                    stringBuilder.append(this.getColumnType(column));
                }
                stringBuilder.append(DELIMITER);
                stringBuilder.append("\r\n");
            }
        } else {
            stringBuilder.append("CREATE TABLE ");
            stringBuilder.append(table.Name);
            stringBuilder.append(" ( ");
            Object object = "";
            boolean bl2 = false;
            for (Column column : table.Columns) {
                stringBuilder.append("\r\n");
                stringBuilder.append("    ");
                stringBuilder.append((String)object);
                stringBuilder.append(column.Name);
                stringBuilder.append(" ");
                stringBuilder.append(this.getColumnType(column));
                if (column.PK) {
                    stringBuilder.append(" NOT NULL");
                    bl2 = true;
                }
                object = ",";
            }
            stringBuilder.append("\r\n");
            stringBuilder.append(")");
            if (!Util.isBlank(table.Tablespace)) {
                stringBuilder.append("\r\n");
                stringBuilder.append("tablespace ");
                stringBuilder.append(table.Tablespace);
            }
            stringBuilder.append(DELIMITER);
            stringBuilder.append("\r\n");
            if (bl2) {
                stringBuilder.append("ALTER TABLE ");
                stringBuilder.append(table.Name);
                stringBuilder.append(" add constraint ");
                stringBuilder.append(this.getPKConstraintName(table));
                stringBuilder.append(" primary key (");
                object = "";
                for (Column column : table.Columns) {
                    if (!column.PK) continue;
                    stringBuilder.append((String)object);
                    stringBuilder.append(column.Name);
                    object = ",";
                }
                stringBuilder.append(")");
                if (!Util.isBlank(table.TablespacePK)) {
                    stringBuilder.append(" using index tablespace ");
                    stringBuilder.append(table.TablespacePK);
                }
                stringBuilder.append(DELIMITER);
                stringBuilder.append("\r\n");
            }
        }
        if (!Util.isBlank(table.Comment)) {
            stringBuilder.append("\r\n");
            stringBuilder.append("COMMENT ON TABLE ");
            stringBuilder.append(table.Name);
            stringBuilder.append(" IS '");
            stringBuilder.append(table.Comment);
            stringBuilder.append("'");
            stringBuilder.append(DELIMITER);
            stringBuilder.append("\r\n");
        }
        for (Column column : table.Columns) {
            if (Util.isBlank(column.Comment)) continue;
            stringBuilder.append("COMMENT ON COLUMN ");
            stringBuilder.append(table.Name);
            stringBuilder.append(".");
            stringBuilder.append(column.Name);
            stringBuilder.append(" IS '");
            stringBuilder.append(column.Comment);
            stringBuilder.append("'");
            stringBuilder.append(DELIMITER);
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String processSQLParameters(String string, Map<String, String> map, String string2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Matcher matcher = REGEX_SCRIPT_PARAM.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group(1).toUpperCase();
            String string4 = map.get(string3);
            if (string4 != null) {
                Util_Logger.debug(logger, "Replacing [" + string3 + "] with [" + string4 + "] in script " + string2);
                stringBuilder.append(string.substring(n, matcher.start()));
                stringBuilder.append(string4);
                n = matcher.end();
                continue;
            }
            Util_Logger.error(logger, "Detected missing parameter [" + string3 + "] in script: " + string2);
        }
        stringBuilder.append(string.substring(n, string.length()));
        return stringBuilder.toString();
    }

    @Override
    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Encoding new line is not a material issue")
    public String processScript(String string, Script script, Map<String, String> map, PrintWriter printWriter) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string + "/" + script.Name;
        printWriter.printf("/* Changes sourced from script %s */\n", script.Name);
        printWriter.println();
        boolean bl = false;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));){
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                string3 = string3.trim();
                boolean bl2 = true;
                if (string3.toUpperCase().startsWith("WHENEVER")) {
                    bl2 = false;
                } else if (string3.toUpperCase().startsWith("PROMPT ")) {
                    bl2 = false;
                } else if (string3.toUpperCase().startsWith("REM ")) {
                    bl2 = false;
                } else if (string3.toUpperCase().startsWith("/*") && string3.toUpperCase().endsWith("*/")) {
                    bl2 = true;
                } else if (string3.toUpperCase().startsWith("/*")) {
                    bl2 = false;
                    bl = true;
                } else if (string3.toUpperCase().endsWith("*/")) {
                    bl2 = false;
                    bl = false;
                } else {
                    boolean bl3 = bl2 = !bl;
                }
                if (bl2) {
                    String string4 = this.processSQLParameters(string3, map, script.Name);
                    printWriter.println(string4);
                    stringBuilder.append(string4);
                }
                string3 = bufferedReader.readLine();
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public List<String> scanSQLForParameters(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = REGEX_SCRIPT_PARAM.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1).toUpperCase();
            if (arrayList.contains(string2)) continue;
            Util_Logger.debug(logger, "Detected parameter [" + string2 + "] in " + string);
            arrayList.add(string2.toUpperCase());
        }
        return arrayList;
    }

    @Override
    public List<String> scanScriptForParameters(String string, Script script) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string + "/" + script.Name;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));){
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                arrayList.addAll(this.scanSQLForParameters(string3));
                string3 = bufferedReader.readLine();
            }
        }
        return arrayList;
    }
}

